/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.types.Content;
import com.google.genai.types.Part;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ChatBase {
    protected final List<Content> comprehensiveHistory = new ArrayList<Content>();
    protected final List<Content> curatedHistory = new ArrayList<Content>();

    ChatBase(List<Content> comprehensiveHistory, List<Content> curatedHistory) {
    }

    protected void recordHistory(List<Content> currentHistory) {
        this.comprehensiveHistory.addAll(currentHistory);
        List<Content> validatedHistory = this.validateHistory(currentHistory);
        this.curatedHistory.addAll(validatedHistory);
    }

    protected boolean validateContent(Content content) {
        if (content.parts().isPresent()) {
            for (Part part : content.parts().get()) {
                if (!part.equals(Part.builder().build())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateContents(List<Content> contents) {
        for (Content content : contents) {
            if (this.validateContent(content)) continue;
            return false;
        }
        return true;
    }

    protected List<Content> validateHistory(List<Content> history) {
        ArrayList<Content> validatedHistory = new ArrayList<Content>();
        ArrayList<Content> currentInput = new ArrayList<Content>();
        ArrayList<Content> currentOutput = new ArrayList<Content>();
        List<String> validRoles = Arrays.asList("user", "model");
        for (int i = 0; i < history.size(); ++i) {
            if (i == 0 && history.get(i).role().isPresent() && !history.get(i).role().get().equals("user")) {
                throw new IllegalArgumentException("The first message in the history must be from the user.");
            }
            if (i < history.size() && !validRoles.contains(history.get(i).role().get())) {
                throw new IllegalArgumentException("The role of the message must be either 'user' or 'model'.");
            }
            if (history.get(i).role().isPresent() && history.get(i).role().get().equals("user")) {
                if (!this.validateContent(history.get(i))) continue;
                currentInput.add(history.get(i));
                continue;
            }
            boolean isValid = true;
            while (i < history.size() && history.get(i).role().isPresent() && history.get(i).role().get().equals("model")) {
                currentOutput.add(history.get(i));
                if (isValid && !this.validateContent(history.get(i))) {
                    isValid = false;
                }
                ++i;
            }
            if (!isValid) continue;
            validatedHistory.addAll(currentInput);
            validatedHistory.addAll(currentOutput);
            currentInput = new ArrayList();
            currentOutput = new ArrayList();
        }
        return validatedHistory;
    }

    public List<Content> getHistory(boolean curated) {
        if (curated) {
            return this.curatedHistory;
        }
        return this.comprehensiveHistory;
    }
}

