/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.genai.ApiClient;
import com.google.genai.JsonSerializable;
import com.google.genai.types.Content;
import com.google.genai.types.Part;
import com.google.genai.types.PrebuiltVoiceConfig;
import com.google.genai.types.Schema;
import com.google.genai.types.SpeechConfig;
import com.google.genai.types.Tool;
import com.google.genai.types.VoiceConfig;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class Transformers {
    private Transformers() {
    }

    public static String tModel(ApiClient apiClient, Object origin) {
        String model;
        if (origin == null) {
            return null;
        }
        if (origin instanceof String) {
            model = (String)origin;
        } else if (origin instanceof JsonNode) {
            model = JsonSerializable.toJsonString((JsonNode)origin);
            model = model.replace("\"", "");
        } else {
            throw new IllegalArgumentException("Unsupported model type: " + origin.getClass());
        }
        if (apiClient.vertexAI()) {
            if (model.startsWith("publishers/") || model.startsWith("projects/") || model.startsWith("models/")) {
                return model;
            }
            if (model.contains("/")) {
                String[] parts = model.split("/", 2);
                return String.format("publishers/%s/models/%s", parts[0], parts[1]);
            }
            return "publishers/google/models/" + model;
        }
        if (model.startsWith("models/") || model.startsWith("tunedModels/")) {
            return model;
        }
        return "models/" + model;
    }

    public static List<Content> tContents(ApiClient apiClient, Object contents) {
        if (contents == null) {
            return null;
        }
        if (contents instanceof String) {
            return ImmutableList.of((Object)Content.builder().role("user").parts((List<Part>)ImmutableList.of((Object)Part.builder().text((String)contents).build())).build());
        }
        if (contents instanceof Content) {
            return ImmutableList.of((Object)((Content)contents));
        }
        if (contents instanceof List) {
            return (List)contents;
        }
        if (contents instanceof JsonNode) {
            return (List)JsonSerializable.objectMapper.convertValue((Object)((JsonNode)contents), (TypeReference)new TypeReference<List<Content>>(){});
        }
        throw new IllegalArgumentException("Unsupported contents type: " + contents.getClass());
    }

    public static Content tContent(ApiClient apiClient, Object content) {
        if (content == null) {
            return null;
        }
        if (content instanceof String) {
            return Content.builder().role("user").parts((List<Part>)ImmutableList.of((Object)Part.builder().text((String)content).build())).build();
        }
        if (content instanceof Content) {
            return (Content)content;
        }
        if (content instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)content, Content.class);
        }
        throw new IllegalArgumentException("Unsupported content type: " + content.getClass());
    }

    public static Schema tSchema(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Schema) {
            return (Schema)origin;
        }
        if (origin instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)origin, Schema.class);
        }
        throw new IllegalArgumentException("Unsupported schema type: " + origin.getClass());
    }

    public static SpeechConfig tSpeechConfig(ApiClient apiClient, Object speechConfig) {
        if (speechConfig == null) {
            return null;
        }
        if (speechConfig instanceof String) {
            return SpeechConfig.builder().voiceConfig(VoiceConfig.builder().prebuiltVoiceConfig(PrebuiltVoiceConfig.builder().voiceName((String)speechConfig).build()).build()).build();
        }
        if (speechConfig instanceof SpeechConfig) {
            return (SpeechConfig)speechConfig;
        }
        if (speechConfig instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)speechConfig, SpeechConfig.class);
        }
        throw new IllegalArgumentException("Unsupported speechConfig type:" + speechConfig.getClass());
    }

    public static List<Tool> tTools(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof List) {
            return (List)origin;
        }
        if (origin instanceof JsonNode) {
            return (List)JsonSerializable.objectMapper.convertValue((Object)((JsonNode)origin), (TypeReference)new TypeReference<List<Tool>>(){});
        }
        throw new IllegalArgumentException("Unsupported tools type: " + origin.getClass());
    }

    public static Tool tTool(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Tool) {
            return (Tool)origin;
        }
        if (origin instanceof JsonNode) {
            return (Tool)JsonSerializable.objectMapper.convertValue((Object)((JsonNode)origin), (TypeReference)new TypeReference<Tool>(){});
        }
        throw new IllegalArgumentException("Unsupported tool type: " + origin.getClass());
    }

    public static Object tBytes(ApiClient apiClient, Object origin) {
        return origin;
    }

    public static String tCachedContentName(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof String) {
            return Transformers.getResourceName(apiClient, (String)origin, "cachedContents");
        }
        if (origin instanceof JsonNode) {
            String cachedContentName = JsonSerializable.toJsonString((JsonNode)origin);
            cachedContentName = cachedContentName.replace("\"", "");
            return Transformers.getResourceName(apiClient, cachedContentName, "cachedContents");
        }
        throw new IllegalArgumentException("Unsupported cached content name type: " + origin.getClass());
    }

    public static @Nullable List<Object> tContentsForEmbed(ApiClient apiClient, Object origin) {
        List contents;
        if (origin == null) {
            return null;
        }
        if (origin instanceof List) {
            contents = (List)origin;
        } else if (origin instanceof JsonNode) {
            contents = (List)JsonSerializable.objectMapper.convertValue((Object)((JsonNode)origin), (TypeReference)new TypeReference<List<Content>>(){});
        } else {
            throw new IllegalArgumentException("Unsupported contents type: " + origin.getClass());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Content content : contents) {
            if (!apiClient.vertexAI()) {
                result.add(content);
                continue;
            }
            for (Part part : content.parts().orElse((List<Part>)ImmutableList.of())) {
                part.text().ifPresent(result::add);
            }
        }
        return result;
    }

    private static String getResourceName(ApiClient apiClient, String resourceName, String resourcePrefix) {
        if (apiClient.vertexAI()) {
            if (resourceName.startsWith("projects/")) {
                return resourceName;
            }
            if (resourceName.startsWith("locations/")) {
                return String.format("projects/%s/%s", apiClient.project(), resourceName);
            }
            if (resourceName.startsWith(resourcePrefix + "/")) {
                return String.format("projects/%s/locations/%s/%s", apiClient.project(), apiClient.location(), resourceName);
            }
            return String.format("projects/%s/locations/%s/%s/%s", apiClient.project(), apiClient.location(), resourcePrefix, resourceName);
        }
        if (resourceName.startsWith(resourcePrefix + "/")) {
            return resourceName;
        }
        return String.format("%s/%s", resourcePrefix, resourceName);
    }
}

