/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide.util;

public class StringUtils {
    public static final String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        int i = 0;
        while (i < arr.length) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        break;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    break;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        break;
                    }
                    sb.append('*');
                    break;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        break;
                    }
                    sb.append('?');
                    break;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    break;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    break;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    break;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        break;
                    }
                    sb.append('!');
                    break;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    break;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    break;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        break;
                    }
                    sb.append(',');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

