/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.commands;

import java.util.List;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandStack;

public class MultiActionCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    private JasperReportsContext jasperReportsContext;
    private ReportContext reportContext;
    private List<AbstractAction> actions;
    private CommandStack individualResizeCommandStack;

    public MultiActionCommand(List<AbstractAction> actions, JasperReportsContext jasperReportsContext, ReportContext reportContext) {
        this.actions = actions;
        this.jasperReportsContext = jasperReportsContext;
        this.reportContext = reportContext;
        this.individualResizeCommandStack = new CommandStack();
    }

    @Override
    public void execute() throws CommandException {
        if (this.actions != null) {
            for (AbstractAction action : this.actions) {
                action.init(this.jasperReportsContext, this.reportContext);
                action.setCommandStack(this.individualResizeCommandStack);
                try {
                    action.run();
                }
                catch (ActionException e) {
                    throw new CommandException(e);
                }
            }
        }
    }

    @Override
    public void undo() {
        this.individualResizeCommandStack.undoAll();
    }

    @Override
    public void redo() {
        this.individualResizeCommandStack.redoAll();
    }
}

