/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.support;

import com.kms.katalon.composer.objectrepository.part.TestObjectPart;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class XpathValueEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private IEventBroker eventBroker;
    private TestObjectPart testObjectPart;

    public XpathValueEditingSupport(TableViewer viewer, IEventBroker eventBroker, TestObjectPart testObjectPart) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.eventBroker = eventBroker;
        this.testObjectPart = testObjectPart;
    }

    protected CellEditor getCellEditor(Object element) {
        return new MultilineTextCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof WebElementXpathEntity) {
            WebElementXpathEntity property = (WebElementXpathEntity)element;
            return property.getValue();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof WebElementXpathEntity && value instanceof String) {
            this.testObjectPart.executeOperation((IUndoableOperation)new XpathValueChangeOperation((WebElementXpathEntity)element, (String)value));
        }
    }

    private class MultilineTextCellEditor
    extends TextCellEditor {
        public MultilineTextCellEditor(Composite parent) {
            super(parent, 2626);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData data = new CellEditor.LayoutData();
            data.minimumHeight = 100;
            data.verticalAlignment = 128;
            return data;
        }
    }

    private class XpathValueChangeOperation
    extends AbstractOperation {
        private WebElementXpathEntity xpath;
        private String value;
        private String oldValue;

        public XpathValueChangeOperation(WebElementXpathEntity xpath, String value) {
            super(XpathValueChangeOperation.class.getName());
            this.xpath = xpath;
            this.oldValue = xpath.getValue();
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.value.equals(this.oldValue)) {
                return Status.CANCEL_STATUS;
            }
            return this.doSetItemValue(this.value);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.value);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.oldValue);
        }

        protected IStatus doSetItemValue(String itemValue) {
            this.xpath.setValue(itemValue);
            XpathValueEditingSupport.this.viewer.update((Object)this.xpath, null);
            XpathValueEditingSupport.this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)XpathValueEditingSupport.this.viewer);
            return Status.OK_STATUS;
        }
    }
}

