/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project;

import java.util.List;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.api.transform.VoidJsonUnmarshaller;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.internal.model.transform.FieldJsonUnmarshaller;
import org.qas.qtest.api.internal.model.transform.ListFieldJsonUnmarshaller;
import org.qas.qtest.api.services.plan.model.Release;
import org.qas.qtest.api.services.project.ProjectService;
import org.qas.qtest.api.services.project.model.CreateCustomFieldRequest;
import org.qas.qtest.api.services.project.model.CreateModuleRequest;
import org.qas.qtest.api.services.project.model.CreateProjectRequest;
import org.qas.qtest.api.services.project.model.DeleteModuleRequest;
import org.qas.qtest.api.services.project.model.GetFieldsRequest;
import org.qas.qtest.api.services.project.model.GetModuleRequest;
import org.qas.qtest.api.services.project.model.GetProjectRequest;
import org.qas.qtest.api.services.project.model.GetUserPermissionsRequest;
import org.qas.qtest.api.services.project.model.LinkTestCaseRequirementRequest;
import org.qas.qtest.api.services.project.model.ListModuleRequest;
import org.qas.qtest.api.services.project.model.ListProjectRequest;
import org.qas.qtest.api.services.project.model.ListReleaseRequest;
import org.qas.qtest.api.services.project.model.ListUserPermissionsRequest;
import org.qas.qtest.api.services.project.model.Module;
import org.qas.qtest.api.services.project.model.MoveModuleRequest;
import org.qas.qtest.api.services.project.model.Project;
import org.qas.qtest.api.services.project.model.SearchModuleRequest;
import org.qas.qtest.api.services.project.model.UpdateCustomFieldRequest;
import org.qas.qtest.api.services.project.model.UpdateModuleRequest;
import org.qas.qtest.api.services.project.model.UpdateSystemFieldRequest;
import org.qas.qtest.api.services.project.model.UserPermissions;
import org.qas.qtest.api.services.project.model.transform.CreateCustomFieldRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.CreateModuleRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.CreateProjectRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.DeleteModuleRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.GetFieldsRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.GetModuleRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.GetProjectRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.GetUserPermissionsRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.LinkTestCaseRequirementRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.ListModuleJsonUnmarshaller;
import org.qas.qtest.api.services.project.model.transform.ListModuleRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.ListProjectJsonUnmarshaller;
import org.qas.qtest.api.services.project.model.transform.ListProjectRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.ListReleaseJsonUnmarshaller;
import org.qas.qtest.api.services.project.model.transform.ListReleaseRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.ListUserPermissionsJsonUnmarshaller;
import org.qas.qtest.api.services.project.model.transform.ListUserPermissionsRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.ModuleJsonUnmarshaller;
import org.qas.qtest.api.services.project.model.transform.MoveModuleRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.ProjectJsonUnmarshaller;
import org.qas.qtest.api.services.project.model.transform.SearchModuleRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.UpdateCustomFieldRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.UpdateModuleRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.UpdateSystemFieldRequestMarshaller;
import org.qas.qtest.api.services.project.model.transform.UserPermissionsJsonUnmarshaller;

public class ProjectServiceClient
extends QTestApiWebServiceClient<ProjectServiceClient>
implements ProjectService {
    public ProjectServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public ProjectServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public ProjectServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public ProjectServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public ProjectServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public ProjectServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public List<Project> listProject(ListProjectRequest listProjectRequest) throws AuthServiceException {
        try {
            Object request = new ListProjectRequestMarshaller().marshall(listProjectRequest);
            return this.invoke((Request)request, ListProjectJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list project request", ex);
        }
    }

    @Override
    public Project createProject(CreateProjectRequest createProjectRequest) throws AuthServiceException {
        try {
            Object request = new CreateProjectRequestMarshaller().marshall(createProjectRequest);
            return this.invoke((Request)request, ProjectJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute create project request", ex);
        }
    }

    @Override
    public Project getProject(GetProjectRequest getProjectRequest) throws AuthServiceException {
        try {
            Request request = new GetProjectRequestMarshaller().marshall(getProjectRequest);
            new ProjectJsonUnmarshaller();
            return this.invoke(request, ProjectJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute get project request", ex);
        }
    }

    @Override
    public Module updateModule(UpdateModuleRequest moduleRequest) throws AuthServiceException {
        try {
            Request request = new UpdateModuleRequestMarshaller().marshall(moduleRequest);
            return this.invoke(request, ModuleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute update module request", ex);
        }
    }

    @Override
    public Module moveModule(MoveModuleRequest moduleRequest) throws AuthServiceException {
        try {
            Request request = new MoveModuleRequestMarshaller().marshall(moduleRequest);
            return this.invoke(request, ModuleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute move module request", ex);
        }
    }

    @Override
    public Module createModule(CreateModuleRequest createModuleRequest) throws AuthServiceException {
        try {
            Request request = new CreateModuleRequestMarshaller().marshall(createModuleRequest);
            return this.invoke(request, ModuleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute create module request", ex);
        }
    }

    @Override
    public Module getModule(GetModuleRequest getModuleRequest) throws AuthServiceException {
        try {
            Request request = new GetModuleRequestMarshaller().marshall(getModuleRequest);
            return this.invoke(request, ModuleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute get module request", ex);
        }
    }

    @Override
    public List<Module> listModule(ListModuleRequest listModuleRequest) throws AuthServiceException {
        try {
            Request request = new ListModuleRequestMarshaller().marshall(listModuleRequest);
            return this.invoke(request, ListModuleJsonUnmarshaller.getInstance());
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list module request", e);
        }
    }

    @Override
    public List<Release> listRelease(ListReleaseRequest listReleaseRequest) throws AuthServiceException {
        try {
            Object request = new ListReleaseRequestMarshaller().marshall(listReleaseRequest);
            return this.invoke((Request)request, ListReleaseJsonUnmarshaller.getInstance());
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list release request", e);
        }
    }

    @Override
    public List<Module> searchModule(SearchModuleRequest searchModuleRequest) throws AuthServiceException {
        try {
            Request request = new SearchModuleRequestMarshaller().marshall(searchModuleRequest);
            return this.invoke(request, ListModuleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during executing search modules request.", ex);
        }
    }

    @Override
    public void deleteModule(DeleteModuleRequest moduleRequest) throws AuthServiceException {
        try {
            Request request = new DeleteModuleRequestMarshaller().marshall(moduleRequest);
            this.invoke(request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during executing delete module request.", ex);
        }
    }

    @Override
    public void linkTestCaseRequirement(LinkTestCaseRequirementRequest linkTestCaseRequirementRequest) throws AuthClientException {
        try {
            Object request = new LinkTestCaseRequirementRequestMarshaller().marshall(linkTestCaseRequirementRequest);
            this.invoke((Request)request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute link testcase-requirement request", ex);
        }
    }

    @Override
    public Field createCustomField(CreateCustomFieldRequest createCustomFieldRequest) throws AuthServiceException {
        try {
            Object request = new CreateCustomFieldRequestMarshaller().marshall(createCustomFieldRequest);
            return this.invoke((Request)request, FieldJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during creating custom field of specific project", ex);
        }
    }

    @Override
    public List<Field> updateCustomField(UpdateCustomFieldRequest updateCustomFieldRequest) throws AuthServiceException {
        try {
            Object request = new UpdateCustomFieldRequestMarshaller().marshall(updateCustomFieldRequest);
            return this.invoke((Request)request, ListFieldJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during update custom field of specific project", ex);
        }
    }

    @Override
    public Field updateSystemField(UpdateSystemFieldRequest updateSystemFieldRequest) throws AuthServiceException {
        try {
            Object request = new UpdateSystemFieldRequestMarshaller().marshall(updateSystemFieldRequest);
            return this.invoke((Request)request, FieldJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during updating system field of specific project", ex);
        }
    }

    @Override
    public List<Field> getFields(GetFieldsRequest getFieldsRequest) throws AuthServiceException {
        try {
            Object request = new GetFieldsRequestMarshaller().marshall(getFieldsRequest);
            return this.invoke((Request)request, ListFieldJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during getting all fields.", ex);
        }
    }

    @Override
    public UserPermissions getUserPermissions(GetUserPermissionsRequest getUserPermissionsRequest) throws AuthServiceException {
        try {
            Object request = new GetUserPermissionsRequestMarshaller().marshall(getUserPermissionsRequest);
            return this.invoke((Request)request, UserPermissionsJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during getting user permissions.", ex);
        }
    }

    @Override
    public List<UserPermissions> listUserPermissions(ListUserPermissionsRequest listUserPermissionsRequest) throws AuthServiceException {
        try {
            Object request = new ListUserPermissionsRequestMarshaller().marshall(listUserPermissionsRequest);
            return this.invoke((Request)request, ListUserPermissionsJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during listing user permissions.", ex);
        }
    }
}

