/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.SearchModuleRequest;
import org.qas.qtest.api.services.project.model.transform.AbstractModuleRequestMarshaller;

public final class SearchModuleRequestMarshaller
extends AbstractModuleRequestMarshaller<SearchModuleRequest> {
    @Override
    public Request marshall(SearchModuleRequest moduleRequest) throws Exception {
        moduleRequest = ApiPreconditions.notNull(moduleRequest);
        SearchModuleRequestMarshaller.validateProjectId(moduleRequest.getProjectId());
        ApiPreconditions.checkArgument(moduleRequest.getParentId() == null || moduleRequest.getParentId() > 0L, "Invalid parent module identifier passed to marshall(...)");
        ApiPreconditions.checkArgument(moduleRequest.getQuery() != null && moduleRequest.getQuery().trim().length() > 0, "Invalid query parameter passed to marshall(...)");
        Request request = this.createJsonRequest(moduleRequest, "SearchModule", HttpMethod.GET);
        request.setResourcePath(this.createApiPathBuilder(moduleRequest.getProjectId()).toString());
        if (moduleRequest.getParentId() != null) {
            request.addParameter("parentId", String.valueOf(moduleRequest.getParentId()));
        }
        if (moduleRequest.isIncludeDescendants()) {
            request.addParameter("expand", "descendants");
        }
        request.addParameter("search", moduleRequest.getQuery().trim());
        return request;
    }
}

