/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.artifact.dialog;

import com.katalon.platform.api.exception.PlatformException;
import com.katalon.platform.api.model.FolderEntity;
import com.katalon.platform.api.ui.DialogActionService;
import com.kms.katalon.composer.artifact.constant.StringConstants;
import com.kms.katalon.composer.artifact.core.util.PlatformUtil;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportTestArtifactDialog
extends Dialog {
    private Text txtImportFile;
    private Button btnBrowseImportFile;
    private Text txtTestCaseImportLocation;
    private Button btnBrowseTestCaseImportLocation;
    private Text txtTestObjectImportLocation;
    private Button btnBrowseTestObjectImportLocation;
    private ImportTestArtifactDialogResult dialogResult;

    public ImportTestArtifactDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout glBody = new GridLayout(3, false);
        body.setLayout((Layout)glBody);
        GridData gdBody = new GridData(4, 4, true, true);
        gdBody.widthHint = 500;
        body.setLayoutData((Object)gdBody);
        Label lblChooseImportFile = new Label(body, 0);
        lblChooseImportFile.setText(StringConstants.LBL_CHOOSE_IMPORT_FILE);
        this.txtImportFile = new Text(body, 2048);
        this.txtImportFile.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnBrowseImportFile = new Button(body, 0);
        this.btnBrowseImportFile.setText(StringConstants.BTN_BROWSE);
        Label lblChooseTestCaseImportLocation = new Label(body, 0);
        lblChooseTestCaseImportLocation.setText(StringConstants.LBL_CHOOSE_TEST_CASE_IMPORT_LOCATION);
        this.txtTestCaseImportLocation = new Text(body, 2048);
        this.txtTestCaseImportLocation.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnBrowseTestCaseImportLocation = new Button(body, 0);
        this.btnBrowseTestCaseImportLocation.setText(StringConstants.BTN_BROWSE);
        Label lblChooseTestObjectImportLocation = new Label(body, 0);
        lblChooseTestObjectImportLocation.setText(StringConstants.LBL_CHOOSE_TEST_OBJECT_IMPORT_LOCATION);
        this.txtTestObjectImportLocation = new Text(body, 2048);
        this.txtTestObjectImportLocation.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnBrowseTestObjectImportLocation = new Button(body, 0);
        this.btnBrowseTestObjectImportLocation.setText(StringConstants.BTN_BROWSE);
        this.registerControlListeners();
        return body;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void registerControlListeners() {
        this.txtImportFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImportTestArtifactDialog.this.validateInput();
            }
        });
        this.btnBrowseImportFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell());
                fileDialog.setFilterExtensions(new String[]{"*.zip"});
                String importFileLocation = fileDialog.open();
                ImportTestArtifactDialog.this.txtImportFile.setText(importFileLocation);
                ImportTestArtifactDialog.this.validateInput();
            }
        });
        this.txtTestCaseImportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImportTestArtifactDialog.this.validateInput();
            }
        });
        this.btnBrowseTestCaseImportLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell = e.widget.getDisplay().getActiveShell();
                try {
                    FolderEntity selectedFolder = PlatformUtil.getUIService(DialogActionService.class).showTestCaseFolderSelectionDialog(activeShell, "Select test case folder");
                    String selectedFolderId = selectedFolder.getId();
                    ImportTestArtifactDialog.this.txtTestCaseImportLocation.setText(selectedFolderId);
                }
                catch (PlatformException ex) {
                    MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)ex.getMessage());
                }
                ImportTestArtifactDialog.this.validateInput();
            }
        });
        this.txtTestObjectImportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImportTestArtifactDialog.this.validateInput();
            }
        });
        this.btnBrowseTestObjectImportLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell = e.widget.getDisplay().getActiveShell();
                try {
                    FolderEntity selectedFolder = PlatformUtil.getUIService(DialogActionService.class).showTestObjectFolderSelectionDialog(activeShell, "Select test object folder");
                    String selectedFolderId = selectedFolder.getId();
                    ImportTestArtifactDialog.this.txtTestObjectImportLocation.setText(selectedFolderId);
                }
                catch (PlatformException ex) {
                    MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)ex.getMessage());
                }
                ImportTestArtifactDialog.this.validateInput();
            }
        });
    }

    private void validateInput() {
        boolean isValid = StringUtils.isNotBlank((CharSequence)this.txtImportFile.getText()) && StringUtils.isNotBlank((CharSequence)this.txtTestCaseImportLocation.getText()) && StringUtils.isNotBlank((CharSequence)this.txtTestObjectImportLocation.getText());
        this.getButton(0).setEnabled(isValid);
    }

    protected void okPressed() {
        this.dialogResult = new ImportTestArtifactDialogResult();
        this.dialogResult.setImportFileLocation(this.txtImportFile.getText());
        this.dialogResult.setTestCaseImportLocation(this.txtTestCaseImportLocation.getText());
        this.dialogResult.setTestObjectImportLocation(this.txtTestObjectImportLocation.getText());
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.DIALOG_TITLE_IMPORT_TEST_ARTIFACTS);
    }

    public ImportTestArtifactDialogResult getResult() {
        return this.dialogResult;
    }

    protected boolean isResizable() {
        return true;
    }

    public class ImportTestArtifactDialogResult {
        private String importFileLocation;
        private String testCaseImportLocation;
        private String testObjectImportLocation;

        public String getImportFileLocation() {
            return this.importFileLocation;
        }

        public void setImportFileLocation(String importFileLocation) {
            this.importFileLocation = importFileLocation;
        }

        public String getTestCaseImportLocation() {
            return this.testCaseImportLocation;
        }

        public void setTestCaseImportLocation(String testCaseImportLocation) {
            this.testCaseImportLocation = testCaseImportLocation;
        }

        public String getTestObjectImportLocation() {
            return this.testObjectImportLocation;
        }

        public void setTestObjectImportLocation(String testObjectImportLocation) {
            this.testObjectImportLocation = testObjectImportLocation;
        }
    }
}

