/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.artifact.handler;

import com.katalon.platform.api.model.ExecutionProfileEntity;
import com.katalon.platform.api.model.ProjectEntity;
import com.katalon.platform.api.model.TestCaseEntity;
import com.katalon.platform.api.model.TestObjectEntity;
import com.katalon.platform.api.ui.UISynchronizeService;
import com.kms.katalon.composer.artifact.constant.StringConstants;
import com.kms.katalon.composer.artifact.core.util.KeywordUtil;
import com.kms.katalon.composer.artifact.core.util.PlatformUtil;
import com.kms.katalon.composer.artifact.core.util.TestCaseUtil;
import com.kms.katalon.composer.artifact.core.util.TestObjectUtil;
import com.kms.katalon.composer.artifact.dialog.ExportTestArtifactDialog;
import com.kms.katalon.composer.artifact.util.ZipUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportTestArtifactHandler {
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;
    private Shell activeShell;

    public ExportTestArtifactHandler(Shell shell) {
        this.activeShell = shell;
    }

    public void execute() {
        Trackings.trackOpenExportTestArtifactsDialog();
        ExportTestArtifactDialog dialog = new ExportTestArtifactDialog(this.activeShell);
        if (dialog.open() == 0) {
            ExportTestArtifactDialog.ExportTestArtifactDialogResult result = dialog.getResult();
            List<TestCaseEntity> exportedTestCases = result.getSelectedTestCases();
            List<TestObjectEntity> exportedTestObjects = result.getSelectedTestObjects();
            List<ExecutionProfileEntity> exportedProfiles = result.getSelectedProfiles();
            List<File> exportedKeywords = result.getSelectedKeywords();
            String exportLocation = result.getExportLocation();
            try {
                this.exportTestArtifacts(exportedTestCases, exportedTestObjects, exportedProfiles, exportedKeywords, exportLocation);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_UNABLE_TO_EXPORT_TEST_ARTIFACTS);
                LoggerSingleton.logError((Throwable)e, (String)StringConstants.MSG_UNABLE_TO_EXPORT_TEST_ARTIFACTS);
            }
        }
    }

    private void exportTestArtifacts(final List<TestCaseEntity> testCases, final List<TestObjectEntity> testObjects, final List<ExecutionProfileEntity> profiles, final List<File> keywords, String exportLocation) throws IOException, ZipUtil.FileCompressionException {
        final File exportFolder = new File(exportLocation);
        if (!exportFolder.exists() || !exportFolder.isDirectory()) {
            MessageDialog.openError((Shell)this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_INVALID_EXPORT_LOCATION);
            return;
        }
        final Job exportArtifactsJob = new Job(StringConstants.MSG_EXPORTING_TEST_ARTIFACTS){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    File exportTempFolder = Files.createTempDirectory(StringConstants.IMPORT_EXPORT_EXPORT_TEMP_FOLDER, new FileAttribute[0]).toFile();
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    subMonitor.beginTask("", 100);
                    int numberOfTestScripts = testCases.size();
                    int totalWork = testCases.size() + numberOfTestScripts + testObjects.size() + profiles.size() + keywords.size();
                    int exportTestCaseWork = Math.round((float)testCases.size() * 90.0f / (float)totalWork);
                    SubMonitor exportTestCaseMonitor = subMonitor.split(exportTestCaseWork, 0);
                    exportTestCaseMonitor.beginTask(StringConstants.MSG_EXPORTING_TEST_CASES, 100);
                    ExportTestArtifactHandler.this.exportTestCases(testCases, exportTempFolder, exportTestCaseMonitor);
                    exportTestCaseMonitor.done();
                    int exportTestScriptWork = Math.round((float)testCases.size() * 90.0f / (float)totalWork);
                    SubMonitor exportTestScriptMonitor = subMonitor.split(exportTestScriptWork, 0);
                    exportTestScriptMonitor.beginTask(StringConstants.MSG_EXPORTING_TEST_SCRIPTS, 100);
                    ExportTestArtifactHandler.this.exportTestScripts(testCases, exportTempFolder, exportTestScriptMonitor);
                    exportTestScriptMonitor.done();
                    int exportTestObjectWork = Math.round((float)testObjects.size() * 90.0f / (float)totalWork);
                    SubMonitor exportTestObjectMonitor = subMonitor.split(exportTestObjectWork, 0);
                    exportTestObjectMonitor.beginTask(StringConstants.MSG_EXPORTING_TEST_OBJECTS, 100);
                    ExportTestArtifactHandler.this.exportTestObjects(testObjects, exportTempFolder, exportTestObjectMonitor);
                    exportTestObjectMonitor.done();
                    int exportProfileWork = Math.round((float)profiles.size() * 90.0f / (float)totalWork);
                    SubMonitor exportProfileMonitor = subMonitor.split(exportProfileWork, 0);
                    exportProfileMonitor.beginTask(StringConstants.MSG_EXPORTING_PROFILES, 100);
                    ExportTestArtifactHandler.this.exportProfiles(profiles, exportTempFolder, exportProfileMonitor);
                    exportProfileMonitor.done();
                    int exportKeywordWork = Math.round((float)keywords.size() * 90.0f / (float)totalWork);
                    SubMonitor exportKeywordMonitor = subMonitor.split(exportKeywordWork, 0);
                    exportKeywordMonitor.beginTask(StringConstants.MSG_EXPORTING_KEYWORDS, 100);
                    ExportTestArtifactHandler.this.exportKeywords(keywords, exportTempFolder, exportKeywordMonitor);
                    exportKeywordMonitor.done();
                    SubMonitor zipMonitor = subMonitor.split(10, 0);
                    zipMonitor.beginTask(StringConstants.MSG_COMPRESSING_FILES, 100);
                    String exportedPackageName = MessageFormat.format(StringConstants.IMPORT_EXPORT_EXPORT_FILE_NAME, System.currentTimeMillis());
                    File outputFile = new File(exportFolder, exportedPackageName);
                    ZipUtil.compressFolder(outputFile, exportTempFolder);
                    zipMonitor.done();
                    FileUtils.forceDelete((File)exportTempFolder);
                    subMonitor.done();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e, (String)e.getMessage());
                    return new Status(4, "com.katalon.plugin.katashare", StringConstants.MSG_ERROR_EXPORTING_TEST_ARTIFACTS, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        exportArtifactsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!exportArtifactsJob.getResult().isOK()) {
                    LoggerSingleton.logError((String)"Failed to export test artifacts");
                    MessageDialog.openError((Shell)ExportTestArtifactHandler.this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_FAILED_TO_EXPORT_TEST_ARTIFACTS);
                }
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    PlatformUtil.getUIService(UISynchronizeService.class).syncExec(() -> MessageDialog.openInformation((Shell)ExportTestArtifactHandler.this.activeShell, (String)StringConstants.INFO, (String)StringConstants.MSG_TEST_ARTIFACTS_EXPORTED_SUCCESSFULLY));
                });
            }
        });
        exportArtifactsJob.setUser(true);
        exportArtifactsJob.schedule();
    }

    private void exportTestCases(List<TestCaseEntity> testCases, File exportFolder, SubMonitor monitor) throws IOException {
        ProjectEntity project = PlatformUtil.getCurrentProject();
        File sharedTestCaseFolder = new File(exportFolder, StringConstants.IMPORT_EXPORT_TEST_CASES_FOLDER);
        sharedTestCaseFolder.mkdirs();
        int progress = 0;
        for (TestCaseEntity testCase : testCases) {
            String parentRelativePath = TestCaseUtil.getTestCaseParentRelativePath(project, testCase);
            String copyToFolderLocation = sharedTestCaseFolder.getAbsolutePath() + File.separator + parentRelativePath;
            Files.createDirectories(Paths.get(copyToFolderLocation, new String[0]), new FileAttribute[0]);
            File copyToFolder = new File(copyToFolderLocation);
            File testCaseFile = new File(testCase.getFileLocation());
            if (testCaseFile.exists()) {
                FileUtils.copyFileToDirectory((File)testCaseFile, (File)copyToFolder);
            }
            monitor.worked(Math.round((float)(++progress) * 100.0f / (float)testCases.size()));
        }
    }

    private void exportTestScripts(List<TestCaseEntity> testCases, File exportFolder, SubMonitor monitor) throws IOException {
        ProjectEntity project = PlatformUtil.getCurrentProject();
        File sharedTestScriptFolder = new File(exportFolder, StringConstants.IMPORT_EXPORT_TEST_SCRIPTS_FOLDER);
        sharedTestScriptFolder.mkdirs();
        int progress = 0;
        for (TestCaseEntity testCase : testCases) {
            String testScriptParentRelativePath = TestCaseUtil.getTestScriptParentRelativePath(project, testCase);
            String copyToFolderLocation = sharedTestScriptFolder.getAbsolutePath() + File.separator + testScriptParentRelativePath;
            Files.createDirectories(Paths.get(copyToFolderLocation, new String[0]), new FileAttribute[0]);
            File copyToFolder = new File(copyToFolderLocation);
            File testScriptFile = testCase.getScriptFile();
            if (testScriptFile.exists()) {
                FileUtils.copyFileToDirectory((File)testScriptFile, (File)copyToFolder);
            }
            monitor.worked(Math.round((float)(++progress) * 100.0f / (float)testCases.size()));
        }
    }

    private void exportTestObjects(List<TestObjectEntity> testObjects, File exportFolder, SubMonitor monitor) throws IOException {
        ProjectEntity project = PlatformUtil.getCurrentProject();
        File sharedTestObjectFolder = new File(exportFolder, StringConstants.IMPORT_EXPORT_TEST_OBJECTS_FOLDER);
        sharedTestObjectFolder.mkdirs();
        int progress = 0;
        for (TestObjectEntity testObject : testObjects) {
            String parentRelativePath = TestObjectUtil.getTestObjectParentRelativePath(project, testObject);
            String copyToFolderLocation = sharedTestObjectFolder.getAbsolutePath() + File.separator + parentRelativePath;
            Files.createDirectories(Paths.get(copyToFolderLocation, new String[0]), new FileAttribute[0]);
            File copyToFolder = new File(copyToFolderLocation);
            File testObjectFile = new File(testObject.getFileLocation());
            if (testObjectFile.exists()) {
                FileUtils.copyFileToDirectory((File)testObjectFile, (File)copyToFolder);
            }
            monitor.worked(Math.round((float)(++progress) * 100.0f / (float)testObjects.size()));
        }
    }

    private void exportProfiles(List<ExecutionProfileEntity> profiles, File exportFolder, SubMonitor monitor) throws IOException {
        File sharedProfileFolder = new File(exportFolder, StringConstants.IMPORT_EXPORT_PROFILES_FOLDER);
        sharedProfileFolder.mkdirs();
        int progress = 0;
        for (ExecutionProfileEntity profile : profiles) {
            File profileFile = new File(profile.getFileLocation());
            if (profileFile.exists()) {
                FileUtils.copyFileToDirectory((File)profileFile, (File)sharedProfileFolder);
            }
            monitor.worked(Math.round((float)(++progress) * 100.0f / (float)profiles.size()));
        }
    }

    private void exportKeywords(List<File> keywords, File exportFolder, SubMonitor monitor) throws IOException {
        ProjectEntity project = PlatformUtil.getCurrentProject();
        File sharedKeywordFolder = new File(exportFolder, StringConstants.IMPORT_EXPORT_KEYWORDS_FOLDER);
        sharedKeywordFolder.mkdirs();
        int progress = 0;
        for (File keyword : keywords) {
            String parentRelativePath = KeywordUtil.getKeywordParentRelativePath(project, keyword);
            String copyToFolderLocation = sharedKeywordFolder.getAbsolutePath() + File.separator + parentRelativePath;
            Files.createDirectories(Paths.get(copyToFolderLocation, new String[0]), new FileAttribute[0]);
            File copyToFolder = new File(copyToFolderLocation);
            if (keyword.exists()) {
                FileUtils.copyFileToDirectory((File)keyword, (File)copyToFolder);
            }
            monitor.worked(Math.round((float)(++progress) * 100.0f / (float)keywords.size()));
        }
    }

    static /* synthetic */ Shell access$0(ExportTestArtifactHandler exportTestArtifactHandler) {
        return exportTestArtifactHandler.activeShell;
    }
}

