/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist.proposals;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssistProposal2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class SwapLeftAndRightOperandsProposal
extends GroovyQuickAssistProposal2 {
    @Override
    public String getDisplayString() {
        return "Exchange left and right operands for infix expression";
    }

    @Override
    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }

    @Override
    public int getRelevance() {
        block25: {
            ASTNode coveredNode = this.context.getCoveredNode();
            if (coveredNode instanceof BinaryExpression) {
                switch (((BinaryExpression)coveredNode).getOperation().getType()) {
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 162: 
                    case 164: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 340: 
                    case 341: 
                    case 342: {
                        return 10;
                    }
                }
            }
            if (!(coveredNode instanceof MethodCallExpression) || ((MethodCallExpression)coveredNode).getMethodTarget() == null) break block25;
            switch (((MethodCallExpression)coveredNode).getMethodAsString()) {
                case "compareTo": 
                case "compareNotEqual": 
                case "compareGreaterThanEqual": 
                case "compareGreaterThan": 
                case "compareLessThan": 
                case "compareEqual": 
                case "compare": 
                case "compareLessThanEqual": {
                    return 10;
                }
            }
        }
        return 0;
    }

    @Override
    protected TextChange getTextChange(IProgressMonitor monitor) {
        Expression rhs;
        Expression lhs;
        ASTNode expression = this.context.getCoveredNode();
        if (expression instanceof BinaryExpression) {
            lhs = ((BinaryExpression)expression).getLeftExpression();
            rhs = ((BinaryExpression)expression).getRightExpression();
        } else {
            Expression arguments = ((MethodCallExpression)expression).getArguments();
            lhs = InvocationWriter.makeArgumentList((Expression)arguments).getExpression(0);
            rhs = InvocationWriter.makeArgumentList((Expression)arguments).getExpression(1);
        }
        String lhsText = lhs.getEnd() > 0 ? this.context.getNodeText((ASTNode)lhs).trim() : lhs.getText();
        String rhsText = rhs.getEnd() > 0 ? this.context.getNodeText((ASTNode)rhs).trim() : rhs.getText();
        int lhsOffset = lhs.getEnd() > 0 ? lhs.getStart() : expression.getStart() + this.context.getNodeText(expression).indexOf(lhsText);
        int rhsOffset = rhs.getEnd() > 0 ? rhs.getStart() : expression.getStart() + this.context.getNodeText(expression).lastIndexOf(rhsText);
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild((TextEdit)new ReplaceEdit(lhsOffset, lhsText.length(), rhsText));
        edit.addChild((TextEdit)new ReplaceEdit(rhsOffset, rhsText.length(), lhsText));
        return this.toTextChange((TextEdit)edit);
    }
}

