/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveScreenshotDialog
extends AbstractDialog {
    private Link lnkStatus;
    private Button btnKeepBoth;
    private Button btnReplace;
    private Button btnOk;
    private Button btnStop;
    private Text txtProjectFile;
    private int DEFAULT_BUTTON_WIDTH = SystemUtils.IS_OS_WINDOWS ? 70 : 110;
    private int DEFAULT_DIALOG_WIDTH = SystemUtils.IS_OS_WINDOWS ? 500 : 550;
    private int DEFAULT_TEXT_WIDTH = SystemUtils.IS_OS_WINDOWS ? 400 : 450;
    private String filePath = "";
    private String tempfilePath = "";
    private String lastDirectoryPath = "";
    private static final String[] FILTER_FILE_NAME = new String[]{"Portable Network Graphic file (PNG) (*.PNG)"};
    private static final String[] FILTER_EXTENSION = new String[]{"*.PNG"};

    public SaveScreenshotDialog() {
        this(new Shell());
    }

    public SaveScreenshotDialog(Shell parentShell) {
        super(parentShell, false);
    }

    public String getDialogTitle() {
        return "Information";
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)3).width(this.DEFAULT_DIALOG_WIDTH).margin(5).build();
        this.lnkStatus = (Link)ComponentBuilder.link((Composite)container, (int)64).width(this.DEFAULT_DIALOG_WIDTH).colSpan(3).fillHorizontal().minHeight(100).build();
        ComponentBuilder.label((Composite)container).text("File Path").noFillHorizontal().build();
        this.txtProjectFile = (Text)ComponentBuilder.text((Composite)container, (int)2048).width(this.DEFAULT_TEXT_WIDTH).text(this.filePath).fillHorizontal().onChange(event -> {
            this.filePath = this.txtProjectFile.getText();
            File checkFileExists = new File(this.filePath);
            if (!this.checkFolderPermission(checkFileExists)) {
                this.updateStatusAndButtons(ComposerMobileObjectspyMessageConstants.MSG_TAKE_SCREENSHOT_PERMISSION, true);
            } else if (checkFileExists.isFile() && checkFileExists.exists() && !this.filePath.contains(this.tempfilePath)) {
                String[] file = checkFileExists.getName().split("\\.");
                if (file.length > 1) {
                    this.updateStatusAndButtons(MessageFormat.format(ComposerMobileObjectspyMessageConstants.MSG_TAKE_SCREENSHOT_ERROR, file[0], file[1].trim()), true);
                }
            } else {
                this.updateStatusAndButtons(ComposerMobileObjectspyMessageConstants.MSG_TAKE_SCREENSHOT_SUCCESS, false);
            }
        }).build();
        ComponentBuilder.button((Composite)container).text("Browse...").autoSizeSM(this.DEFAULT_BUTTON_WIDTH).right().noFillHorizontal().onClick(event -> {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
            String fileName = "screenshot.png";
            String path = directoryDialog.open();
            if (!StringUtils.isBlank((CharSequence)path)) {
                File file = new File(path, fileName);
                this.filePath = file.getPath();
                this.lastDirectoryPath = file.getPath();
                this.txtProjectFile.setText(this.filePath);
            }
        }).build();
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)3).marginTop(30).colSpan(3).fillHorizontal().right().gridHorizontalSpacing(0).build();
        this.btnOk = (Button)ComponentBuilder.button((Composite)buttonBar).text(GlobalMessageConstants.OK).autoSizeSM(this.DEFAULT_BUTTON_WIDTH).right().onClick(event -> {
            if (StringUtils.isBlank((CharSequence)this.txtProjectFile.getText())) {
                this.handleKeepBothFile();
            } else {
                this.updateFilePath();
            }
            this.returnCodeAndCloseDialog();
        }).build();
        this.btnKeepBoth = (Button)ComponentBuilder.button((Composite)buttonBar).text(ComposerMobileObjectspyMessageConstants.BTN_KEEP_BOTH).marginRight(5).autoSizeSM(this.DEFAULT_BUTTON_WIDTH).right().onClick(event -> {
            this.handleKeepBothFile();
            this.returnCodeAndCloseDialog();
        }).build();
        this.btnStop = (Button)ComponentBuilder.button((Composite)buttonBar).text("Stop").marginRight(5).autoSizeSM(this.DEFAULT_BUTTON_WIDTH).right().onClick(event -> {
            this.filePath = this.tempfilePath;
            this.setReturnCode(0);
            this.close();
        }).build();
        this.btnReplace = (Button)ComponentBuilder.button((Composite)buttonBar).text(ComposerMobileObjectspyMessageConstants.BTN_REPLACE).autoSizeSM(this.DEFAULT_BUTTON_WIDTH).right().onClick(event -> this.returnCodeAndCloseDialog()).build();
        return container;
    }

    private void returnCodeAndCloseDialog() {
        this.setReturnCode(0);
        this.close();
    }

    private void updateStatusAndButtons(String message, boolean isError) {
        if (isError) {
            if (message.contains("permission")) {
                ComponentUtil.showError((Control)this.lnkStatus, (String)message, (boolean)true);
                ComponentUtil.disableButton((Control)this.btnOk);
            } else {
                ComponentUtil.showError((Control)this.lnkStatus, (String)message, (boolean)true);
                ComponentUtil.show((Control)this.btnKeepBoth);
                ComponentUtil.show((Control)this.btnReplace);
                ComponentUtil.show((Control)this.btnStop);
                ComponentUtil.hide((Control)this.btnOk);
            }
        } else {
            ComponentUtil.showSuccess((Control)this.lnkStatus, (String)message, (boolean)true);
            ComponentUtil.hide((Control)this.btnKeepBoth);
            ComponentUtil.hide((Control)this.btnReplace);
            ComponentUtil.hide((Control)this.btnStop);
            ComponentUtil.show((Control)this.btnOk);
            ComponentUtil.enableButton((Control)this.btnOk);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        this.tempfilePath = filePath;
        this.lastDirectoryPath = filePath;
    }

    protected void setInput() {
        this.updateStatusAndButtons(ComposerMobileObjectspyMessageConstants.MSG_TAKE_SCREENSHOT_SUCCESS, false);
        this.getShell().pack();
    }

    protected void registerControlModifyListeners() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public void handleKeepBothFile() {
        if (StringUtils.isBlank((CharSequence)this.filePath)) {
            this.filePath = this.lastDirectoryPath;
        }
        if (this.filePath.equals(this.tempfilePath)) {
            return;
        }
        if (new File(this.filePath).exists()) {
            this.filePath = this.filePath.replace(".png", " copy.png");
        }
        if (new File(this.filePath).exists()) {
            File checkFileExists;
            this.filePath = this.filePath.replace(".png", "(2).png");
            int n = 2;
            while ((checkFileExists = new File(this.filePath)).exists()) {
                this.filePath = this.filePath.replace("(" + n + ")", "(" + (n + 1) + ")");
                ++n;
            }
        }
    }

    public boolean checkFolderPermission(File file) {
        Path path;
        return !file.isAbsolute() || Files.isWritable(path = !file.isDirectory() ? Paths.get(file.getParentFile().getPath(), new String[0]) : Paths.get(file.getPath(), new String[0]));
    }

    public void updateFilePath() {
        this.filePath = this.txtProjectFile.getText();
        File file = new File(this.filePath);
        String[] fileName = file.getName().split("\\.");
        if (fileName.length < 2) {
            this.filePath = String.valueOf(this.filePath) + ".png";
        }
    }
}

