/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element.tree;

import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleTreeCellLabelProvider;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ImageConstants;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class MobileElementLabelProvider
extends TypeCheckedStyleTreeCellLabelProvider<TreeMobileElement> {
    public MobileElementLabelProvider() {
        super(0);
    }

    protected Class<TreeMobileElement> getElementType() {
        return TreeMobileElement.class;
    }

    protected Image getImage(TreeMobileElement element) {
        return ImageConstants.IMG_16_TEST_OBJECT;
    }

    protected String getElementToolTipText(TreeMobileElement element) {
        return this.getText(element);
    }

    protected String getText(TreeMobileElement element) {
        return element.getName();
    }

    protected StyleRange[] getStyleRanges(ViewerCell cell, TreeMobileElement element) {
        CapturedMobileElement capturedElement = element.getCapturedElement();
        if (capturedElement == null) {
            return super.getStyleRanges(cell, (Object)element);
        }
        String aliasName = capturedElement.getName();
        StyledString styledString = new StyledString().append(aliasName, (StyledString.Styler)new BoldStyler(cell.getFont()));
        if (!aliasName.equals(element.getName())) {
            styledString.append(" " + element.getName() + " ", StyledString.DECORATIONS_STYLER);
        }
        cell.setText(styledString.getString());
        return styledString.getStyleRanges();
    }

    private class BoldStyler
    extends StyledString.Styler {
        private Font currentFont;

        private BoldStyler(Font font) {
            this.currentFont = font;
        }

        public void applyStyles(TextStyle textStyle) {
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((FontData)this.currentFont.getFontData()[0]).setStyle(1);
            Font boldFont = boldDescriptor.createFont((Device)Display.getCurrent());
            textStyle.foreground = ColorUtil.getTextSuccessfulColor();
            textStyle.font = boldFont;
        }
    }
}

