/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.launching;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.eclipse.editor.console.CucumberConsole;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.launching.ILauncher;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.launching.CucumberFeatureLaunchUtils;
import io.cucumber.eclipse.java.plugins.CucumberEclipsePlugin;
import io.cucumber.eclipse.java.runtime.CucumberRuntime;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepStarted;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.plugin.Plugin;
import io.cucumber.tagexpressions.Expression;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.osgi.service.component.annotations.Component;

@Component(service={ILauncher.class})
public class CucumberRuntimeLauncher
implements ILauncher {
    public void launch(Map<GherkinEditorDocument, IStructuredSelection> launchMap, Mode mode, boolean temporary, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = lm.getLaunchConfigurationType("cucumber.eclipse.java.launching.localCucumberFeature");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(launchMap.size() * 100));
        for (Map.Entry<GherkinEditorDocument, IStructuredSelection> entry : launchMap.entrySet()) {
            GherkinEditorDocument document = entry.getKey();
            IResource resource = document.getResource();
            IJavaProject javaProject = JDTUtil.getJavaProject(resource);
            if (javaProject == null) continue;
            ILaunchConfiguration lc = this.getLaunchConfiguration(javaProject, resource, type);
            String identifier = mode.getLaunchMode().getIdentifier();
            if (temporary) {
                ILaunchConfigurationWorkingCopy copy = lc.getWorkingCopy();
                ArrayList<FeatureWithLines> featuresWithLines = new ArrayList<FeatureWithLines>();
                ArrayList<Expression> filters = new ArrayList<Expression>();
                IStructuredSelection selection = entry.getValue();
                for (Object object : selection) {
                    if (object instanceof Scenario) {
                        Scenario scenario = (Scenario)object;
                        URI locationURI = resource.getLocationURI();
                        featuresWithLines.add(FeatureWithLines.create((URI)locationURI, Collections.singleton(scenario.getLocation().getLine().intValue())));
                        continue;
                    }
                    if (!(object instanceof Expression)) continue;
                    filters.add((Expression)object);
                }
                copy.setAttribute("cucumber feature_with_line", featuresWithLines.stream().map(FeatureWithLines::toString).collect(Collectors.joining(" ")));
                copy.setAttribute("cucumber tags", filters.stream().map(Object::toString).collect(Collectors.joining(" and ")));
                copy.launch(identifier, subMonitor.slice(100));
                continue;
            }
            lc.launch(identifier, subMonitor.slice(100));
        }
    }

    private ILaunchConfiguration getLaunchConfiguration(IJavaProject javaProject, IResource resource, ILaunchConfigurationType type) throws CoreException {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        String featurePath = resource.getProjectRelativePath().toPortableString();
        ILaunchConfiguration[] iLaunchConfigurationArray = lm.getLaunchConfigurations(type);
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            if (projectName.equals(javaProject.getElementName()) && featurePath.equals(configuration.getAttribute("cucumber feature", ""))) {
                return configuration;
            }
            ++n2;
        }
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, lm.generateLaunchConfigurationName(resource.getName()));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
        wc.setAttribute("cucumber feature", featurePath);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Dcucumber.publish.quiet=true");
        TEST_RESULT_LISTENER_CONFIGURER.apply(wc);
        return wc.doSave();
    }

    public boolean supports(IResource resource) {
        return JDTUtil.isJavaProject(resource.getProject());
    }

    public boolean supports(Mode mode) {
        return mode == Mode.DEBUG || mode == Mode.RUN || mode == Mode.PROFILE;
    }

    /*
     * WARNING - void declaration
     */
    public static void runFeaturesEmbedded(IJavaProject javaProject, List<Feature> features, Collection<FeatureWithLines> featureFilter, Mode mode, CucumberConsole console, IProgressMonitor monitor, Collection<Expression> tagFilters) throws CoreException {
        Throwable throwable = null;
        Object var8_9 = null;
        try (CucumberRuntime cucumberRuntime = CucumberRuntime.create(javaProject);){
            CucumberEclipsePlugin plugin = new CucumberEclipsePlugin((Consumer)new Consumer<Envelope>(){
                private Map<String, TestStepPerfInfo> map = new HashMap<String, TestStepPerfInfo>();
                private GherkinDocument gherkinDocument;

                @Override
                public void accept(Envelope envelope) {
                    if (envelope.getTestCaseStarted().isPresent()) {
                        TestCaseStarted testCaseStarted = (TestCaseStarted)envelope.getTestCaseStarted().get();
                        String string = testCaseStarted.getTestCaseId();
                    }
                    if (envelope.getTestStepFinished().isPresent()) {
                        TestStepFinished stepFinished = (TestStepFinished)envelope.getTestStepFinished().get();
                        this.map.get((Object)stepFinished.getTestStepId()).end = stepFinished.getTimestamp();
                    } else if (envelope.getTestStepStarted().isPresent()) {
                        TestStepStarted stepStarted = (TestStepStarted)envelope.getTestStepStarted().get();
                        this.map.put(stepStarted.getTestStepId(), new TestStepPerfInfo(stepStarted.getTimestamp()));
                    } else if (envelope.getGherkinDocument().isPresent()) {
                        this.gherkinDocument = (GherkinDocument)envelope.getGherkinDocument().get();
                    } else {
                        envelope.getTestRunFinished().isPresent();
                    }
                }
            });
            for (Feature feature : features) {
                cucumberRuntime.addFeature(feature);
            }
            RuntimeOptionsBuilder options = cucumberRuntime.getRuntimeOptions();
            for (FeatureWithLines featureWithLines : featureFilter) {
                options.addFeature(featureWithLines);
            }
            for (Expression expression : tagFilters) {
                options.addTagFilter(expression);
            }
            options.setPublishQuiet(true);
            options.addDefaultSummaryPrinterIfNotDisabled();
            options.setThreads(Runtime.getRuntime().availableProcessors());
            options.setMonochrome(!CucumberFeatureLaunchUtils.isAnsiConsoleEnabled());
            cucumberRuntime.addPlugin((Plugin)plugin);
            try {
                Throwable throwable2 = null;
                Iterator<FeatureWithLines> iterator = null;
                try (IOConsoleOutputStream stream = console.newOutputStream();){
                    cucumberRuntime.run(monitor, new PrintStream((OutputStream)stream));
                }
                catch (Throwable throwable3) {
                    void var12_21;
                    if (throwable2 == null) {
                        Throwable throwable4 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw var12_21;
                }
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, CucumberRuntimeLauncher.class, "launch failed", (Throwable)iOException));
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static final class TestStepPerfInfo {
        private Timestamp start;
        protected Timestamp end;

        public TestStepPerfInfo(Timestamp timestamp) {
            this.start = timestamp;
        }
    }
}

