/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.handlers;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.handlers.DeleteCheckpointHandler;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.folder.handlers.deletion.IDeleteFolderHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteCheckpointFolderHandler
extends DeleteCheckpointHandler
implements IDeleteFolderHandler {
    public FolderEntity.FolderType getFolderType() {
        return FolderEntity.FolderType.CHECKPOINT;
    }

    public boolean execute(FolderTreeEntity folderTreeEntity, IProgressMonitor monitor) {
        try {
            FolderEntity folder = folderTreeEntity.getObject();
            if (folder == null) {
                return false;
            }
            List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folder);
            monitor.beginTask(MessageFormat.format(StringConstants.HAND_MSG_DELETING_X_Y, StringConstants.FOLDER, folder.getName()), descendantEntities.size() + 1);
            List affectedTestCaseScripts = TestArtifactScriptRefactor.createForFolderEntity((FolderEntity)folder).findReferrersInTestCaseScripts(folder.getProject());
            ArrayList<CheckpointEntity> undeletedCheckpoints = new ArrayList<CheckpointEntity>();
            for (Object entity : descendantEntities) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (entity instanceof CheckpointEntity && !this.deleteCheckpoint((CheckpointEntity)entity, monitor, affectedTestCaseScripts)) {
                    undeletedCheckpoints.add((CheckpointEntity)entity);
                    continue;
                }
                if (!(entity instanceof FolderEntity)) continue;
                this.deleteFolder((FolderEntity)entity, undeletedCheckpoints, monitor);
            }
            this.deleteFolder(folder, undeletedCheckpoints, monitor);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity.getParent());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private boolean deleteCheckpoint(CheckpointEntity checkpoint, IProgressMonitor monitor, List<IFile> affectedTestCaseScripts) {
        try {
            String checkpointId = checkpoint.getIdForDisplay();
            monitor.subTask(MessageFormat.format(StringConstants.HAND_MSG_DELETING_X_Y, StringConstants.CHECKPOINT, checkpointId));
            boolean bl = this.deleteCheckpoint(checkpoint, TestArtifactScriptRefactor.createForCheckpointEntity((String)checkpointId).findReferrers(affectedTestCaseScripts));
            return bl;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.worked(1);
        }
    }
}

