/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.parts.supports;

import com.kms.katalon.composer.checkpoint.parts.CheckpointAbstractPart;
import com.kms.katalon.entity.checkpoint.CheckpointCell;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;

public class CheckpointCellEditingSupport
extends EditingSupport {
    private int columnIndex;
    private CheckpointAbstractPart parentPart;
    @Inject
    protected IEventBroker eventBroker;

    public CheckpointCellEditingSupport(ColumnViewer viewer, int columnIndex, CheckpointAbstractPart parentPart) {
        super(viewer);
        this.columnIndex = columnIndex;
        this.parentPart = parentPart;
    }

    protected CellEditor getCellEditor(Object element) {
        return new CheckboxCellEditor();
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        CheckpointCell checkpointCell = this.getCellData(element);
        if (checkpointCell == null) {
            return false;
        }
        return checkpointCell.isChecked();
    }

    protected void setValue(Object element, Object value) {
        this.parentPart.executeOperation((IUndoableOperation)new EditCheckpointCellOperation(element, (Boolean)value));
    }

    private CheckpointCell getCellData(Object element) {
        if (!(element instanceof List) || !(((List)element).get(this.columnIndex) instanceof CheckpointCell)) {
            return null;
        }
        return (CheckpointCell)((List)element).get(this.columnIndex);
    }

    private class EditCheckpointCellOperation
    extends AbstractOperation {
        private boolean isChecked;
        private CheckpointCell checkpointCell;
        private Object element;
        private ColumnViewer viewer;

        public EditCheckpointCellOperation(Object element, boolean isChecked) {
            super(EditCheckpointCellOperation.class.getName());
            this.element = element;
            this.isChecked = isChecked;
            this.viewer = CheckpointCellEditingSupport.this.getViewer();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.checkpointCell = CheckpointCellEditingSupport.this.getCellData(this.element);
            if (this.checkpointCell == null) {
                return Status.CANCEL_STATUS;
            }
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doCheck(this.isChecked);
            return Status.OK_STATUS;
        }

        protected void doCheck(boolean isChecked) {
            this.checkpointCell.setChecked(isChecked);
            this.viewer.refresh(this.element);
            CheckpointCellEditingSupport.this.parentPart.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doCheck(!this.isChecked);
            return Status.OK_STATUS;
        }
    }
}

