package com.kms.katalon.core.reporting.newreport.extractor;

import java.util.List;
import java.util.Optional;

import org.apache.commons.lang3.StringUtils;

public class FailureReasonExtractors {
    private static final List<IFailureReasonExtractor> DEFAULT_EXTRACTORS = List.of(new CausedByExtractor(),
            new ReasonSectionExtractor(), new FullMessageExtractor());

    private final List<IFailureReasonExtractor> extractors;

    public FailureReasonExtractors(List<IFailureReasonExtractor> extractors) {
        this.extractors = List.copyOf(extractors);
    }

    public static FailureReasonExtractors getDefault() {
        return new FailureReasonExtractors(DEFAULT_EXTRACTORS);
    }

    public Optional<String> extract(String message) {
        if (StringUtils.isBlank(message)) {
            return Optional.empty();
        }

        return extractors.stream()
                .map(extractor -> extractor.extract(message))
                .filter(Optional::isPresent)
                .map(Optional::get)
                .findFirst();
    }
}
