package com.kms.katalon.core.mobile.keyword.builtin

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.remote.SupportsContextSwitching

@Action(value = "getContexts")
public class GetContextsKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        return getContexts(flowControl)
    }

    @CompileStatic
    public List<String> getContexts(FailureHandling flowControl) throws StepFailedException {
        return (java.util.List<java.lang.String>) MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            Set<String> contexts = ((SupportsContextSwitching) driver).getContextHandles()
            return new ArrayList(contexts)
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), StringConstants.KW_MSG_UNABLE_GET_CONTEXT_LIST)
    }
}
