package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.android.AndroidDriver
import io.appium.java_client.android.nativekey.AndroidKey
import io.appium.java_client.android.nativekey.KeyEvent

@Action(value = "pressKeyCode")
public class PressKeyCodeKeyword extends MobileAbstractKeyword {
    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        String keyCode = (String) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        pressKeyCode(keyCode, flowControl)
    }

    @CompileStatic
    public void pressKeyCode(String keyCode, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver();
            if (!(driver instanceof AndroidDriver)) {
                throw new UnsupportedOperationException();
            }

            try {
                AndroidKey key = AndroidKey.valueOf(keyCode)
                ((AndroidDriver) driver).pressKey(new KeyEvent(key));
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }

            logger.logPassed(MessageFormat.format(CoreMobileMessageConstants.KW_LOG_PRESS_KEY_CODE_SUCCESSFULLY, keyCode))
        }, flowControl, RunConfiguration.getTakeScreenshotOption(),
        MessageFormat.format(CoreMobileMessageConstants.KW_MSG_CANNOT_PRESS_KEY_CODE, keyCode))
    }
}
