/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.kms.katalon.session.constants.FeatureConstants;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureService;
import com.kms.katalon.util.E4InjectionUtils;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class FeatureService
implements IFeatureService {
    private static final Logger logger = LoggerFactory.getLogger(FeatureService.class);
    private static volatile IFeatureService instance;
    private Map<ProductFeature, Object> features;

    public static IFeatureService getInstance() {
        return (IFeatureService)E4InjectionUtils.getOrCreate(() -> instance, val -> {
            IFeatureService iFeatureService = instance = val;
        }, FeatureService.class, FeatureService.class);
    }

    public void setFeatures(Map<ProductFeature, Object> features) {
        if (this.features == null) {
            this.features = features;
            if (features == null) {
                logger.warn("Features is set to null");
            }
            return;
        }
        this.features.putAll(features);
    }

    public void enable(ProductFeature feature, Object value) {
        if (this.features == null) {
            this.features = new HashMap<ProductFeature, Object>();
        }
        this.features.put(feature, value);
    }

    public void clear() {
        if (this.features != null) {
            this.features.clear();
        }
    }

    public boolean getBoolean(ProductFeature feature) {
        if (this.features == null) {
            return false;
        }
        if (!this.features.containsKey(feature)) {
            return false;
        }
        Object value = this.features.get(feature);
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.intValue() == FeatureConstants.UNLIMITED_QUOTA || numberValue.intValue() > 0;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                int intValue = Integer.parseInt(stringValue);
                return intValue == FeatureConstants.UNLIMITED_QUOTA || intValue > 0;
            }
            catch (NumberFormatException numberFormatException) {
                return StringUtils.isNotEmpty((CharSequence)stringValue);
            }
        }
        return false;
    }

    public String getString(ProductFeature feature) {
        if (this.features == null || !this.features.containsKey(feature)) {
            return null;
        }
        Object value = this.features.get(feature);
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue;
        }
        return value != null ? value.toString() : null;
    }

    public int getInt(ProductFeature feature) {
        Boolean booleanValue;
        if (this.features == null || !this.features.containsKey(feature)) {
            return 0;
        }
        Object value = this.features.get(feature);
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.intValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (value instanceof Boolean && (booleanValue = (Boolean)value).booleanValue()) {
            return FeatureConstants.UNLIMITED_QUOTA;
        }
        return 0;
    }

    public <T> T getValue(ProductFeature feature, Class<T> clazz) {
        if (this.features == null || !this.features.containsKey(feature)) {
            return null;
        }
        Object value = this.features.get(feature);
        if (value != null && clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }
}

