/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.kms.katalon.admin.dto.AdministrationManagedAiConfigResponseDto;
import com.kms.katalon.admin.dto.AdministrationManagedAiProviderConfigDto;
import com.kms.katalon.admin.dto.AdministrationManagedAiProviderDto;
import com.kms.katalon.admin.dto.AdministrationManagedAppSettingResponseDto;
import com.kms.katalon.admin.dto.AdministrationManagedAzureOpenAiConfigResponseDto;
import com.kms.katalon.admin.dto.AdministrationManagedGeminiConfigResponseDto;
import com.kms.katalon.admin.dto.AdministrationManagedOpenAiCompatibleConfigResponseDto;
import com.kms.katalon.admin.dto.AdministrationManagedOpenAiConfigResponseDto;
import com.kms.katalon.admin.mapper.AdministrationManagedKsSettingMapper;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.AdministrationManagedKsSetting;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.RememberMeOption;
import com.kms.katalon.session.core.model.RememberedApiKey;
import com.kms.katalon.session.core.model.RememberedCredential;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.services.ISessionService;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class SessionService
implements ISessionService {
    public final String USER_HOME_DIR = System.getProperty("user.home");
    public final String KATALON_HOME_ENV_NAME = "KATALON_HOME";
    public final String KATALON_HOME_DIR = System.getenv("KATALON_HOME") != null ? System.getenv("KATALON_HOME") : this.USER_HOME_DIR;
    public final String KATALON_USER_DIR_LOCATION = this.KATALON_HOME_DIR + File.separator + ".katalon";
    public final String KATALON_SESSION_INFO_FILE_LOCATION = this.KATALON_USER_DIR_LOCATION + File.separator + "session.properties";
    private static final String X_ACCOUNT_ID = "X-Account-Id";
    private static final String X_LICENSE_KEY = "x-license-key";
    private static final String KS_VERSION = "X-KS-Version";
    private final Logger logger = LoggerFactory.getLogger(SessionService.class);
    private ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private Properties sessionProperties;
    @Inject
    private IDiscoveryService discoveryService;
    @Inject
    private IHttpClient httpClient;
    @Inject
    private INetworkPreferences networkPreferences;

    public void reset() {
        this.sessionProperties = this.getSessionProperties();
        if (Objects.nonNull(this.sessionProperties)) {
            this.sessionProperties.clear();
        }
        this.saveSessionProperties();
    }

    public Account getAccount() throws JsonMappingException, JsonProcessingException {
        String json = this.getSessionProperty("account");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return (Account)this.objectMapper.readValue(json, Account.class);
        }
        return null;
    }

    public AuthenticationToken getAdminToken() {
        String json = this.getSessionProperty("adminToken");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (AuthenticationToken)this.objectMapper.readValue(json, AuthenticationToken.class);
            }
            catch (JsonProcessingException e) {
                this.logger.error("Failed to get admin token from session properties!", (Throwable)e);
            }
        }
        return null;
    }

    public String getIdpType() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.getSessionProperty("idpType"), "basic"});
    }

    public AuthenticationToken getKatOneToken() throws JsonMappingException, JsonProcessingException {
        String json = this.getSessionProperty("katOneToken");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return (AuthenticationToken)this.objectMapper.readValue(json, AuthenticationToken.class);
        }
        return null;
    }

    public String getLicense() {
        return this.getSessionProperty("license");
    }

    public Organization getOrganization() {
        String json = this.getSessionProperty("organization");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (Organization)this.objectMapper.readValue(json, Organization.class);
            }
            catch (JsonProcessingException jsonProcessingException) {}
        }
        return null;
    }

    private Properties getSessionProperties() {
        if (this.sessionProperties != null) {
            return this.sessionProperties;
        }
        File sessionPropFile = new File(this.KATALON_SESSION_INFO_FILE_LOCATION);
        File katalonDir = new File(this.KATALON_USER_DIR_LOCATION);
        if (!sessionPropFile.exists()) {
            if (!katalonDir.exists()) {
                katalonDir.mkdir();
            }
            try {
                sessionPropFile.createNewFile();
            }
            catch (Exception exception) {
                this.logger.info("Failed to create session properties file!");
            }
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream in = new FileInputStream(sessionPropFile);){
                this.sessionProperties = new Properties();
                this.sessionProperties.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.logger.info("Failed to load session properties!");
            this.sessionProperties = null;
        }
        return this.sessionProperties;
    }

    private String getSessionProperty(String key) {
        Properties sessionProps = this.getSessionProperties();
        if (sessionProps != null && sessionProps.containsKey(key)) {
            return sessionProps.getProperty(key);
        }
        return null;
    }

    public String getSubDomain() {
        return this.getSessionProperty("subDomain");
    }

    public User getUser() throws JsonMappingException, JsonProcessingException {
        String json = this.getSessionProperty("user");
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (User)this.objectMapper.readValue(json, User.class);
    }

    public void saveAccount(Account account) throws JsonProcessingException {
        if (Objects.nonNull(account)) {
            String json = this.objectMapper.writeValueAsString((Object)account);
            this.setSessionProperty("account", json, true);
        } else {
            this.setSessionProperty("account", null, true);
        }
    }

    public void saveAdminToken(AuthenticationToken adminToken) throws JsonProcessingException {
        if (Objects.nonNull(adminToken)) {
            String json = this.objectMapper.writeValueAsString((Object)adminToken);
            this.setSessionProperty("adminToken", json, true);
        } else {
            this.setSessionProperty("adminToken", null, true);
        }
    }

    public void saveIdpType(String idpType) {
        this.setSessionProperty("idpType", idpType != null ? idpType.toString() : null, true);
    }

    public void saveKatOneToken(AuthenticationToken katOneToken) throws JsonProcessingException {
        if (Objects.nonNull(katOneToken)) {
            String json = this.objectMapper.writeValueAsString((Object)katOneToken);
            this.setSessionProperty("katOneToken", json, true);
        } else {
            this.setSessionProperty("katOneToken", null, true);
        }
    }

    public void saveLicense(String license) {
        this.setSessionProperty("license", license, true);
    }

    public void saveOrganization(Organization organization) throws JsonProcessingException {
        if (Objects.nonNull(organization)) {
            String json = this.objectMapper.writeValueAsString((Object)organization);
            this.setSessionProperty("organization", json, true);
        } else {
            this.setSessionProperty("organization", null, true);
        }
    }

    private void saveSessionProperties() {
        if (this.sessionProperties == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileOutputStream out = new FileOutputStream(this.KATALON_SESSION_INFO_FILE_LOCATION);){
                this.sessionProperties.store(out, this.KATALON_USER_DIR_LOCATION);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.logger.info("Failed to save session properties!");
        }
    }

    public void saveSubDomain(String subDomain) {
        this.setSessionProperty("subDomain", subDomain, true);
    }

    public void saveUser(User user) throws JsonProcessingException {
        if (Objects.nonNull(user)) {
            String json = this.objectMapper.writeValueAsString((Object)user);
            this.setSessionProperty("user", json, true);
        } else {
            this.setSessionProperty("user", null, true);
        }
    }

    private void setSessionProperty(String key, String value, boolean autoSave) {
        Properties sessionProps = this.getSessionProperties();
        if (Objects.nonNull(value)) {
            sessionProps.setProperty(key, value);
        } else {
            sessionProps.remove(key);
        }
        if (autoSave) {
            this.saveSessionProperties();
        }
    }

    public boolean shouldShowBrowserLoginAvailableDialog() {
        String rawValue = this.getSessionProperty("shouldShowBrowserLoginAvailableDialog");
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return true;
        }
        return Boolean.valueOf(rawValue);
    }

    public void setShouldShowBrowserLoginAvailableDialog(boolean shouldDisplay) {
        this.setSessionProperty("shouldShowBrowserLoginAvailableDialog", !shouldDisplay ? "false" : "true", true);
    }

    public RememberMeOption getRememberMeOption() {
        String optionValue = (String)StringUtils.defaultIfEmpty((CharSequence)ApplicationInfo.getAppProperty((String)"session.rememberMeOption"), (CharSequence)RememberMeOption.UNSET.name());
        try {
            return RememberMeOption.valueOf((String)optionValue);
        }
        catch (Exception exception) {
            return RememberMeOption.UNSET;
        }
    }

    public void setRememberMeOption(RememberMeOption option) {
        ApplicationInfo.setAppProperty((String)"session.rememberMeOption", (String)option.name(), (boolean)true);
    }

    public void saveRememberedCredential(RememberedCredential credential) throws StorageException, IOException {
        if (credential == null) {
            return;
        }
        ISecurePreferences securePreferences = this.loadSecurePreferences();
        if (credential instanceof RememberedApiKey) {
            RememberedApiKey rememberedApiKey = (RememberedApiKey)credential;
            try {
                securePreferences.put("session.rememberMeCredential.type", RememberedCredential.CredentialType.API_KEY.name(), true);
                securePreferences.put("session.rememberMeCredential.value", rememberedApiKey.getValue(), true);
                securePreferences.flush();
                return;
            }
            catch (StorageException e) {
                this.logger.warn("Secure storage password issue detected: {}. Deleting secure storage file and retrying...", (Object)e.getMessage());
                this.deleteSecureStorageFile();
                securePreferences.put("session.rememberMeCredential.type", RememberedCredential.CredentialType.API_KEY.name(), true);
                securePreferences.put("session.rememberMeCredential.value", rememberedApiKey.getValue(), true);
                securePreferences.flush();
                return;
            }
        }
        this.logger.warn("Unsupported remembered credential type: " + credential.getClass().getName());
    }

    public RememberedCredential getRememberedCredential() throws StorageException, JsonMappingException, JsonProcessingException {
        ISecurePreferences securePreferences = this.loadSecurePreferences();
        RememberedCredential.CredentialType credentialType = RememberedCredential.CredentialType.valueOf((String)securePreferences.get("session.rememberMeCredential.type", null));
        if (credentialType == RememberedCredential.CredentialType.API_KEY) {
            String value = securePreferences.get("session.rememberMeCredential.value", null);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return new RememberedApiKey(value);
            }
            return null;
        }
        this.logger.warn("Unsupported remembered credential type: " + String.valueOf(credentialType));
        return null;
    }

    public void clearRememberedCredential() throws IOException {
        ISecurePreferences securePreferences = this.loadSecurePreferences();
        securePreferences.remove("session.rememberMeCredential.type");
        securePreferences.remove("session.rememberMeCredential.value");
        securePreferences.flush();
        this.logger.info("Remembered credential cleared successfully.");
    }

    private ISecurePreferences loadSecurePreferences() {
        ISecurePreferences securePreferences = null;
        try {
            File secureStorageFolder = Paths.get(SystemUtils.getUserHome().toString(), ".katalon", "session").toFile();
            File secureStorageFile = new File(secureStorageFolder, "secure");
            securePreferences = SecurePreferencesFactory.open((URL)secureStorageFile.toURI().toURL(), null);
            if (securePreferences != null) {
                securePreferences.flush();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load secure preferences", (Object)e.getMessage());
        }
        return securePreferences;
    }

    private void deleteSecureStorageFile() {
        try {
            File secureStorageFolder = Paths.get(SystemUtils.getUserHome().toString(), ".katalon", "session").toFile();
            File secureStorageFile = new File(secureStorageFolder, "secure");
            if (secureStorageFile.exists()) {
                boolean deleted = secureStorageFile.delete();
                if (deleted) {
                    this.logger.info("Secure storage file deleted successfully");
                } else {
                    this.logger.warn("Failed to delete secure storage file");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to delete secure storage file", (Throwable)e);
        }
    }

    public AdministrationManagedKsSetting getKsAppSetting(Session session) throws URISyntaxException, NetworkErrorException, JsonMappingException, JsonProcessingException, MalformedContentException {
        try {
            HttpOptions httpOptions = this.buildHttpOptions(false, session);
            URI uri = this.buildUri("/v2/admin/ks/settings");
            HttpResponse response = this.executeGetRequest(uri, httpOptions);
            return this.fromAdminSetting(response);
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve KS Setting", (Throwable)e);
            return AdministrationManagedKsSetting.defaultSettings().build();
        }
    }

    private AdministrationManagedKsSetting fromAdminSetting(HttpResponse response) {
        try {
            AdministrationManagedAppSettingResponseDto settingDto = (AdministrationManagedAppSettingResponseDto)response.json(AdministrationManagedAppSettingResponseDto.class);
            AdministrationManagedKsSetting setting = Optional.ofNullable(settingDto).map(AdministrationManagedKsSettingMapper::fromAppSettingsDto).orElseGet(() -> AdministrationManagedKsSetting.defaultSettings().build());
            return setting;
        }
        catch (Exception e) {
            this.logger.error("Failed to parse KS Setting response, falling back to default settings", (Throwable)e);
            return AdministrationManagedKsSetting.defaultSettings().build();
        }
    }

    public AiConfigPolicy getAiAppConfig(AdministrationManagedKsSetting setting, Session session) throws JsonMappingException, JsonProcessingException, URISyntaxException, NetworkErrorException, MalformedContentException {
        AiConfigPolicy DEFAULT_POLICY = new AiConfigPolicy(AiConfigPolicyType.AI_DISABLED);
        try {
            boolean aiEnabled = Optional.ofNullable(setting.isEnableAi()).orElse(false);
            boolean directUsageAllowed = Optional.ofNullable(setting.isAllowDirectUsage()).orElse(false);
            if (!aiEnabled && !directUsageAllowed) {
                return DEFAULT_POLICY;
            }
            if (aiEnabled && !directUsageAllowed) {
                return new AiConfigPolicy(AiConfigPolicyType.USER_MANAGED_SETTINGS);
            }
            return this.fetchAiConfig(session);
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve AI Config, error: ", (Throwable)e);
            this.logger.error("Fallback to AI DISABLED");
            return DEFAULT_POLICY;
        }
    }

    private URI buildUri(String path) throws URISyntaxException {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(path);
        return uriBuilder.build();
    }

    private HttpOptions buildHttpOptions(boolean useLicenceKey, Session session) throws JsonMappingException, JsonProcessingException {
        Long accountId = Optional.ofNullable(session.getAccount()).map(Account::getId).orElse(null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(X_ACCOUNT_ID, accountId.toString());
        headers.put(KS_VERSION, VersionUtil.getCurrentVersion().getVersion());
        if (useLicenceKey) {
            headers.put(X_LICENSE_KEY, Optional.ofNullable(session.getLicense()).map(License::getJwt).orElse(null));
        }
        AuthenticationToken katOneToken = session.getKatOneToken();
        BearerAuthentication authenticate = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        return new HttpOptions.Builder().headers(headers).authentication((Authentication)authenticate).proxy(proxyConfig).build();
    }

    private AiConfigPolicy fetchAiConfig(Session session) throws URISyntaxException, NetworkErrorException, MalformedContentException, JsonMappingException, JsonProcessingException {
        HttpOptions httpOptions = this.buildHttpOptions(true, session);
        URI uri = this.buildUri("/v2/admin/ks/ai-configs");
        HttpResponse response = null;
        try {
            response = this.executeGetRequest(uri, httpOptions);
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve AI Config, error: " + e.getMessage(), (Throwable)e);
            this.logger.error("Fallback to USER SETTINGS");
            return new AiConfigPolicy(AiConfigPolicyType.USER_MANAGED_SETTINGS);
        }
        return this.fromAdminConfig(response);
    }

    private HttpResponse executeGetRequest(URI uri, HttpOptions httpOptions) throws NetworkErrorException {
        try {
            HttpResponse response = this.httpClient.get(uri, httpOptions);
            this.handleResponseErrors(response);
            return response;
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
    }

    private void handleResponseErrors(HttpResponse response) throws NetworkErrorException {
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
    }

    private AiConfigPolicy fromAdminConfig(HttpResponse response) throws MalformedContentException, JsonMappingException, JsonProcessingException {
        AiConfigPolicy DEFAULT_POLICY = new AiConfigPolicy(AiConfigPolicyType.USER_MANAGED_SETTINGS);
        try {
            List aiConfigDto = response.jsonArray(AdministrationManagedAiConfigResponseDto.class);
            if (aiConfigDto.isEmpty()) {
                return DEFAULT_POLICY;
            }
            AdministrationManagedAiProviderConfigDto config = ((AdministrationManagedAiConfigResponseDto)aiConfigDto.get(0)).getConfig();
            AdministrationManagedAiProviderDto provider = ((AdministrationManagedAiConfigResponseDto)aiConfigDto.get(0)).getProvider();
            AiConfigPolicy aiConfigPolicy = null;
            switch (provider) {
                case OPENAI: {
                    AdministrationManagedOpenAiConfigResponseDto openAiDto = (AdministrationManagedOpenAiConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_OPENAI);
                    aiConfigPolicy.setManagedOpenAi(openAiDto.getApiKey(), openAiDto.getOrganization());
                    break;
                }
                case AZURE: {
                    AdministrationManagedAzureOpenAiConfigResponseDto azureOpenAiDto = (AdministrationManagedAzureOpenAiConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_AZURE_OPENAI);
                    aiConfigPolicy.setManagedAzureOpenAi(azureOpenAiDto.getApiKey(), azureOpenAiDto.getApiBase(), azureOpenAiDto.getDeploymentName(), azureOpenAiDto.getApiVersion());
                    break;
                }
                case GEMINI: {
                    AdministrationManagedGeminiConfigResponseDto geminiDto = (AdministrationManagedGeminiConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_GEMINI);
                    aiConfigPolicy.setManagedGeminiAiConfig(geminiDto.getBaseUrl(), geminiDto.getApiKey());
                    break;
                }
                case OPENAI_COMPATIBLE: {
                    AdministrationManagedOpenAiCompatibleConfigResponseDto openAiCompatibleConfigResponseDto = (AdministrationManagedOpenAiCompatibleConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE);
                    aiConfigPolicy.setManagedOpenAiCompatibleConfig(openAiCompatibleConfigResponseDto.getBaseUrl(), openAiCompatibleConfigResponseDto.getApiKey(), openAiCompatibleConfigResponseDto.getApiKeyHeaderName());
                    break;
                }
                default: {
                    aiConfigPolicy = DEFAULT_POLICY;
                }
            }
            return aiConfigPolicy;
        }
        catch (Exception e) {
            this.logger.error("Failed to set AI Config Policy, error: " + e.getMessage(), (Throwable)e);
            this.logger.error("Fallback to USER SETTINGS");
            return DEFAULT_POLICY;
        }
    }

    private void handleError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody), statusCode);
    }

    private void handleServerError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody), statusCode);
    }

    public String extractErrorMessage(String responseBody) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(responseBody);
            String message = rootNode.path("message").asText(null);
            if (message != null) {
                return message;
            }
            message = rootNode.path("error_description").asText(null);
            if (message != null) {
                return message;
            }
            return responseBody;
        }
        catch (Exception exception) {
            return responseBody;
        }
    }
}

