/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.composer.core.webview.browserfunction;

import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.BrowserFunction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.katalon.composer.core.webview.browserfunction.BiRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.composer.core.webview.browserfunction.IRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.JsonRpcRequest;
import com.katalon.composer.core.webview.browserfunction.NoArgRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.QuadConsumer;
import com.katalon.composer.core.webview.browserfunction.QuadRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.RpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.RpcResponse;
import com.katalon.composer.core.webview.browserfunction.TriConsumer;
import com.katalon.composer.core.webview.browserfunction.TriRpcHandlerRegistry;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserFunctionBridge {
    private static final Logger logger = LoggerFactory.getLogger(BrowserFunctionBridge.class);
    private static final String RPC_CALL_FUNCTION_NAME = "onRpcCall";
    private final ConcurrentHashMap<String, IRpcHandlerRegistry> HANDLER_REGISTRY_MAP = new ConcurrentHashMap();

    public void bind(Browser browser) {
        if (browser != null) {
            new BrowserFunction(browser, RPC_CALL_FUNCTION_NAME){

                public Object function(Object[] arguments) {
                    logger.trace("Received RPC call from browser | name = {} | arguments = {}", (Object)BrowserFunctionBridge.RPC_CALL_FUNCTION_NAME, (Object)Arrays.toString(arguments));
                    String jsonRpcDataStr = (String)arguments[0];
                    try {
                        JsonRpcRequest jsonRpcRequest = (JsonRpcRequest)BrowserFunctionUtil.getObjectMapper().readValue(jsonRpcDataStr, JsonRpcRequest.class);
                        String methodName = jsonRpcRequest.method();
                        ArrayNode params = jsonRpcRequest.params();
                        IRpcHandlerRegistry handlerRegistry = BrowserFunctionBridge.this.HANDLER_REGISTRY_MAP.get(methodName);
                        if (handlerRegistry == null) {
                            logger.warn("No handler found for RPC call | name = {} | jsonRpcDataStr = {}", (Object)BrowserFunctionBridge.RPC_CALL_FUNCTION_NAME, (Object)jsonRpcDataStr);
                            return false;
                        }
                        try {
                            logger.trace("Invoking handler for RPC call | name = {} | jsonRpcDataStr = {}", (Object)methodName, (Object)jsonRpcDataStr);
                            handlerRegistry.invoke(params);
                        }
                        catch (Exception e) {
                            logger.error("Error while invoking handler for RPC call | name = %s | jsonRpcDataStr = %s".formatted(BrowserFunctionBridge.RPC_CALL_FUNCTION_NAME, jsonRpcDataStr), (Throwable)e);
                        }
                    }
                    catch (JsonProcessingException e) {
                        logger.error("Failed to parse data from browser function | name = %s | jsonRpcDataStr = %s".formatted(BrowserFunctionBridge.RPC_CALL_FUNCTION_NAME, jsonRpcDataStr), (Throwable)e);
                    }
                    return true;
                }
            };
        }
    }

    public void registerBrowserFunction(String name, Runnable handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null | name = " + name);
        }
        this.HANDLER_REGISTRY_MAP.put(name, new NoArgRpcHandlerRegistry(name, handler));
    }

    public <T> void registerBrowserFunction(String name, Class<T> clazzT, Consumer<T> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.HANDLER_REGISTRY_MAP.put(name, new RpcHandlerRegistry<T>(name, clazzT, handler));
    }

    public <T> void registerBrowserFunction(String name, TypeReference<T> typeRef, Consumer<T> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (typeRef == null) {
            throw new IllegalArgumentException("typeRef must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.HANDLER_REGISTRY_MAP.put(name, new RpcHandlerRegistry<T>(name, typeRef, handler));
    }

    public <T, U> void registerBrowserFunction(String name, Class<T> clazzT, Class<U> clazzU, BiConsumer<T, U> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (clazzU == null) {
            throw new IllegalArgumentException("clazzU must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.HANDLER_REGISTRY_MAP.put(name, new BiRpcHandlerRegistry<T, U>(name, clazzT, clazzU, handler));
    }

    public <T, U, V> void registerBrowserFunction(String name, Class<T> clazzT, Class<U> clazzU, Class<V> clazzV, TriConsumer<T, U, V> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (clazzU == null) {
            throw new IllegalArgumentException("clazzU must not be null");
        }
        if (clazzV == null) {
            throw new IllegalArgumentException("clazzV must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.HANDLER_REGISTRY_MAP.put(name, new TriRpcHandlerRegistry<T, U, V>(name, clazzT, clazzU, clazzV, handler));
    }

    public <T, U, V, W> void registerBrowserFunction(String name, Class<T> clazzT, Class<U> clazzU, Class<V> clazzV, Class<W> clazzW, QuadConsumer<T, U, V, W> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (clazzU == null) {
            throw new IllegalArgumentException("clazzU must not be null");
        }
        if (clazzV == null) {
            throw new IllegalArgumentException("clazzV must not be null");
        }
        if (clazzW == null) {
            throw new IllegalArgumentException("clazzW must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.HANDLER_REGISTRY_MAP.put(name, new QuadRpcHandlerRegistry<T, U, V, W>(name, clazzT, clazzU, clazzV, clazzW, handler));
    }

    public void sendRpcResponse(Browser browser, String id, Object args) {
        BrowserFunctionBridge.internallySendRpcResponse(browser, RpcResponse.fromResult(id, args));
    }

    public void sendRpcError(Browser browser, String id, Object error) {
        BrowserFunctionBridge.internallySendRpcResponse(browser, RpcResponse.fromError(id, error));
    }

    private static void internallySendRpcResponse(Browser browser, RpcResponse rpcResponse) {
        if (browser != null) {
            String method = "onRpcResponse";
            try {
                String responseJson = BrowserFunctionUtil.getObjectMapper().writeValueAsString((Object)rpcResponse);
                String escapedJson = responseJson.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
                String scriptContent = String.format("%s('%s');", method, escapedJson);
                UISynchronizeService.asyncExec(() -> {
                    if (!browser.isDisposed()) {
                        browser.execute(scriptContent);
                    }
                });
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to parse data from browser script called | name = %s | value = %s".formatted(method, rpcResponse), (Throwable)e);
            }
        }
    }

    private static String trimLog(String message) {
        if (message == null || message.length() <= 255) {
            return message;
        }
        return message.substring(0, 252) + "...";
    }
}

