/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.composer.core.webview.browserfunction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.katalon.composer.core.webview.browserfunction.BaseRpcHandlerRegistry;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcHandlerRegistry<T>
extends BaseRpcHandlerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(RpcHandlerRegistry.class);
    private final Class<T> clazz;
    private final TypeReference<T> typeRef;
    private final Consumer<T> handler;
    private final ObjectMapper objectMapper;

    public RpcHandlerRegistry(String name, ObjectMapper objectMapper, Class<T> clazz, Consumer<T> handler) {
        super(name);
        this.clazz = clazz;
        this.typeRef = null;
        this.handler = handler;
        this.objectMapper = objectMapper;
    }

    public RpcHandlerRegistry(String name, Class<T> clazz, Consumer<T> handler) {
        super(name);
        this.clazz = clazz;
        this.typeRef = null;
        this.handler = handler;
        this.objectMapper = null;
    }

    public RpcHandlerRegistry(String name, TypeReference<T> typeRef, Consumer<T> handler) {
        super(name);
        this.clazz = null;
        this.typeRef = typeRef;
        this.handler = handler;
        this.objectMapper = null;
    }

    @Override
    public void invoke(ArrayNode args) {
        if (args.isEmpty()) {
            logger.error("Not enough arguments from browser function | name = {} | expected = 1 | actual = 0", (Object)this.name);
            return;
        }
        try {
            T arg = this.parseArgument(args.get(0), this.typeRef, this.clazz, this.objectMapper);
            UISynchronizeService.asyncExec(() -> this.handler.accept(arg));
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse data from browser function | name = %s | argT = %s".formatted(this.name, args.get(0).toString()), (Throwable)e);
        }
    }
}

