/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.List;
import java.util.stream.Collectors;

public class SystemFileController
extends EntityController {
    private static SystemFileController _instance;

    public static SystemFileController getInstance() {
        if (_instance == null) {
            _instance = new SystemFileController();
        }
        return _instance;
    }

    public SystemFileEntity newFile(String newName, String content, FolderEntity folder) throws ControllerException {
        try {
            return SystemFileController.getDataProviderSetting().getSystemFileDataProvider().newFile(newName, content, folder);
        }
        catch (DALException e) {
            throw new ControllerException(e);
        }
    }

    public List<FileEntity> getChildren(FolderEntity parentFolder) throws ControllerException {
        try {
            return SystemFileController.getDataProviderSetting().getSystemFileDataProvider().getChildren(parentFolder);
        }
        catch (DALException e) {
            throw new ControllerException(e);
        }
    }

    public void deleteFile(SystemFileEntity fileEntity) {
        SystemFileController.getDataProviderSetting().getSystemFileDataProvider().deleteFile(fileEntity);
    }

    public SystemFileEntity renameSystemFile(String newName, SystemFileEntity renamedFile) {
        return SystemFileController.getDataProviderSetting().getSystemFileDataProvider().renameFile(newName, renamedFile);
    }

    public List<FileEntity> getSiblingFiles(SystemFileEntity renamedFile, FolderEntity parentFolder) throws ControllerException {
        return this.getChildren(parentFolder).stream().filter(f -> !f.getName().equals(renamedFile.getName())).collect(Collectors.toList());
    }

    public SystemFileEntity copySystemFile(SystemFileEntity sourceFile, FolderEntity targetFolder) throws DALException {
        return SystemFileController.getDataProviderSetting().getSystemFileDataProvider().copyFile(sourceFile, targetFolder);
    }

    public SystemFileEntity moveSystemFile(SystemFileEntity systemFile, FolderEntity targetFolder) throws DALException {
        return SystemFileController.getDataProviderSetting().getSystemFileDataProvider().moveFile(systemFile, targetFolder);
    }

    public SystemFileEntity getSystemFile(String systemFilePath, ProjectEntity projectEntity) throws ControllerException {
        try {
            return SystemFileController.getDataProviderSetting().getSystemFileDataProvider().getSystemFile(systemFilePath, projectEntity);
        }
        catch (DALException e) {
            throw new ControllerException(e);
        }
    }

    public SystemFileEntity getSystemFileFromDisplayId(String displayId, ProjectEntity projectEntity) throws ControllerException {
        try {
            return SystemFileController.getDataProviderSetting().getSystemFileDataProvider().getSystemFileFromDisplayId(displayId, projectEntity);
        }
        catch (DALException e) {
            throw new ControllerException(e);
        }
    }
}

