/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.core.model;

import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.ManagedAzureOpenAiConfig;
import com.kms.katalon.session.core.model.ManagedGeminiConfig;
import com.kms.katalon.session.core.model.ManagedOpenAiCompatibleConfig;
import com.kms.katalon.session.core.model.ManagedOpenAiConfig;
import java.util.Optional;

public class AiConfigPolicy {
    private final AiConfigPolicyType aiConfigPolicyType;
    private ManagedAzureOpenAiConfig managedAzureOpenAiConfig;
    private ManagedOpenAiConfig managedOpenAiConfig;
    private ManagedGeminiConfig managedGeminiAiConfig;
    private ManagedOpenAiCompatibleConfig managedOpenAiCompatibleConfig;

    public AiConfigPolicy(AiConfigPolicyType aiConfigPolicyType) {
        this.aiConfigPolicyType = aiConfigPolicyType;
    }

    public Optional<ManagedAzureOpenAiConfig> getManagedAzureOpenAi() {
        if (this.aiConfigPolicyType != AiConfigPolicyType.ADMINISTRATION_MANAGED_AZURE_OPENAI) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.managedAzureOpenAiConfig);
    }

    public Optional<ManagedOpenAiConfig> getManagedOpenAi() {
        if (this.aiConfigPolicyType != AiConfigPolicyType.ADMINISTRATION_MANAGED_OPENAI) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.managedOpenAiConfig);
    }

    public Optional<ManagedGeminiConfig> getManagedGeminiAiConfig() {
        if (this.aiConfigPolicyType != AiConfigPolicyType.ADMINISTRATION_MANAGED_GEMINI) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.managedGeminiAiConfig);
    }

    public Optional<ManagedOpenAiCompatibleConfig> getManagedOpenAiCompatible() {
        if (this.aiConfigPolicyType != AiConfigPolicyType.ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.managedOpenAiCompatibleConfig);
    }

    public void setManagedAzureOpenAi(String apiKey, String apiBase, String deploymentId, String apiVersion) {
        this.managedAzureOpenAiConfig = new ManagedAzureOpenAiConfig(apiKey, apiBase, deploymentId, apiVersion);
    }

    public void setManagedOpenAi(String apiKey, String organization) {
        this.managedOpenAiConfig = new ManagedOpenAiConfig(apiKey, organization);
    }

    public AiConfigPolicyType getAiConfigPolicyType() {
        return this.aiConfigPolicyType;
    }

    public void setManagedGeminiAiConfig(String baseUrl, String apiKey) {
        this.managedGeminiAiConfig = new ManagedGeminiConfig(baseUrl, apiKey);
    }

    public void setManagedOpenAiCompatibleConfig(String baseUrl, String apiKey, String apiKeyHeaderName) {
        this.managedOpenAiCompatibleConfig = new ManagedOpenAiCompatibleConfig(baseUrl, apiKey, apiKeyHeaderName);
    }
}

