/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.core.model;

import com.kms.katalon.session.core.model.ActivationNotice;
import com.kms.katalon.session.core.model.Feature;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.exception.LicenseException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.io.pem.PemReader;

public class License {
    private static final String EXPIRATION_DATE = "expirationDate";
    private static final String FEATURES = "features";
    private static final String OFFLINE_LICENSE_FEATURE_KEY_FLAG = "offline";
    private static final String LICENSE_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAljznsPZafPzlRo+NyyVTb4ZJaLYtSghoi0lNDOEyHNJhROWi7roPcK0mMkVz+2tCE0OXL+Aps0IS5zHwTZpNMSu7t7IEgFUfUJ7ZSUNM1HGo/kcwJc4knBdK2Zi0QS0bu30VIp9zBmvtuGsxrGTfmV8TI091SHAQfWWJjD2UPfHxz0xeyGNwInSEjJhhV67Cl1r9RlrDUt5Ai2/r5s1AtFD/UDLHObAkGKY4CO7Ei/PnH8OJi9S6MtW5o6NWAjBY4qj1brUGl/IX46KRIny7zJ1zoVSsy8plBBGs9VFAyky7sq7fkjZFvbBw46PWWTFZCuSYeFiXul2IKTVLWaqE0wIDAQAB\n-----END PUBLIC KEY-----";
    private static final String LICENSE_TYPE = "licenseType";
    private static final String MACHINE_ID = "machineId";
    private static final String ORGANIZATION_ID = "organizationId";
    private static final String RENEW_TIME = "renewTime";
    private static final String TESTING = "testing";
    private Long expirationDate;
    private List<Feature> features;
    private Long licenseId;
    private LicenseType licenseType;
    private String machineId;
    private Long organizationId;
    private Organization organization;
    private Long renewTime;
    private boolean testing;
    private String jwt;
    private String publicKey;
    private ActivationNotice activationNotice;

    public static License parseJwt(String jwt) throws LicenseException {
        return License.parseJwt(jwt, LICENSE_PUBLIC_KEY);
    }

    public static License parseJwt(String jwt, String publicKey) throws LicenseException {
        if (StringUtils.isBlank((CharSequence)jwt) || StringUtils.isBlank((CharSequence)publicKey)) {
            return null;
        }
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)jwt);
            RSAPublicKey key = (RSAPublicKey)License.getPublicKey(publicKey);
            RSASSAVerifier verifier = new RSASSAVerifier(key);
            boolean valid = signedJWT.verify((JWSVerifier)verifier);
            if (!valid) {
                throw new LicenseException("Invalid license signature");
            }
            JWTClaimsSet claims = signedJWT.getJWTClaimsSet();
            return License.createLicense(jwt, publicKey, claims);
        }
        catch (Exception e) {
            throw new LicenseException("Invalid license", e);
        }
    }

    public static License parseJwtFromFile(String filename) throws LicenseException, IOException {
        String jwt = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
        return License.parseJwt(jwt);
    }

    private static License createLicense(String jwt, String pubKey, JWTClaimsSet claimSet) throws ParseException {
        License license = new License();
        license.jwt = jwt;
        license.publicKey = pubKey;
        Map claims = claimSet.getClaims();
        license.setLicenseType(LicenseType.valueOf(claimSet.getStringClaim(LICENSE_TYPE)));
        license.setExpirationDate(claimSet.getLongClaim(EXPIRATION_DATE));
        license.setRenewTime(claimSet.getLongClaim(RENEW_TIME));
        license.setMachineId(claimSet.getStringClaim(MACHINE_ID));
        if (claims.containsKey(ORGANIZATION_ID)) {
            license.setOrganizationId(claimSet.getLongClaim(ORGANIZATION_ID));
        }
        if (claims.containsKey(TESTING)) {
            license.setTesting(claimSet.getBooleanClaim(TESTING));
        }
        List<Feature> features = claimSet.getListClaim(FEATURES).stream().map(obj -> {
            void keyString;
            String nameString;
            Object key;
            block5: {
                block4: {
                    void map;
                    if (!(obj instanceof Map)) {
                        return null;
                    }
                    Map map2 = (Map)obj;
                    Object name = map.get("name");
                    key = map.get("key");
                    if (!(name instanceof String)) break block4;
                    nameString = (String)name;
                    if (key instanceof String) break block5;
                }
                return null;
            }
            String string = (String)key;
            Feature feature = new Feature();
            feature.setName(nameString);
            feature.setKey((String)keyString);
            return feature;
        }).filter(f -> f != null).toList();
        license.setFeatures(features);
        return license;
    }

    private static PublicKey getPublicKey(String publicKeyString) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        if (StringUtils.isBlank((CharSequence)publicKeyString)) {
            return null;
        }
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(License.readPemString(publicKeyString));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    private static byte[] readPemString(String string) throws IOException {
        StringReader reader = new StringReader(string);
        PemReader pemReader = new PemReader((Reader)reader);
        return pemReader.readPemObject().getContent();
    }

    public boolean doesReachRenewTime() {
        Date currentDate = new Date();
        Instant instant = Instant.ofEpochSecond(this.renewTime);
        return currentDate.after(Date.from(instant));
    }

    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public Long getLicenseId() {
        return this.licenseId;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public Long getOrganizationId() {
        return this.organizationId;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Long getRenewTime() {
        return this.renewTime;
    }

    public String getJwt() {
        return this.jwt;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean isExpired() {
        Date currentDate = new Date();
        Instant instant = Instant.ofEpochSecond(this.expirationDate);
        return currentDate.after(Date.from(instant));
    }

    public boolean isOffline() {
        return this.features.stream().map(Feature::getKey).anyMatch(OFFLINE_LICENSE_FEATURE_KEY_FLAG::equals);
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setExpirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public void setLicenseId(Long licenseId) {
        this.licenseId = licenseId;
    }

    public void setLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setRenewTime(Long renewTime) {
        this.renewTime = renewTime;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public ActivationNotice getActivationNotice() {
        return this.activationNotice;
    }

    public void setActivationNotice(ActivationNotice activationNotice) {
        this.activationNotice = activationNotice;
    }
}

