/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite.imports;

import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;

final class ImportDeclarationWriter {
    private final Boolean insertSpaceBeforeSemicolon;

    ImportDeclarationWriter(Boolean insertSpaceBeforeSemicolon) {
        this.insertSpaceBeforeSemicolon = insertSpaceBeforeSemicolon;
    }

    String writeImportDeclaration(ImportName importName) {
        StringBuilder sb = new StringBuilder();
        sb.append("import ");
        if (importName.isStatic) {
            sb.append("static ");
        }
        if (importName.isModule) {
            sb.append("module ");
        }
        sb.append(importName.qualifiedName);
        if (this.insertSpaceBeforeSemicolon == null) {
            return sb.toString();
        }
        if (this.insertSpaceBeforeSemicolon.booleanValue()) {
            sb.append(' ');
        }
        sb.append(';');
        return sb.toString();
    }
}

