/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ASTScanner;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates.ClosuresInCodePredicate;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.KlenkDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.ListInCodePredicate;
import org.codehaus.groovy.eclipse.refactoring.formatter.SemicolonRemover;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GroovyBeautifier {
    private static final boolean DEBUG_EDITS = false;
    public final DefaultGroovyFormatter formatter;
    private final IFormatterPreferences preferences;
    private final Set<Token> ignoreToken = new HashSet<Token>();

    public GroovyBeautifier(DefaultGroovyFormatter formatter, IFormatterPreferences preferences) {
        this.formatter = formatter;
        this.preferences = preferences;
    }

    public TextEdit getBeautifiEdits() throws BadLocationException {
        try {
            MultiTextEdit edits = new MultiTextEdit();
            this.combineClosures(edits);
            this.formatLists(edits);
            this.correctBraces(edits);
            this.removeUnnecessarySemicolons(edits);
            MultiTextEdit multiTextEdit = edits;
            return multiTextEdit;
        }
        finally {
            this.formatter.getTokens().dispose();
        }
    }

    private void combineClosures(MultiTextEdit edits) throws BadLocationException {
        ASTScanner scanner = new ASTScanner(this.formatter.getProgressRootNode(), new ClosuresInCodePredicate(), this.formatter.getProgressDocument());
        scanner.startASTscan();
        for (ASTNode node : scanner.getMatchedNodes().keySet()) {
            ClosureExpression clExp = (ClosureExpression)node;
            int posClStart = this.formatter.getPosOfToken(GroovyTokenTypeBridge.LCURLY, clExp.getLineNumber(), clExp.getColumnNumber(), "{");
            if (posClStart == -1) continue;
            int posCLEnd = this.formatter.getPosOfToken(GroovyTokenTypeBridge.RCURLY, clExp.getLastLineNumber(), clExp.getLastColumnNumber() - 1, "}");
            if (posCLEnd == -1) {
                int positionLastTokenOfClosure = this.formatter.getPosOfToken(clExp.getLastLineNumber(), clExp.getLastColumnNumber());
                while (this.formatter.getTokens().get(positionLastTokenOfClosure).getType() != GroovyTokenTypeBridge.RCURLY) {
                    --positionLastTokenOfClosure;
                }
                posCLEnd = positionLastTokenOfClosure;
            }
            if (clExp.getLineNumber() == clExp.getLastLineNumber()) {
                this.ignoreToken.add(this.formatter.getTokens().get(posCLEnd));
                continue;
            }
            if (!(clExp.getCode() instanceof BlockStatement)) continue;
            int posParamDelim = posClStart;
            if (clExp.isParameterSpecified()) {
                posParamDelim = this.formatter.getPosOfNextTokenOfType(posClStart, GroovyTokenTypeBridge.CLOSABLE_BLOCK_OP);
                this.replaceNLSWithSpace(edits, posClStart, posParamDelim);
            }
            if (posParamDelim > 0 && this.formatter.getNextTokenIncludingNLS(posParamDelim).getType() != GroovyTokenTypeBridge.NLS) {
                this.addEdit((TextEdit)new InsertEdit(this.formatter.getOffsetOfTokenEnd(this.formatter.getTokens().get(posParamDelim)), this.formatter.getNewLine()), (TextEdit)edits);
                continue;
            }
            if (posParamDelim != 0 || this.formatter.getNextTokenIncludingNLS(posClStart).getType() == GroovyTokenTypeBridge.NLS) continue;
            this.addEdit((TextEdit)new InsertEdit(this.formatter.getOffsetOfTokenEnd(this.formatter.getTokens().get(posClStart)), this.formatter.getNewLine()), (TextEdit)edits);
        }
    }

    private void formatLists(MultiTextEdit edits) {
        ASTScanner scanner = new ASTScanner(this.formatter.getProgressRootNode(), new ListInCodePredicate(), this.formatter.getProgressDocument());
        scanner.startASTscan();
        for (ASTNode node : scanner.getMatchedNodes().keySet()) {
            ListExpression listExpr = (ListExpression)node;
            KlenkDocumentScanner tokens = this.formatter.getTokens();
            try {
                int lbrackOffset = listExpr.getStart();
                int rbrackOffset = listExpr.getEnd() - 1;
                while (Character.isWhitespace(this.formatter.getProgressDocument().getChar(rbrackOffset))) {
                    --rbrackOffset;
                }
                assert (this.formatter.getProgressDocument().getChar(lbrackOffset) == '[');
                assert (this.formatter.getProgressDocument().getChar(rbrackOffset) == ']');
                Token penultimate = tokens.getLastNonWhitespaceTokenBefore(rbrackOffset);
                if (penultimate.getType() == GroovyTokenTypeBridge.STRING_CTOR_START) continue;
                boolean wrap = rbrackOffset - lbrackOffset > this.preferences.getLongListLength() || listExpr.getExpressions().size() > 1 && this.hasClosureElement(listExpr);
                for (Expression exp : listExpr.getExpressions()) {
                    Token previous = tokens.getLastTokenBefore(exp.getStart());
                    while (previous.getType() != GroovyTokenTypeBridge.LBRACK && previous.getType() != GroovyTokenTypeBridge.COMMA) {
                        previous = tokens.getLastTokenBefore(previous);
                    }
                    String prefix = wrap ? this.formatter.getNewLine() : (previous.getType() == GroovyTokenTypeBridge.LBRACK ? "" : " ");
                    this.replaceWhiteSpaceAfter(edits, previous, prefix);
                }
                String suffix = wrap || penultimate.getType() == GroovyTokenTypeBridge.SL_COMMENT ? this.formatter.getNewLine() : "";
                this.replaceWhiteSpaceAfter(edits, penultimate, suffix);
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
    }

    private void replaceWhiteSpaceAfter(MultiTextEdit edits, Token token, String replacement) {
        KlenkDocumentScanner tokens = this.formatter.getTokens();
        try {
            Token first;
            Token last = first = tokens.getNextToken(token);
            while (this.isWhiteSpace(last.getType())) {
                last = tokens.getNextToken(last);
            }
            int offset = tokens.getEnd(token);
            int length = tokens.getOffset(last) - offset;
            this.addEdit((TextEdit)new ReplaceEdit(offset, length, replacement), (TextEdit)edits);
        }
        catch (BadLocationException e) {
            Util.log((Throwable)e);
        }
    }

    private boolean isWhiteSpace(int type) {
        return type == GroovyTokenTypeBridge.WS || type == GroovyTokenTypeBridge.NLS;
    }

    private boolean hasClosureElement(ListExpression node) {
        List list = node.getExpressions();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof ClosureExpression) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void replaceNLSWithSpace(MultiTextEdit container, int startPos, int endPos) throws BadLocationException {
        Token token;
        Token fromToken = null;
        int p = startPos + 1;
        while (p < endPos) {
            token = this.formatter.getTokens().get(p);
            int ttype = token.getType();
            if (ttype == GroovyTokenTypeBridge.NLS) {
                if (fromToken == null) {
                    fromToken = token;
                }
            } else {
                if (ttype == GroovyTokenTypeBridge.SL_COMMENT) {
                    ++p;
                }
                if (fromToken != null) {
                    this.addEdit(this.newReplaceEdit(fromToken, token, " "), (TextEdit)container);
                    fromToken = null;
                }
            }
            ++p;
        }
        if (fromToken != null) {
            token = this.formatter.getTokens().get(p);
            this.addEdit(this.newReplaceEdit(fromToken, token, " "), (TextEdit)container);
        }
    }

    private TextEdit newReplaceEdit(Token fromToken, Token toToken, String replacement) throws BadLocationException {
        int offset = this.formatter.getOffsetOfToken(fromToken);
        int length = this.formatter.getOffsetOfToken(toToken) - offset;
        return new ReplaceEdit(offset, length, replacement);
    }

    private void correctBraces(MultiTextEdit edits) throws BadLocationException {
        BiFunction<Integer, Token, TextEdit> lCurlyEditor = this.getBracesEditor(this.preferences.getBracesStart());
        BiFunction<Integer, Token, TextEdit> rCurlyEditor = this.getBracesEditor(this.preferences.getBracesEnd());
        KlenkDocumentScanner tokens = this.formatter.getTokens();
        int i = 0;
        int slc_nls = 0;
        while (i < tokens.size()) {
            Token token = tokens.get(i);
            if (!this.ignoreToken.contains(token)) {
                int tokenType = token.getType();
                if (tokenType == GroovyTokenTypeBridge.SL_COMMENT) {
                    slc_nls = 1;
                } else if (tokenType == GroovyTokenTypeBridge.NLS) {
                    slc_nls = slc_nls == 1 ? 2 : 0;
                } else if (tokenType == GroovyTokenTypeBridge.LCURLY && slc_nls == 0) {
                    ClosureExpression maybeClosure = this.formatter.findCorrespondingClosure(token);
                    if (maybeClosure == null || maybeClosure.getLineNumber() != maybeClosure.getLastLineNumber()) {
                        int type;
                        Token nextToken;
                        this.addEdit(lCurlyEditor.apply(i, token), (TextEdit)edits);
                        ASTNode node = this.formatter.findCorrespondingNode(token);
                        if (!(node != null && (node instanceof ClosureExpression || node instanceof CastExpression || node instanceof ArgumentListExpression) || (nextToken = tokens.getNextToken(token)) == null || (type = nextToken.getType()) == GroovyTokenTypeBridge.EOF || type == GroovyTokenTypeBridge.NLS || type == GroovyTokenTypeBridge.RCURLY)) {
                            int offset = tokens.getEnd(token);
                            int length = tokens.getOffset(nextToken) - offset;
                            this.addEdit((TextEdit)new ReplaceEdit(offset, length, this.formatter.getNewLine()), (TextEdit)edits);
                        }
                    }
                } else if (tokenType == GroovyTokenTypeBridge.RCURLY && slc_nls == 0) {
                    Token previousToken = tokens.getLastTokenBefore(token);
                    if (previousToken.getType() != GroovyTokenTypeBridge.LCURLY) {
                        this.addEdit(rCurlyEditor.apply(i, token), (TextEdit)edits);
                    }
                } else {
                    slc_nls = 0;
                }
            }
            ++i;
        }
    }

    private BiFunction<Integer, Token, TextEdit> getBracesEditor(int style) {
        if (style == 1) {
            return (index, token) -> {
                try {
                    Token lastNonNLS = this.formatter.getPreviousToken((int)index);
                    int offset = this.formatter.getOffsetOfTokenEnd(lastNonNLS);
                    int length = this.formatter.getOffsetOfToken((Token)token) - offset;
                    return new ReplaceEdit(offset, length, this.formatter.getNewLine());
                }
                catch (BadLocationException e) {
                    Util.log((Throwable)e);
                    return null;
                }
            };
        }
        if (style == 0) {
            return (index, token) -> {
                if (this.formatter.getPreviousTokenIncludingNLS((int)index).getType() == GroovyTokenTypeBridge.NLS) {
                    try {
                        Token lastNonNLS = this.formatter.getPreviousToken((int)index);
                        int offset = this.formatter.getOffsetOfTokenEnd(lastNonNLS);
                        int length = this.formatter.getOffsetOfToken((Token)token) - offset;
                        return new ReplaceEdit(offset, length, " ");
                    }
                    catch (BadLocationException e) {
                        Util.log((Throwable)e);
                    }
                }
                return null;
            };
        }
        return null;
    }

    private void removeUnnecessarySemicolons(MultiTextEdit edits) {
        if (this.preferences.isRemoveUnnecessarySemicolons()) {
            new SemicolonRemover(this.formatter.selection, this.formatter.document, edits).format();
        }
    }

    private void addEdit(TextEdit edit, TextEdit container) {
        if (edit != null && edit.getOffset() >= this.formatter.formatOffset && edit.getOffset() + edit.getLength() <= this.formatter.formatOffset + this.formatter.formatLength) {
            try {
                container.addChild(edit);
            }
            catch (MalformedTreeException malformedTreeException) {
                // empty catch block
            }
        }
    }
}

