/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common.future;

import com.kms.katalon.core.webui.exception.AbortException;
import com.kms.katalon.logging.LogUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class AbortSignal {
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private String reason;
    private final CopyOnWriteArrayList<Consumer<AbortSignal>> listeners = new CopyOnWriteArrayList();

    public void abort(String reason) {
        if (this.aborted.compareAndSet(false, true)) {
            this.reason = reason;
            for (Consumer<AbortSignal> listener : this.listeners) {
                try {
                    listener.accept(this);
                }
                catch (Exception e) {
                    LogUtil.logError((Throwable)e, (String)("Error in abort listener: " + e.getMessage()));
                }
            }
            this.listeners.clear();
        }
    }

    public boolean isAborted() {
        return this.aborted.get();
    }

    public String getReason() {
        return this.reason;
    }

    public void throwIfAborted() {
        if (this.isAborted()) {
            throw new AbortException(this.reason);
        }
    }

    public void addListener(Consumer<AbortSignal> listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Consumer<AbortSignal> listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }
}

