/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.keyword.internal.KeywordExecutor;
import com.kms.katalon.core.webui.common.internal.SmartWait;
import com.kms.katalon.selenium.driver.IDelayableDriver;
import java.util.Optional;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverListener;

public class KatalonSmartEventListener
implements WebDriverListener {
    private final WebDriver driver;

    public KatalonSmartEventListener(WebDriver driver) {
        this.driver = driver;
    }

    public void beforeClick(WebElement element) {
        this.doDelay(this.driver);
    }

    public void beforeSendKeys(WebElement element, CharSequence[] keysToSend) {
        this.doDelay(this.driver);
    }

    public void beforeBack(WebDriver.Navigation navigation) {
        this.doDelay(this.driver);
    }

    public void beforeForward(WebDriver.Navigation navigation) {
        this.doDelay(this.driver);
    }

    public void beforeRefresh(WebDriver.Navigation navigation) {
        this.doDelay(this.driver);
    }

    public void beforeTo(WebDriver.Navigation navigation, String url) {
        this.doDelay(this.driver);
    }

    public void beforeAccept(Alert alert) {
        this.doDelay(this.driver);
    }

    public void beforeDismiss(Alert alert) {
        this.doDelay(this.driver);
    }

    public void beforeFindElement(WebDriver driver, By locator) {
        this.doSmartWait(driver, KatalonSmartEventListener.getKeywordExecutor().getRemainingKeywordTimeoutInMillis());
    }

    public void beforeFindElements(WebDriver driver, By locator) {
        this.doSmartWait(driver, KatalonSmartEventListener.getKeywordExecutor().getRemainingKeywordTimeoutInMillis());
    }

    public void beforeFindElement(WebElement element, By locator) {
        this.doSmartWait(this.driver, KatalonSmartEventListener.getKeywordExecutor().getRemainingKeywordTimeoutInMillis());
    }

    public void beforeFindElements(WebElement element, By locator) {
        this.doSmartWait(this.driver, KatalonSmartEventListener.getKeywordExecutor().getRemainingKeywordTimeoutInMillis());
    }

    private void doDelay(WebDriver driver) {
        if (driver instanceof IDelayableDriver) {
            IDelayableDriver delayableDriver = (IDelayableDriver)driver;
            delayableDriver.delay();
        }
    }

    private void doSmartWait(WebDriver driver, long remainingTimeoutInMillis) {
        boolean localSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("localSmartWaitEnabled")).orElse(true);
        boolean globalSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("globalSmartWaitEnabled")).orElse(false);
        if (globalSmartWaitEnabled && localSmartWaitEnabled) {
            SmartWait.doSmartWait(driver, remainingTimeoutInMillis);
        }
    }

    private static KeywordExecutor getKeywordExecutor() {
        return KeywordExecutor.getInstance((String)"web");
    }
}

