/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver.bidi;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.util.FileUtil;
import com.kms.katalon.util.UrlUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.module.Script;

public class BiDiDriverUtil {
    protected static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);
    private static final String[] SMART_LOCATOR_SCRIPTS = new String[]{"smart-locator-bundle.js", "smart-locator.js"};
    private static final String SMART_WAIT_SCRIPT = "smart-wait.js";
    private static final String FLUTTER_APP_TESTING_SCRIPT = "flutter-based-app-testing.js";
    private static final String CANVAS_TEXT_EXTRACTION_SCRIPT = "canvas-text-extraction.js";
    private static final String CLOSED_SHADOW_DOM_SCRIPT = "closed-shadow-dom-testing.js";

    private static File getScriptFolder() throws IOException {
        return new File(FileUtil.getExtensionsDirectory(), "scripts");
    }

    public static boolean hasBiDiCapability(Capabilities capabilities) {
        return capabilities.getCapability("webSocketUrl") != null;
    }

    public static boolean getBiDiCapability(Capabilities capabilities) {
        String webSocketUrlCapAsString;
        Object webSocketUrlCap = capabilities.getCapability("webSocketUrl");
        Boolean value = null;
        value = webSocketUrlCap instanceof String ? Boolean.valueOf(Boolean.parseBoolean(webSocketUrlCapAsString = (String)webSocketUrlCap) || Boolean.valueOf(UrlUtil.isWebUrl((String)webSocketUrlCapAsString)) != false) : (Boolean)webSocketUrlCap;
        return value != null && value != false;
    }

    public static boolean injectSmartWaitScript(WebDriver driver) {
        return BiDiDriverUtil.safeInjectScript(driver, SMART_WAIT_SCRIPT);
    }

    public static boolean injectSmartLocatorScript(WebDriver driver) {
        boolean allScriptsSuccessful = true;
        String[] stringArray = SMART_LOCATOR_SCRIPTS;
        int n = SMART_LOCATOR_SCRIPTS.length;
        int n2 = 0;
        while (n2 < n) {
            String script = stringArray[n2];
            boolean isInjected = BiDiDriverUtil.safeInjectScript(driver, script);
            if (!isInjected) {
                allScriptsSuccessful = false;
            }
            ++n2;
        }
        return allScriptsSuccessful;
    }

    public static boolean injectFlutterAppTestingScript(WebDriver driver) {
        return BiDiDriverUtil.safeInjectScript(driver, FLUTTER_APP_TESTING_SCRIPT);
    }

    public static boolean injectCanvasTextExtractionScript(WebDriver driver) {
        return BiDiDriverUtil.safeInjectScript(driver, CANVAS_TEXT_EXTRACTION_SCRIPT);
    }

    public static boolean injectClosedShadowDOMTestingScript(WebDriver driver) {
        return BiDiDriverUtil.safeInjectScript(driver, CLOSED_SHADOW_DOM_SCRIPT);
    }

    protected static boolean safeInjectScript(WebDriver driver, String scriptName) {
        HasBiDi hasBiDiWebDriver;
        if (driver instanceof HasBiDi && (hasBiDiWebDriver = (HasBiDi)driver).maybeGetBiDi().isPresent()) {
            try {
                BiDiDriverUtil.injectPreloadScript(driver, scriptName);
                return true;
            }
            catch (IOException error) {
                logger.logWarning("Cannot inject preload script: " + scriptName, null, (Throwable)error);
                return false;
            }
        }
        logger.logWarning("Your browser version or type does not support the BiDirectional WebDriver Protocol which is required for Smart Locator functionality. Please update your browser or switch to a compatible one.");
        return false;
    }

    protected static void injectPreloadScript(WebDriver driver, String scriptName) throws IOException {
        File scriptFile = new File(BiDiDriverUtil.getScriptFolder(), scriptName);
        String scriptContent = FileUtils.readFileToString((File)scriptFile, (String)"UTF-8");
        Throwable throwable = null;
        Object var5_6 = null;
        try (Script script = new Script(driver);){
            script.addPreloadScript("() => {" + scriptContent + "}");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getScriptContent(String scriptName) throws IOException {
        File scriptFile = new File(BiDiDriverUtil.getScriptFolder(), scriptName);
        return FileUtils.readFileToString((File)scriptFile, (String)"UTF-8");
    }
}

