/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver.chrome;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.common.internal.SeleniumBrowserInfo;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.exception.SeleniumManagerException;
import com.kms.katalon.core.webui.util.FileExcutableUtil;
import com.kms.katalon.core.webui.util.OSUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.manager.SeleniumManager;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverUtil {
    protected static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeDriverUtil.class);

    public static String getChromeDriverPath() {
        if (OSUtil.isWindows()) {
            if (OSUtil.is64Bit()) {
                File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_win64/chromedriver.exe");
                if (location.exists()) {
                    logger.logInfo("Custom Chrome detected at location: " + location.getAbsolutePath());
                    return location.getAbsolutePath();
                }
            } else {
                File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_win32/chromedriver.exe");
                if (location.exists()) {
                    logger.logInfo("Custom Chrome detected at location: " + location.getAbsolutePath());
                    return location.getAbsolutePath();
                }
            }
        } else if (OSUtil.isMac()) {
            File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_mac64/chromedriver");
            String chromeDriverPath = location.getAbsolutePath();
            if (location.exists()) {
                try {
                    logger.logInfo("Custom Chrome detected at location: " + location.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(chromeDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make Chrome driver file: " + location.getAbsolutePath() + "executable");
                }
                return location.getAbsolutePath();
            }
        } else if (OSUtil.is64Bit()) {
            File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_linux64/chromedriver");
            String chromeDriverPath = location.getAbsolutePath();
            if (location.exists()) {
                try {
                    logger.logInfo("Custom Chrome detected at location: " + location.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(chromeDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make Chrome driver file:" + location.getAbsolutePath() + " executable");
                }
                return location.getAbsolutePath();
            }
        } else {
            File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_linux32/chromedriver");
            String chromeDriverPath = location.getAbsolutePath();
            if (location.exists()) {
                try {
                    logger.logInfo("Custom Chrome detected at location: " + location.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(chromeDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make Chrome driver file:" + location.getAbsolutePath() + "executable");
                }
                return location.getAbsolutePath();
            }
        }
        return RunConfiguration.getDriverSystemProperty((String)"WebUI", (String)"chromeDriverPath");
    }

    public static SeleniumBrowserInfo getSeleniumBrowserInfo(String browserVersion) {
        LOGGER.info("Checking and download if needed Chrome browser and driver for Chrome for Testing version %s (This may take a while in case of downloading needed)".formatted(StringUtils.isNotBlank((CharSequence)browserVersion) ? browserVersion : "latest"));
        ArrayList<String> args = new ArrayList<String>();
        args.add("--browser");
        args.add("chrome");
        if (StringUtils.isNotBlank((CharSequence)browserVersion)) {
            args.add("--browser-version");
            args.add(browserVersion);
        }
        args.add("--force-browser-download");
        try {
            long startTime = System.currentTimeMillis();
            SeleniumManager instance = SeleniumManager.getInstance();
            SeleniumManagerOutput.Result result = instance.getBinaryPaths(args);
            LOGGER.info("Checking Chrome browser and driver completed in %s ms".formatted(System.currentTimeMillis() - startTime));
            if (result == null) {
                throw new SeleniumManagerException("Unknown error occurred during checking Chrome browser and driver");
            }
            if (result.getCode() == 0) {
                String driverPath = result.getDriverPath();
                String browserPath = result.getBrowserPath();
                return new SeleniumBrowserInfo(driverPath, browserPath);
            }
            throw new SeleniumManagerException("Checking Chrome browser and driver got error | code = %s | message = %s".formatted(result.getCode(), result.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error("Exception while checking checking Chrome browser and driver", (Throwable)e);
            throw e;
        }
    }
}

