/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver.remote;

import com.kms.katalon.core.appium.util.AppiumDriverUtil;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.BaseDriverBuilder;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.smart.SmartDriverUtil;
import com.kms.katalon.core.webui.util.URLUtils;
import com.kms.katalon.core.webui.util.WebDriverProxyUtil;
import com.kms.katalon.core.webui.util.WebDriverUtil;
import com.kms.katalon.selenium.driver.CRemoteWebDriver;
import com.kms.katalon.selenium.validator.W3CCapabilitiesValidator;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.remote.AppiumCommandExecutor;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;

public class GenericRemoteDriverBuilder
extends BaseDriverBuilder {
    public static final String DRIVER_TYPE_APPIUM = "Appium";
    public static final String DRIVER_TYPE_SELENIUM = "Selenium";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME = "platformName";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME_ANDROID = "android";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME_IOS = "ios";

    @Override
    public WebDriver build() throws Exception {
        WebDriver driver;
        ProxyInformation proxyInfo;
        MutableCapabilities desiredCapabilities = new MutableCapabilities().merge(this.capabilities);
        String remoteWebServerUrl = DriverFactory.getRemoteWebDriverServerUrl();
        String remoteWebServerType = DriverFactory.getRemoteWebDriverServerType();
        if (remoteWebServerType == null) {
            remoteWebServerType = DRIVER_TYPE_SELENIUM;
        }
        if ((proxyInfo = RunConfiguration.getProxyInformation()) != null && proxyInfo.isApplyToDesiredCapabilities() && !GenericRemoteDriverBuilder.isEdgeBrowser((Capabilities)desiredCapabilities)) {
            desiredCapabilities.setCapability("proxy", (Object)WebDriverProxyUtil.getSeleniumProxy(proxyInfo));
        }
        if (!TestCloudPropertyUtil.getInstance().isRunFromTestCloud((Capabilities)desiredCapabilities)) {
            logger.logInfo(MessageFormat.format(StringConstants.XML_LOG_CONNECTING_TO_REMOTE_WEB_SERVER_X_WITH_TYPE_Y, URLUtils.removeCrendentialsFromURL(remoteWebServerUrl), remoteWebServerType));
        }
        if (!remoteWebServerType.equals(DRIVER_TYPE_APPIUM)) {
            W3CCapabilitiesValidator.validate((Capabilities)desiredCapabilities);
            HttpCommandExecutor seleniumExecutor = WebDriverUtil.getHttpCommandExecutorForRemoteDriver(new URL(remoteWebServerUrl), desiredCapabilities);
            driver = new CRemoteWebDriver((CommandExecutor)seleniumExecutor, (Capabilities)desiredCapabilities, driverConfigProvider.getActionDelayInMilisecond());
        } else {
            driver = this.createAppiumDriver(desiredCapabilities, remoteWebServerUrl);
        }
        this.injectSmartExtensions(driver);
        return SmartDriverUtil.createSmartDriver(driver);
    }

    /*
     * WARNING - void declaration
     */
    private WebDriver createAppiumDriver(MutableCapabilities desiredCapabilities, String remoteWebServerUrl) throws Exception {
        void platformName;
        Object platform = GenericRemoteDriverBuilder.getPlatformName((Capabilities)desiredCapabilities);
        if (platform instanceof Platform) {
            Platform platformEnum = (Platform)platform;
            switch (platformEnum) {
                case ANDROID: {
                    platform = APPIUM_CAPABILITY_PLATFORM_NAME_ANDROID;
                    break;
                }
                case IOS: {
                    platform = APPIUM_CAPABILITY_PLATFORM_NAME_IOS;
                    break;
                }
            }
        }
        if (!(platform instanceof String)) {
            throw new StepFailedException(MessageFormat.format(StringConstants.DRI_MISSING_PROPERTY_X_FOR_APPIUM_REMOTE_WEB_DRIVER, APPIUM_CAPABILITY_PLATFORM_NAME));
        }
        String string = (String)platform;
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        AppiumCommandExecutor appiumExecutor = AppiumDriverUtil.getAppiumExecutorForRemoteDriver((URL)new URL(remoteWebServerUrl), (ProxyInformation)proxyInfo, (MutableCapabilities)desiredCapabilities);
        MutableCapabilities finalCaps = AppiumDriverUtil.filterByAcceptedW3CCapabilityKeys((MutableCapabilities)desiredCapabilities);
        if (APPIUM_CAPABILITY_PLATFORM_NAME_ANDROID.equalsIgnoreCase((String)platformName)) {
            return new AndroidDriver((HttpCommandExecutor)appiumExecutor, (Capabilities)finalCaps);
        }
        if (APPIUM_CAPABILITY_PLATFORM_NAME_IOS.equalsIgnoreCase((String)platformName)) {
            IOSDriver driver = new IOSDriver((HttpCommandExecutor)appiumExecutor, (Capabilities)finalCaps);
            driver.setSetting("respectSystemAlerts", (Object)true);
            return driver;
        }
        throw new StepFailedException(MessageFormat.format(StringConstants.DRI_PLATFORM_NAME_X_IS_NOT_SUPPORTED_FOR_APPIUM_REMOTE_WEB_DRIVER, platform));
    }

    private static boolean isEdgeBrowser(Capabilities capabilities) {
        Set names = capabilities.getCapabilityNames();
        if (names.contains("browserName") && capabilities.getCapability("browserName") instanceof String) {
            return ((String)capabilities.getCapability("browserName")).toLowerCase().contains("edge");
        }
        if (names.contains("browser") && capabilities.getCapability("browser") instanceof String) {
            return ((String)capabilities.getCapability("browser")).toLowerCase().contains("edge");
        }
        return false;
    }

    private static Object getPlatformName(Capabilities capabilities) {
        Object platformName = capabilities.getCapability(APPIUM_CAPABILITY_PLATFORM_NAME);
        if (platformName == null) {
            Set entrySet = capabilities.asMap().entrySet();
            for (Map.Entry entry : entrySet) {
                if (!(entry.getValue() instanceof Map) || !((Map)entry.getValue()).containsKey(APPIUM_CAPABILITY_PLATFORM_NAME)) continue;
                return ((Map)entry.getValue()).get(APPIUM_CAPABILITY_PLATFORM_NAME);
            }
        }
        return platformName;
    }
}

