/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.keyword.internal;

import com.katalon.selfhealing.execution.healers.LLMTestObjectHealer;
import com.katalon.selfhealing.execution.healers.SelfHealingPipeline;
import com.katalon.selfhealing.execution.healers.WebStandardTestObjectMapper;
import com.kms.katalon.core.aut.WebAUT;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.keyword.internal.AbstractKeyword;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.keyword.internal.KeywordExecutor;
import com.kms.katalon.core.keyword.internal.SupportLevel;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.common.FindElementsResult;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.common.controller.ElementWaitingPhase;
import com.kms.katalon.core.webui.common.controller.WaitForEnabledPhase;
import com.kms.katalon.core.webui.common.controller.WaitForStablePhase;
import com.kms.katalon.core.webui.common.controller.WaitForTopmostPhase;
import com.kms.katalon.core.webui.common.controller.WaitForVisiblePhase;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.model.FindElementParams;
import com.kms.katalon.core.webui.model.FindElementWithTimeoutParams;
import com.kms.katalon.core.webui.model.SeleniumActionRetryController;
import com.kms.katalon.core.webui.model.WebUiElementFinder;
import com.kms.katalon.core.webui.model.WebUiElementFinderWithSelfHealing;
import com.kms.katalon.core.webui.model.WebUiElementFinderWithTimeout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.ScriptTimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class WebUIAbstractKeyword
extends AbstractKeyword {
    public SupportLevel getSupportLevel(Object ... params) {
        return SupportLevel.NOT_SUPPORT;
    }

    protected List<ElementWaitingPhase> getElementWaitingPhases(JavascriptExecutor jsExecutor) {
        ArrayList<ElementWaitingPhase> result = new ArrayList<ElementWaitingPhase>();
        result.add(new WaitForVisiblePhase(jsExecutor));
        result.add(new WaitForStablePhase(jsExecutor));
        result.add(new WaitForEnabledPhase(jsExecutor));
        result.add(new WaitForTopmostPhase(jsExecutor));
        return result;
    }

    public static WebElement findWebElement(TestObject to) throws Exception {
        return WebUIAbstractKeyword.findWebElement(to, RunConfiguration.getElementTimeoutForWeb());
    }

    public static WebElement findWebElement(TestObject to, int timeOut) throws Exception {
        return WebUiCommonHelper.findWebElement(to, timeOut);
    }

    public static List<WebElement> findWebElements(TestObject to, int timeOut) throws Exception {
        return WebUiCommonHelper.findWebElements(to, timeOut);
    }

    public static List<WebElement> findWebElements(WebDriver webDriver, TestObject testObject, long timeoutInMillis) throws Exception {
        AtomicReference<Object> defaultException = new AtomicReference<Object>(null);
        FindElementWithTimeoutParams params = new FindElementWithTimeoutParams(webDriver, testObject, timeoutInMillis);
        boolean shouldApplySelfHealing = RunConfiguration.shouldApplySelfHealing();
        if (!shouldApplySelfHealing) {
            return new WebUiElementFinderWithTimeout().findElements(params);
        }
        SeleniumActionRetryController ctrl = new SeleniumActionRetryController();
        int retryTimes = shouldApplySelfHealing ? 1 : 0;
        return ctrl.retry(retryContext -> {
            if (retryContext.retryCount == 0) {
                try {
                    return new WebUiElementFinderWithTimeout().findElements(params);
                }
                catch (Exception error) {
                    defaultException.set(error);
                    throw error;
                }
            }
            List<WebElement> foundElements = WebUIAbstractKeyword.findElemnentsWithSelfHealing(params);
            if (foundElements == null || foundElements.isEmpty()) {
                throw (Exception)defaultException.get();
            }
            return foundElements;
        }, retryTimes);
    }

    public static WebElement findWebElement(WebDriver driver, TestObject testObject, long timeoutInMillis) throws Exception {
        AtomicReference<Object> defaultException = new AtomicReference<Object>(null);
        FindElementWithTimeoutParams params = new FindElementWithTimeoutParams(driver, testObject, timeoutInMillis);
        boolean shouldApplySelfHealing = RunConfiguration.shouldApplySelfHealing();
        if (!shouldApplySelfHealing) {
            return new WebUiElementFinderWithTimeout().findElement(params);
        }
        SeleniumActionRetryController ctrl = new SeleniumActionRetryController();
        return ctrl.retry(retryContext -> {
            WebElement firstElement;
            if (retryContext.retryCount == 0) {
                try {
                    return new WebUiElementFinderWithTimeout().findElement(params);
                }
                catch (Exception error) {
                    defaultException.set(error);
                    throw error;
                }
            }
            List<WebElement> foundElements = WebUIAbstractKeyword.findElemnentsWithSelfHealing(params);
            WebElement webElement = firstElement = foundElements != null && !foundElements.isEmpty() ? foundElements.get(0) : null;
            if (firstElement == null) {
                throw (Exception)defaultException.get();
            }
            return firstElement;
        }, 1);
    }

    private static List<WebElement> findElemnentsWithSelfHealing(FindElementWithTimeoutParams findElementParams) throws Exception {
        boolean isSelfHealingEnabled;
        WebDriver driver = findElementParams.getWebDriver();
        TestObject testObject = findElementParams.getTestObject();
        SelfHealingPipeline.SelfHealingParams selfHealingParams = new SelfHealingPipeline.SelfHealingParams();
        boolean isWebPlatform = KeywordExecutionContext.isRunningWebUI();
        String runningKeyword = KeywordExecutionContext.getRunningKeyword();
        List excludedKeywords = RunConfiguration.getExcludedWebUIKeywordsFromSelfHealing();
        boolean bl = isSelfHealingEnabled = isWebPlatform && !excludedKeywords.contains(runningKeyword) && RunConfiguration.shouldApplySelfHealing() != false;
        if (!isSelfHealingEnabled) {
            return null;
        }
        selfHealingParams.useBasicSelfHealing = true;
        selfHealingParams.useAISelfHealing = RunConfiguration.getWebAISelfHealingEnabled();
        selfHealingParams.aiSelfHealingInputSources = RunConfiguration.getWebAISelfHealingInputSources();
        selfHealingParams.currentAction = runningKeyword;
        selfHealingParams.aut = new WebAUT(driver);
        selfHealingParams.testObject = testObject;
        selfHealingParams.standardTestObjectMapper = originalTestObject -> new WebStandardTestObjectMapper().map(originalTestObject);
        selfHealingParams.basicSelfHealer = tempTestObject -> {
            WebElement foundElement = new WebUiElementFinderWithSelfHealing().findElement(findElementParams);
            return foundElement != null ? Arrays.asList(foundElement) : null;
        };
        selfHealingParams.elementsFinder = foundLocator -> {
            TestObject tempTestObject = new TestObject("self-healing-temp-test-object-id");
            SelectorMethod locatorType = SelectorMethod.valueOf((String)foundLocator.type);
            tempTestObject.setSelectorMethod(locatorType);
            tempTestObject.setSelectorValue(locatorType, foundLocator.value);
            FindElementsResult result = new WebUiElementFinder().findElementsBySelectedMethod(driver, tempTestObject);
            return result.getElements();
        };
        SelfHealingPipeline selfHealingPipeline = new SelfHealingPipeline();
        selfHealingPipeline.registerPhase(context -> {
            List foundElements = ((SelfHealingPipeline.SelfHealingContext)context.data).results.foundElements;
            if (foundElements == null || foundElements.isEmpty()) {
                return;
            }
            WebElement firstElement = (WebElement)foundElements.get(0);
            String healedXPath = WebUiElementFinderWithSelfHealing.generateNewXPath(firstElement, driver);
            FindElementsResult healingResult = FindElementsResult.from(firstElement, healedXPath, SelectorMethod.XPATH, null);
            WebUiElementFinderWithSelfHealing.registerBrokenTestObject(healingResult, testObject, driver);
        });
        LLMTestObjectHealer.LLMCustomPrompts customPrompts = new LLMTestObjectHealer.LLMCustomPrompts();
        customPrompts.outputRules = "- Prefer **CSS** when stable; **XPath** only when necessary.\n- Use attributes in this order: `id` \u2192 `data-*` \u2192 `name` \u2192 `aria-*` \u2192 short class chains \u2192 tag+attr.\n";
        customPrompts.locatorTypes = "\"" + StringUtils.join(Arrays.asList(SelectorMethod.CSS, SelectorMethod.XPATH), (String)"\" | \"") + "\"";
        selfHealingParams.customPrompts = customPrompts;
        SelfHealingPipeline.SelfHealingContext context2 = selfHealingPipeline.execute(selfHealingParams);
        return context2.results.foundElements;
    }

    public static WebElement findWebElementWithoutRetry(WebDriver webDriver, TestObject testObject, long timeoutInMillis) throws Exception {
        WebUIAbstractKeyword.getKeywordExecutor().setCurrentKeywordTimeout(timeoutInMillis);
        FindElementParams params = new FindElementParams(webDriver, testObject);
        return new WebUiElementFinder().findElement(params);
    }

    public boolean waitElementInteractable(JavascriptExecutor scriptExecutor, WebElement element, long timeoutInMillis, SeleniumActionRetryController.RetryContext retryContext) {
        if (!RunConfiguration.getEnhancedWaitingEnabled()) {
            return true;
        }
        return this.waitElementInteractableByWaitingPhases(scriptExecutor, element, timeoutInMillis, retryContext);
    }

    boolean waitElementInteractableByWaitingPhases(JavascriptExecutor scriptExecutor, WebElement element, long timeoutInMillis, SeleniumActionRetryController.RetryContext retryContext) {
        List<ElementWaitingPhase> waitingPhases = this.getElementWaitingPhases(scriptExecutor);
        for (ElementWaitingPhase waitingPhase : waitingPhases) {
            try {
                boolean waitingResult = waitingPhase.wait(element, timeoutInMillis - retryContext.getElapsedTime());
                if (waitingResult) continue;
                return false;
            }
            catch (IllegalArgumentException | IllegalStateException | ScriptTimeoutException e) {
                this.logger.logWarning(e.getMessage());
                return false;
            }
        }
        return true;
    }

    protected WebDriver getWebDriver() {
        WebDriver webDriver = DriverFactory.getWebDriver();
        if (webDriver == null) {
            throw new StepFailedException(CoreWebuiMessageConstants.EXC_BROWSER_IS_NOT_OPENED);
        }
        return webDriver;
    }

    private static KeywordExecutor getKeywordExecutor() {
        return KeywordExecutor.getInstance((String)"web");
    }
}

