/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.trace;

import com.kms.katalon.core.trace.TraceDebug;
import com.kms.katalon.core.trace.TraceUtils;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.trace.TraceSession;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v143.network.Network;
import org.openqa.selenium.devtools.v143.network.model.LoadingFailed;
import org.openqa.selenium.devtools.v143.network.model.LoadingFinished;
import org.openqa.selenium.devtools.v143.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v143.network.model.Request;
import org.openqa.selenium.devtools.v143.network.model.RequestId;
import org.openqa.selenium.devtools.v143.network.model.RequestWillBeSent;
import org.openqa.selenium.devtools.v143.network.model.RequestWillBeSentExtraInfo;
import org.openqa.selenium.devtools.v143.network.model.ResourceTiming;
import org.openqa.selenium.devtools.v143.network.model.Response;
import org.openqa.selenium.devtools.v143.network.model.ResponseReceived;
import org.openqa.selenium.devtools.v143.network.model.ResponseReceivedExtraInfo;
import org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch;

public class HarTracer {
    private static volatile State state;

    private HarTracer() {
    }

    private static List<Map<String, Object>> toHeaderList(Map<?, ?> headers) {
        if (headers == null || headers.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map.Entry<?, ?> e : headers.entrySet()) {
            LinkedHashMap<String, String> h = new LinkedHashMap<String, String>();
            h.put("name", String.valueOf(e.getKey()));
            h.put("value", String.valueOf(e.getValue()));
            list.add(h);
        }
        return list;
    }

    private static int headerBytes(List<Map<String, Object>> headers) {
        if (headers == null || headers.isEmpty()) {
            return -1;
        }
        int total = 0;
        for (Map<String, Object> h : headers) {
            String name = h.get("name") != null ? String.valueOf(h.get("name")) : "";
            String value = h.get("value") != null ? String.valueOf(h.get("value")) : "";
            total += name.length() + value.length() + 4;
        }
        return total;
    }

    private static List<Map<String, Object>> parseQueryString(String url) {
        if (url == null) {
            return new ArrayList<Map<String, Object>>();
        }
        try {
            URI uri = new URI(url);
            String query = uri.getRawQuery();
            if (query == null || query.isEmpty()) {
                return new ArrayList<Map<String, Object>>();
            }
            String[] pairs = query.split("&");
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            String[] stringArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] nv = pair.split("=", 2);
                String name = URLDecoder.decode(nv[0], StandardCharsets.UTF_8.name());
                String value = nv.length > 1 ? URLDecoder.decode(nv[1], StandardCharsets.UTF_8.name()) : "";
                LinkedHashMap<String, String> entry = new LinkedHashMap<String, String>();
                entry.put("name", name);
                entry.put("value", value);
                list.add(entry);
                ++n2;
            }
            return list;
        }
        catch (Throwable throwable) {
            return new ArrayList<Map<String, Object>>();
        }
    }

    private static List<Map<String, Object>> parseRequestCookies(Map<?, ?> headers) {
        String header = HarTracer.valueFromHeaderMap(headers, "cookie");
        if (header == null || header.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        String[] tokens = header.split(";");
        ArrayList<Map<String, Object>> cookies = new ArrayList<Map<String, Object>>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String[] nv = token.trim().split("=", 2);
            LinkedHashMap<String, String> c = new LinkedHashMap<String, String>();
            c.put("name", nv[0]);
            c.put("value", nv.length > 1 ? nv[1] : "");
            cookies.add(c);
            ++n2;
        }
        return cookies;
    }

    private static String valueFromHeaderMap(Map<?, ?> headers, String name) {
        if (headers == null) {
            return null;
        }
        for (Map.Entry<?, ?> e : headers.entrySet()) {
            if (!name.equalsIgnoreCase(String.valueOf(e.getKey()))) continue;
            Object v = e.getValue();
            return v != null ? v.toString() : null;
        }
        return null;
    }

    private static List<Map<String, Object>> parseResponseCookies(List<Map<String, Object>> headers) {
        if (headers == null || headers.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> cookies = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> h : headers) {
            String name;
            String string = name = h.get("name") != null ? String.valueOf(h.get("name")) : "";
            if (!"set-cookie".equalsIgnoreCase(name)) continue;
            String header = h.get("value") != null ? String.valueOf(h.get("value")) : "";
            Map<String, Object> cookie = HarTracer.parseSetCookie(header);
            cookies.add(cookie);
        }
        return cookies;
    }

    private static Map<String, Object> parseSetCookie(String header) {
        LinkedHashMap<String, Object> cookie = new LinkedHashMap<String, Object>();
        cookie.put("name", "");
        cookie.put("value", "");
        if (header == null || header.isEmpty()) {
            return cookie;
        }
        String[] parts = header.split(";");
        if (parts.length > 0) {
            String[] first = parts[0].trim().split("=", 2);
            cookie.put("name", first[0]);
            cookie.put("value", first.length > 1 ? first[1] : "");
        }
        int i = 1;
        while (i < parts.length) {
            block28: {
                String attr = parts[i].trim();
                if (attr.isEmpty()) break block28;
                String[] kv = attr.split("=", 2);
                String key = kv[0] != null ? kv[0].toLowerCase() : "";
                String value = kv.length > 1 ? kv[1] : "";
                switch (key) {
                    case "path": {
                        cookie.put("path", value);
                        break;
                    }
                    case "domain": {
                        cookie.put("domain", value);
                        break;
                    }
                    case "expires": {
                        cookie.put("expires", value);
                        break;
                    }
                    case "max-age": {
                        cookie.put("maxAge", value);
                        break;
                    }
                    case "secure": {
                        cookie.put("secure", true);
                        break;
                    }
                    case "httponly": {
                        cookie.put("httpOnly", true);
                        break;
                    }
                    case "samesite": {
                        cookie.put("sameSite", value);
                        break;
                    }
                }
            }
            ++i;
        }
        return cookie;
    }

    private static String isoFrom(TimeSinceEpoch wallTime) {
        if (wallTime == null) {
            return Instant.now().toString();
        }
        double seconds = wallTime.toJson().doubleValue();
        long millis = (long)Math.floor(seconds * 1000.0);
        return Instant.ofEpochMilli(millis).toString();
    }

    private static double secondsFrom(MonotonicTime ts) {
        if (ts == null) {
            return -1.0;
        }
        return ts.toJson().doubleValue();
    }

    private static Map<String, Object> timingsFor(EntryState entry, LoadingFinished event) {
        int receive;
        LinkedHashMap<String, Integer> timings = new LinkedHashMap<String, Integer>();
        timings.put("dns", -1);
        timings.put("connect", -1);
        timings.put("ssl", -1);
        timings.put("send", -1);
        timings.put("wait", -1);
        timings.put("receive", -1);
        ResourceTiming rt = entry.resourceTiming;
        if (rt != null) {
            timings.put("dns", HarTracer.duration(rt.getDnsStart(), rt.getDnsEnd()));
            timings.put("connect", HarTracer.duration(rt.getConnectStart(), rt.getConnectEnd()));
            timings.put("ssl", HarTracer.duration(rt.getSslStart(), rt.getSslEnd()));
            timings.put("send", HarTracer.duration(rt.getSendStart(), rt.getSendEnd()));
            timings.put("wait", HarTracer.duration(rt.getSendEnd(), rt.getReceiveHeadersStart()));
            timings.put("receive", HarTracer.duration(rt.getReceiveHeadersStart(), rt.getReceiveHeadersEnd()));
        }
        long total = HarTracer.totalDuration(entry, event);
        long consumed = 0L;
        String[] stringArray = new String[]{"dns", "connect", "ssl", "send", "wait"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int iv;
            String key = stringArray[n2];
            Object v = timings.get(key);
            if (v instanceof Number && (iv = ((Number)v).intValue()) >= 0) {
                consumed += (long)iv;
            }
            ++n2;
        }
        Object receiveObj = timings.get("receive");
        int n3 = receive = receiveObj instanceof Number ? ((Number)receiveObj).intValue() : -1;
        if (receive < 0) {
            receive = (int)Math.max(0L, total - consumed);
        } else if (total > 0L && consumed + (long)receive < total) {
            receive = (int)Math.max(0L, total - consumed);
        }
        timings.put("receive", receive);
        LinkedHashMap<String, Object> pack = new LinkedHashMap<String, Object>();
        pack.put("detail", timings);
        pack.put("total", total);
        return pack;
    }

    private static int duration(Number start, Number end) {
        if (start == null || end == null) {
            return -1;
        }
        double s = start.doubleValue();
        double e = end.doubleValue();
        if (s < 0.0 || e < 0.0 || e < s) {
            return -1;
        }
        return (int)Math.round(e - s);
    }

    private static long totalDuration(EntryState entry, LoadingFinished event) {
        Double finish;
        if (event == null) {
            return TraceUtils.monotonicMs() - entry.startMonotonic;
        }
        Double d = finish = event.getTimestamp() != null ? Double.valueOf(event.getTimestamp().toJson().doubleValue()) : null;
        if (finish == null) {
            return TraceUtils.monotonicMs() - entry.startMonotonic;
        }
        double start = entry.requestTimestampSeconds >= 0.0 ? entry.requestTimestampSeconds : 0.0;
        return (long)Math.max(0.0, (finish - start) * 1000.0);
    }

    private static String headerValue(List<Map<String, Object>> headers, String name) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        for (Map<String, Object> h : headers) {
            String headerName;
            String string = headerName = h.get("name") != null ? String.valueOf(h.get("name")) : "";
            if (!name.equalsIgnoreCase(headerName)) continue;
            Object v = h.get("value");
            return v != null ? v.toString() : null;
        }
        return null;
    }

    private static Map<String, Object> emptyRequest() {
        LinkedHashMap<String, Object> req = new LinkedHashMap<String, Object>();
        req.put("method", "GET");
        req.put("url", "");
        req.put("httpVersion", "HTTP/1.1");
        req.put("cookies", new ArrayList());
        req.put("headers", new ArrayList());
        req.put("queryString", new ArrayList());
        req.put("headersSize", -1);
        req.put("bodySize", -1);
        return req;
    }

    private static Map<String, Object> emptyResponse() {
        LinkedHashMap<String, Object> resp = new LinkedHashMap<String, Object>();
        resp.put("status", 0);
        resp.put("statusText", "");
        resp.put("httpVersion", "HTTP/1.1");
        resp.put("cookies", new ArrayList());
        resp.put("headers", new ArrayList());
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("mimeType", "application/octet-stream");
        content.put("size", -1);
        resp.put("content", content);
        resp.put("redirectURL", "");
        resp.put("headersSize", -1);
        resp.put("bodySize", -1);
        return resp;
    }

    private static void addListeners(State st) {
        DevTools dt = st.devTools;
        dt.addListener(Network.requestWillBeSent(), event -> {
            try {
                HarTracer.recordRequest(st, event);
            }
            catch (Throwable t) {
                TraceDebug.writeLine((String)("har: requestWillBeSent error " + t.getMessage()));
            }
        });
        dt.addListener(Network.requestWillBeSentExtraInfo(), extra -> {
            try {
                HarTracer.applyRequestExtra(st, extra);
            }
            catch (Throwable t) {
                TraceDebug.writeLine((String)("har: requestExtra error " + t.getMessage()));
            }
        });
        dt.addListener(Network.responseReceived(), event -> {
            try {
                HarTracer.recordResponse(st, event);
            }
            catch (Throwable t) {
                TraceDebug.writeLine((String)("har: responseReceived error " + t.getMessage()));
            }
        });
        dt.addListener(Network.responseReceivedExtraInfo(), extra -> {
            try {
                HarTracer.applyResponseExtra(st, extra);
            }
            catch (Throwable t) {
                TraceDebug.writeLine((String)("har: responseExtra error " + t.getMessage()));
            }
        });
        dt.addListener(Network.loadingFinished(), event -> {
            try {
                HarTracer.handleFinished(st, event);
            }
            catch (Throwable t) {
                TraceDebug.writeLine((String)("har: loadingFinished error " + t.getMessage()));
            }
        });
        dt.addListener(Network.loadingFailed(), event -> {
            try {
                HarTracer.handleFailure(st, event);
            }
            catch (Throwable t) {
                TraceDebug.writeLine((String)("har: loadingFailed error " + t.getMessage()));
            }
        });
    }

    private static void recordRequest(State st, RequestWillBeSent event) {
        String method;
        String currentUrl;
        String id;
        String string = id = event.getRequestId() != null ? event.getRequestId().toString() : null;
        if (id == null || id.isEmpty()) {
            return;
        }
        EntryState entry = st.entries.computeIfAbsent(id, k -> new EntryState());
        Map<String, Object> entryReq = entry.request != null ? entry.request : HarTracer.emptyRequest();
        Request req = event.getRequest();
        String url = req.getUrl();
        String string2 = currentUrl = entryReq.get("url") != null ? String.valueOf(entryReq.get("url")) : "";
        if (currentUrl.isEmpty()) {
            entryReq.put("url", url);
        }
        if ((method = req.getMethod()) != null) {
            entryReq.put("method", method);
        }
        String httpVersion = (String)entryReq.getOrDefault("httpVersion", "HTTP/1.1");
        entryReq.put("httpVersion", httpVersion);
        Map headersMap = req.getHeaders() != null ? req.getHeaders().toJson() : Collections.emptyMap();
        List<Map<String, Object>> headerList = HarTracer.toHeaderList(headersMap);
        entryReq.put("headers", headerList);
        entryReq.put("headersSize", HarTracer.headerBytes(headerList));
        entryReq.put("queryString", HarTracer.parseQueryString((String)entryReq.get("url")));
        entryReq.put("cookies", HarTracer.parseRequestCookies(headersMap));
        String postData = req.getPostData().orElse(null);
        if (postData != null) {
            LinkedHashMap<String, String> post = new LinkedHashMap<String, String>();
            String mime = HarTracer.valueFromHeaderMap(headersMap, "content-type");
            if (mime == null) {
                mime = "application/octet-stream";
            }
            post.put("mimeType", mime);
            post.put("text", postData);
            entryReq.put("postData", post);
            entryReq.put("bodySize", postData.getBytes(StandardCharsets.UTF_8).length);
        } else {
            entryReq.put("bodySize", 0);
        }
        entry.request = entryReq;
        entry.startMonotonic = TraceUtils.monotonicMs();
        entry.requestTimestampSeconds = HarTracer.secondsFrom(event.getTimestamp());
        entry.startedDateIso = HarTracer.isoFrom(event.getWallTime());
        entry.frameId = event.getFrameId().map(idObj -> idObj.toJson()).orElse(null);
        entry.pageRef = entry.frameId != null ? entry.frameId : st.session.getContextId();
        entry.loaderId = event.getLoaderId() != null ? event.getLoaderId().toString() : null;
        entry.resourceType = event.getType().map(Object::toString).orElse(null);
    }

    private static void applyRequestExtra(State st, RequestWillBeSentExtraInfo extra) {
        String id;
        String string = id = extra.getRequestId() != null ? extra.getRequestId().toString() : null;
        if (id == null || id.isEmpty()) {
            return;
        }
        EntryState entry = st.entries.computeIfAbsent(id, k -> new EntryState());
        Map<String, Object> req = entry.request != null ? entry.request : HarTracer.emptyRequest();
        Map headersMap = extra.getHeaders() != null ? extra.getHeaders().toJson() : Collections.emptyMap();
        List<Map<String, Object>> headerList = HarTracer.toHeaderList(headersMap);
        if (!headerList.isEmpty()) {
            req.put("headers", headerList);
            req.put("headersSize", HarTracer.headerBytes(headerList));
            req.put("cookies", HarTracer.parseRequestCookies(headersMap));
        }
        entry.request = req;
    }

    private static void recordResponse(State st, ResponseReceived event) {
        String respUrl;
        Long transfer;
        Map headersMap;
        List<Map<String, Object>> headers;
        String statusText;
        String id;
        String string = id = event.getRequestId() != null ? event.getRequestId().toString() : null;
        if (id == null || id.isEmpty()) {
            return;
        }
        EntryState entry = st.entries.computeIfAbsent(id, k -> new EntryState());
        Response resp = event.getResponse();
        Map<String, Object> responseMap = entry.response != null ? entry.response : HarTracer.emptyResponse();
        LinkedHashMap contentObj = responseMap.get("content");
        if (!(contentObj instanceof Map)) {
            contentObj = new LinkedHashMap();
            ((Map)contentObj).put("mimeType", "application/octet-stream");
            ((Map)contentObj).put("size", -1);
            responseMap.put("content", contentObj);
        }
        Map content = contentObj;
        Integer statusVal = resp.getStatus();
        if (statusVal != null && statusVal > 0) {
            responseMap.put("status", statusVal);
        }
        if ((statusText = resp.getStatusText()) != null && !statusText.isEmpty()) {
            responseMap.put("statusText", statusText);
        }
        if (!(headers = HarTracer.toHeaderList(headersMap = resp.getHeaders() != null ? resp.getHeaders().toJson() : Collections.emptyMap())).isEmpty()) {
            String ct;
            responseMap.put("headers", headers);
            responseMap.put("headersSize", HarTracer.headerBytes(headers));
            responseMap.put("cookies", HarTracer.parseResponseCookies(headers));
            String redirect = HarTracer.headerValue(headers, "location");
            if (redirect != null) {
                responseMap.put("redirectURL", redirect);
            }
            if ((ct = HarTracer.headerValue(headers, "content-type")) != null && !ct.isEmpty()) {
                content.put("mimeType", ct);
            }
        }
        String httpVersion = resp.getProtocol().orElse((String)responseMap.getOrDefault("httpVersion", "HTTP/1.1"));
        responseMap.put("httpVersion", httpVersion);
        Long l = transfer = resp.getEncodedDataLength() != null ? Long.valueOf(resp.getEncodedDataLength().longValue()) : null;
        if (transfer != null && transfer >= 0L) {
            responseMap.put("_transferSize", transfer);
        }
        responseMap.put("serverIPAddress", resp.getRemoteIPAddress().orElse((String)responseMap.get("serverIPAddress")));
        responseMap.put("_remotePort", resp.getRemotePort().orElse((Integer)responseMap.get("_remotePort")));
        boolean servedFromCache = resp.getFromDiskCache().orElse(false) != false || resp.getFromServiceWorker().orElse(false) != false;
        responseMap.put("_servedFromCache", servedFromCache);
        resp.getSecurityDetails().ifPresent(details -> {
            LinkedHashMap<String, String> sec = new LinkedHashMap<String, String>();
            sec.put("protocol", details.getProtocol());
            sec.put("subjectName", details.getSubjectName());
            sec.put("issuer", details.getIssuer());
            sec.put("validFrom", (String)details.getValidFrom());
            sec.put("validTo", (String)details.getValidTo());
            responseMap.put("_securityDetails", sec);
        });
        entry.response = responseMap;
        Map<String, Object> requestMap = entry.request != null ? entry.request : HarTracer.emptyRequest();
        String reqUrl = (String)requestMap.get("url");
        if ((reqUrl == null || reqUrl.isEmpty()) && (respUrl = resp.getUrl()) != null) {
            requestMap.put("url", respUrl);
        }
        requestMap.put("httpVersion", responseMap.get("httpVersion"));
        entry.request = requestMap;
        entry.resourceTiming = resp.getTiming().orElse(null);
        entry.fromDiskCache = resp.getFromDiskCache().orElse(false);
        entry.fromServiceWorker = resp.getFromServiceWorker().orElse(false);
        if (entry.frameId == null) {
            entry.frameId = event.getFrameId().map(idObj -> idObj.toJson()).orElse(null);
        }
        if (entry.pageRef == null) {
            entry.pageRef = entry.frameId != null ? entry.frameId : st.session.getContextId();
        }
    }

    private static void applyResponseExtra(State st, ResponseReceivedExtraInfo extra) {
        Map headersMap;
        List<Map<String, Object>> headers;
        String id;
        String string = id = extra.getRequestId() != null ? extra.getRequestId().toString() : null;
        if (id == null || id.isEmpty()) {
            return;
        }
        EntryState entry = st.entries.computeIfAbsent(id, k -> new EntryState());
        Map<String, Object> responseMap = entry.response != null ? entry.response : HarTracer.emptyResponse();
        String protocol = extra.getHeadersText().orElse((String)responseMap.get("httpVersion"));
        if (protocol != null && !protocol.isEmpty()) {
            responseMap.put("httpVersion", protocol);
        }
        if (!(headers = HarTracer.toHeaderList(headersMap = extra.getHeaders() != null ? extra.getHeaders().toJson() : Collections.emptyMap())).isEmpty()) {
            responseMap.put("headers", headers);
            responseMap.put("headersSize", HarTracer.headerBytes(headers));
            responseMap.put("cookies", HarTracer.parseResponseCookies(headers));
        }
        responseMap.put("headersText", extra.getHeadersText().orElse((String)responseMap.get("headersText")));
        responseMap.put("resourceIPAddressSpace", String.valueOf(extra.getResourceIPAddressSpace()));
        Integer statusCode = extra.getStatusCode();
        if (statusCode != null) {
            responseMap.put("status", statusCode);
        }
        entry.response = responseMap;
    }

    private static void handleFailure(State st, LoadingFailed event) {
        String id;
        String string = id = event.getRequestId() != null ? event.getRequestId().toString() : null;
        if (id == null || id.isEmpty()) {
            return;
        }
        EntryState entry = st.entries.remove(id);
        if (entry == null) {
            return;
        }
        entry.loadingFailed = true;
        entry.failureText = event.getErrorText();
        Map<String, Object> req = entry.request != null ? entry.request : HarTracer.emptyRequest();
        Map<String, Object> resp = entry.response != null ? entry.response : HarTracer.emptyResponse();
        req.put("_failed", true);
        resp.put("_failed", true);
        resp.put("_errorText", entry.failureText);
        Map<String, Object> timingsPack = HarTracer.timingsFor(entry, null);
        LinkedHashMap<String, Object> harEntry = new LinkedHashMap<String, Object>();
        harEntry.put("startedDateTime", entry.startedDateIso);
        harEntry.put("time", TraceUtils.monotonicMs() - entry.startMonotonic);
        harEntry.put("request", req);
        harEntry.put("response", resp);
        harEntry.put("cache", new LinkedHashMap());
        harEntry.put("timings", timingsPack.get("detail"));
        harEntry.put("pageref", entry.pageRef);
        long nowMono = TraceUtils.monotonicMs();
        LinkedHashMap<String, Object> snapshot = new LinkedHashMap<String, Object>();
        snapshot.put("_requestId", id);
        snapshot.put("_loaderId", entry.loaderId);
        snapshot.put("_frameref", entry.frameId != null ? entry.frameId : entry.pageRef);
        snapshot.put("_resourceType", entry.resourceType);
        snapshot.put("_servedFromCache", entry.servedFromCache);
        snapshot.put("_monotonicTime", nowMono);
        snapshot.put("startedDateTime", entry.startedDateIso);
        snapshot.put("time", harEntry.get("time"));
        snapshot.put("pageref", entry.pageRef != null ? entry.pageRef : "page-1");
        snapshot.put("request", req);
        snapshot.put("response", resp);
        snapshot.put("cache", new LinkedHashMap());
        snapshot.put("timings", harEntry.get("timings"));
        snapshot.put("serverIPAddress", resp.get("serverIPAddress"));
        LinkedHashMap<String, Object> snapshotEnvelope = new LinkedHashMap<String, Object>();
        snapshotEnvelope.put("type", "resource-snapshot");
        snapshotEnvelope.put("snapshot", snapshot);
        TraceUtils.appendJsonLine((File)st.session.getNetworkFile(), snapshotEnvelope);
        LinkedHashMap<String, Object> resourceEnvelope = new LinkedHashMap<String, Object>();
        resourceEnvelope.put("type", "resource");
        resourceEnvelope.put("contextId", st.session.getContextId());
        resourceEnvelope.put("pageId", entry.pageRef);
        resourceEnvelope.put("resourceId", id);
        resourceEnvelope.put("ordinal", nowMono);
        resourceEnvelope.put("ended", true);
        resourceEnvelope.put("resource", harEntry);
        TraceUtils.appendJsonLine((File)st.session.getNetworkFile(), resourceEnvelope);
    }

    private static void handleFinished(State st, LoadingFinished event) {
        Object statusObj2;
        int status2;
        Map content;
        LinkedHashMap contentObj;
        String id;
        String string = id = event.getRequestId() != null ? event.getRequestId().toString() : null;
        if (id == null || id.isEmpty()) {
            return;
        }
        EntryState entry = st.entries.remove(id);
        if (entry == null) {
            return;
        }
        entry.encodedDataLength = event.getEncodedDataLength() != null ? event.getEncodedDataLength().longValue() : 0L;
        Map<String, Object> request = entry.request != null ? entry.request : HarTracer.emptyRequest();
        Map<String, Object> response = entry.response != null ? entry.response : HarTracer.emptyResponse();
        Map<String, Object> timingsPack = HarTracer.timingsFor(entry, event);
        if (!response.containsKey("bodySize") || response.get("bodySize") == null) {
            response.put("bodySize", -1);
        }
        if (!((contentObj = response.get("content")) instanceof Map)) {
            contentObj = new LinkedHashMap();
            ((Map)contentObj).put("mimeType", "application/octet-stream");
            ((Map)contentObj).put("size", -1);
            response.put("content", contentObj);
        }
        String mime = (content = (Map)contentObj).get("mimeType") != null ? String.valueOf(content.get("mimeType")) : "application/octet-stream";
        String reqUrl = request.get("url") != null ? String.valueOf(request.get("url")) : "";
        boolean captureBody = HarTracer.shouldCaptureBody(mime) || HarTracer.shouldCaptureUrl(reqUrl);
        byte[] bodyBytes = null;
        Map<String, Object> fallbackMeta = null;
        String shaName = null;
        if (captureBody) {
            Object bytesObj;
            bodyBytes = HarTracer.readResponseBody(st, new RequestId(id), entry);
            if ((bodyBytes == null || bodyBytes.length == 0) && (fallbackMeta = HarTracer.httpFetchBody(entry)) != null && (bytesObj = fallbackMeta.get("bytes")) instanceof byte[]) {
                bodyBytes = (byte[])bytesObj;
            }
            if (bodyBytes != null && bodyBytes.length > 0) {
                String ext = HarTracer.extensionForMime(mime);
                if (ext == null && fallbackMeta != null && fallbackMeta.get("contentType") != null) {
                    ext = HarTracer.extensionForMime(String.valueOf(fallbackMeta.get("contentType")));
                }
                if (ext == null) {
                    ext = HarTracer.extensionFromUrl(reqUrl);
                }
                String sha = TraceUtils.sha1Hex((byte[])bodyBytes);
                shaName = ext != null ? sha + "." + ext : sha;
                File out = new File(st.session.getResourcesDir(), shaName);
                if (st.session.getResourceKeys().add(shaName)) {
                    TraceUtils.writeBytes((File)out, (byte[])bodyBytes);
                }
                content.put("_sha1", shaName);
                content.put("size", bodyBytes.length);
                response.put("bodySize", bodyBytes.length);
                if (fallbackMeta != null && fallbackMeta.get("contentType") != null) {
                    content.put("mimeType", fallbackMeta.get("contentType"));
                }
            }
        }
        if (shaName == null) {
            Object bodySizeObj;
            long bodySize;
            content.remove("_sha1");
            if (((Number)content.getOrDefault("size", -1)).longValue() == -1L) {
                long size = entry.encodedDataLength >= 0L ? entry.encodedDataLength : -1L;
                content.put("size", size);
            }
            long l = bodySize = (bodySizeObj = response.get("bodySize")) instanceof Number ? ((Number)bodySizeObj).longValue() : -1L;
            if (bodySize == -1L) {
                Object sizeObj = content.get("size");
                long s = sizeObj instanceof Number ? ((Number)sizeObj).longValue() : -1L;
                response.put("bodySize", s);
            }
        }
        if (fallbackMeta != null) {
            Object transferObj;
            long transfer;
            Object fbCt;
            Object headersObj;
            List metaHeaders;
            Object statusTextObj;
            String stText;
            int status;
            Object statusObj = response.get("status");
            int n = status = statusObj instanceof Number ? ((Number)statusObj).intValue() : 0;
            if (status == 0) {
                Object fbStatus = fallbackMeta.get("status");
                response.put("status", fbStatus instanceof Number ? ((Number)fbStatus).intValue() : 200);
            }
            String string2 = stText = (statusTextObj = response.get("statusText")) != null ? String.valueOf(statusTextObj) : "";
            if (stText.isEmpty()) {
                Object fbStatusText = fallbackMeta.get("statusText");
                response.put("statusText", fbStatusText != null ? String.valueOf(fbStatusText) : "");
            }
            List list = metaHeaders = (headersObj = fallbackMeta.get("headers")) instanceof List ? (List)headersObj : null;
            if (metaHeaders != null && !metaHeaders.isEmpty()) {
                response.put("headers", metaHeaders);
                response.put("headersSize", HarTracer.headerBytes(metaHeaders));
                response.put("cookies", HarTracer.parseResponseCookies(metaHeaders));
                String redirect = HarTracer.headerValue(metaHeaders, "location");
                if (redirect != null) {
                    response.put("redirectURL", redirect);
                }
            }
            if ((fbCt = fallbackMeta.get("contentType")) != null && content != null) {
                String currentMime;
                String string3 = currentMime = content.get("mimeType") != null ? String.valueOf(content.get("mimeType")) : "";
                if (currentMime.isEmpty() || "application/octet-stream".equals(currentMime)) {
                    content.put("mimeType", fbCt);
                }
            }
            long l = transfer = (transferObj = fallbackMeta.get("transferSize")) instanceof Number ? ((Number)transferObj).longValue() : -1L;
            if (transfer >= 0L) {
                response.put("_transferSize", transfer);
            }
        }
        int n = status2 = (statusObj2 = response.get("status")) instanceof Number ? ((Number)statusObj2).intValue() : 0;
        if (status2 == 0) {
            response.put("status", 200);
            Object stText = response.get("statusText");
            if (stText == null || String.valueOf(stText).isEmpty()) {
                response.put("statusText", "OK");
            }
        }
        long transferFinal = entry.encodedDataLength >= 0L ? entry.encodedDataLength : (response.get("_transferSize") instanceof Number ? ((Number)response.get("_transferSize")).longValue() : -1L);
        response.put("_transferSize", transferFinal);
        boolean servedFromCache = Boolean.TRUE.equals(response.get("_servedFromCache")) || entry.servedFromCache || entry.fromDiskCache || entry.fromServiceWorker;
        response.put("_servedFromCache", servedFromCache);
        Map<String, Object> snapshot = HarTracer.buildSnapshot(id, entry, request, response, timingsPack);
        TraceUtils.appendJsonLine((File)st.session.getNetworkFile(), HarTracer.mapOf("type", "resource-snapshot", "snapshot", snapshot));
        TraceDebug.writeLine((String)("har: wrote resource-snapshot " + String.valueOf(request.get("url")) + " bytes=" + String.valueOf(response.get("bodySize") != null ? response.get("bodySize") : Integer.valueOf(-1)) + " sha=" + String.valueOf(content.get("_sha1") != null ? content.get("_sha1") : "none")));
        LinkedHashMap<String, Object> harEntry = new LinkedHashMap<String, Object>();
        harEntry.put("startedDateTime", entry.startedDateIso);
        harEntry.put("time", timingsPack.get("total"));
        harEntry.put("request", request);
        harEntry.put("response", response);
        harEntry.put("cache", new LinkedHashMap());
        harEntry.put("timings", timingsPack.get("detail"));
        harEntry.put("pageref", entry.pageRef);
        harEntry.put("_resourceType", entry.resourceType);
        harEntry.put("_fromDiskCache", entry.fromDiskCache);
        harEntry.put("_fromServiceWorker", entry.fromServiceWorker);
        harEntry.put("_encodedDataLength", entry.encodedDataLength);
        harEntry.put("_loaderId", entry.loaderId);
        harEntry.put("_frameId", entry.frameId);
        harEntry.put("_requestTimestamp", entry.requestTimestampSeconds);
        harEntry.put("_servedFromCache", entry.servedFromCache);
        LinkedHashMap<String, Object> resourceEnvelope = new LinkedHashMap<String, Object>();
        resourceEnvelope.put("type", "resource");
        resourceEnvelope.put("contextId", st.session.getContextId());
        resourceEnvelope.put("pageId", entry.pageRef);
        resourceEnvelope.put("resourceId", id);
        resourceEnvelope.put("ordinal", TraceUtils.monotonicMs());
        resourceEnvelope.put("ended", true);
        resourceEnvelope.put("resource", harEntry);
        TraceUtils.appendJsonLine((File)st.session.getNetworkFile(), resourceEnvelope);
    }

    private static Map<String, Object> buildSnapshot(String requestId, EntryState entry, Map<String, Object> request, Map<String, Object> response, Map<String, Object> timingsPack) {
        long nowMono = TraceUtils.monotonicMs();
        LinkedHashMap<String, Object> snapshot = new LinkedHashMap<String, Object>();
        snapshot.put("_requestId", requestId);
        snapshot.put("_loaderId", entry.loaderId);
        snapshot.put("_frameref", entry.frameId != null ? entry.frameId : entry.pageRef);
        snapshot.put("_resourceType", entry.resourceType);
        snapshot.put("_servedFromCache", entry.servedFromCache);
        snapshot.put("_monotonicTime", nowMono);
        snapshot.put("startedDateTime", entry.startedDateIso);
        snapshot.put("time", timingsPack.get("total"));
        snapshot.put("pageref", entry.pageRef != null ? entry.pageRef : "page-1");
        snapshot.put("request", request);
        snapshot.put("response", response);
        snapshot.put("cache", new LinkedHashMap());
        snapshot.put("timings", timingsPack.get("detail"));
        Object serverIp = response.get("serverIPAddress");
        if (serverIp == null && entry.response != null) {
            serverIp = entry.response.get("serverIPAddress");
        }
        snapshot.put("serverIPAddress", serverIp);
        return snapshot;
    }

    private static byte[] readResponseBody(State st, RequestId requestId, EntryState entry) {
        try {
            byte[] bytes;
            Network.GetResponseBodyResponse bodyObj = (Network.GetResponseBodyResponse)st.devTools.send(Network.getResponseBody((RequestId)requestId));
            String bodyText = bodyObj.getBody();
            boolean b64 = bodyObj.getBase64Encoded();
            byte[] byArray = bytes = b64 ? Base64.getDecoder().decode(bodyText) : bodyText.getBytes(StandardCharsets.UTF_8);
            if (bytes != null && bytes.length > 0) {
                String url = entry.request != null ? entry.request.get("url") : "";
                TraceDebug.writeLine((String)("har: CDP body bytes=" + bytes.length + " url=" + String.valueOf(url != null ? url : "")));
            }
            return bytes;
        }
        catch (Throwable t) {
            TraceDebug.writeLine((String)("har: getResponseBody error " + t.getMessage()));
            return null;
        }
    }

    /*
     * Loose catch block
     */
    private static Map<String, Object> httpFetchBody(EntryState entry) {
        LinkedHashMap<String, Object> linkedHashMap;
        InputStream stream;
        HttpURLConnection conn;
        block32: {
            int code;
            Object postDataObj;
            String url;
            block30: {
                block31: {
                    conn = null;
                    stream = null;
                    String string = entry.request != null && entry.request.get("url") != null ? String.valueOf(entry.request.get("url")) : (url = entry.response != null ? String.valueOf(entry.response.get("url")) : null);
                    if (url != null && !url.isEmpty()) break block30;
                    if (stream == null) break block31;
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (conn != null) {
                    conn.disconnect();
                }
                return null;
            }
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("Accept-Encoding", "identity");
            String method = entry.request != null && entry.request.get("method") != null ? String.valueOf(entry.request.get("method")).toUpperCase() : "GET";
            conn.setRequestMethod(method);
            ArrayList<Map<String, Object>> headers = entry.request != null ? (List)entry.request.getOrDefault("headers", new ArrayList()) : new ArrayList<Map<String, Object>>();
            HarTracer.applyPassthroughHeader(conn, headers, "user-agent", "User-Agent");
            HarTracer.applyPassthroughHeader(conn, headers, "accept", "Accept");
            HarTracer.applyPassthroughHeader(conn, headers, "accept-language", "Accept-Language");
            HarTracer.applyPassthroughHeader(conn, headers, "referer", "Referer");
            HarTracer.applyPassthroughHeader(conn, headers, "origin", "Origin");
            String cookieHeader = HarTracer.cookiesHeader(entry.request != null ? (List)entry.request.get("cookies") : null);
            if (cookieHeader != null && !cookieHeader.isEmpty()) {
                conn.setRequestProperty("Cookie", cookieHeader);
            }
            Object object = postDataObj = entry.request != null ? entry.request.get("postData") : null;
            if (("POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method)) && postDataObj instanceof Map && ((Map)postDataObj).get("text") != null) {
                Map postData = (Map)postDataObj;
                byte[] payload = String.valueOf(postData.get("text")).getBytes(StandardCharsets.UTF_8);
                conn.setDoOutput(true);
                Object mime = postData.get("mimeType");
                if (mime != null) {
                    conn.setRequestProperty("Content-Type", String.valueOf(mime));
                }
                OutputStream os = conn.getOutputStream();
                try {
                    os.write(payload);
                }
                catch (Throwable throwable) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    os.close();
                }
                catch (Throwable throwable) {}
            }
            stream = (code = conn.getResponseCode()) >= 400 ? conn.getErrorStream() : conn.getInputStream();
            byte[] bytes = stream != null ? stream.readAllBytes() : null;
            LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
            meta.put("status", code);
            meta.put("statusText", conn.getResponseMessage());
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            ArrayList respHeaders = new ArrayList();
            if (headerFields != null) {
                for (Map.Entry<String, List<String>> e : headerFields.entrySet()) {
                    if (e.getKey() == null) continue;
                    LinkedHashMap<String, String> h = new LinkedHashMap<String, String>();
                    h.put("name", e.getKey());
                    List<String> vals = e.getValue();
                    String joined = vals != null ? String.join((CharSequence)", ", vals) : "";
                    h.put("value", joined);
                    respHeaders.add(h);
                }
            }
            meta.put("headers", respHeaders);
            long len = conn.getContentLengthLong();
            meta.put("transferSize", len >= 0L ? len : -1L);
            meta.put("contentType", conn.getContentType());
            if (bytes != null) {
                meta.put("bytes", bytes);
            }
            linkedHashMap = meta;
            if (stream == null) break block32;
            try {
                stream.close();
            }
            catch (Throwable throwable) {}
        }
        if (conn != null) {
            conn.disconnect();
        }
        return linkedHashMap;
        catch (Throwable t) {
            block33: {
                try {
                    TraceDebug.writeLine((String)("har: httpFetchBody error " + t.getMessage()));
                    if (stream == null) break block33;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
            return null;
        }
    }

    private static void applyPassthroughHeader(HttpURLConnection conn, List<Map<String, Object>> headers, String inName, String outName) {
        if (headers == null) {
            return;
        }
        for (Map<String, Object> h : headers) {
            String name;
            String string = name = h.get("name") != null ? String.valueOf(h.get("name")) : "";
            if (!inName.equalsIgnoreCase(name)) continue;
            Object v = h.get("value");
            if (v == null) break;
            conn.setRequestProperty(outName, String.valueOf(v));
            break;
        }
    }

    private static String cookiesHeader(List<Map<String, Object>> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map<String, Object> c : cookies) {
            String value;
            String name = c.get("name") != null ? String.valueOf(c.get("name")) : "";
            String string = value = c.get("value") != null ? String.valueOf(c.get("value")) : "";
            if (!first) {
                sb.append("; ");
            }
            sb.append(name).append("=").append(value);
            first = false;
        }
        return sb.toString();
    }

    private static boolean shouldCaptureBody(String mime) {
        if (mime == null || mime.isEmpty()) {
            return false;
        }
        String lower = mime.toLowerCase();
        return lower.contains("text") || lower.contains("javascript") || lower.contains("json") || lower.contains("xml") || lower.contains("svg") || lower.contains("font");
    }

    private static boolean shouldCaptureUrl(String url) {
        String[] exts;
        if (url == null || url.isEmpty()) {
            return false;
        }
        String lower = url.toLowerCase();
        if (lower.contains("fonts.googleapis.com")) {
            return true;
        }
        int q = lower.indexOf("?");
        String base = q >= 0 ? lower.substring(0, q) : lower;
        String[] stringArray = exts = new String[]{".css", ".js", ".mjs", ".json", ".html", ".htm", ".xml", ".svg", ".woff", ".woff2", ".ttf", ".otf", ".eot", ".png", ".jpg", ".jpeg", ".gif", ".ico"};
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (base.endsWith(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String extensionFromUrl(String url) {
        String ext;
        if (url == null || url.isEmpty()) {
            return null;
        }
        int q = url.indexOf("?");
        String base = q >= 0 ? url.substring(0, q) : url;
        int dot = base.lastIndexOf(46);
        if (dot < 0 || dot == base.length() - 1) {
            return null;
        }
        switch (ext = base.substring(dot + 1).toLowerCase()) {
            case "js": 
            case "css": 
            case "eot": 
            case "gif": 
            case "htm": 
            case "ico": 
            case "jpg": 
            case "mjs": 
            case "otf": 
            case "png": 
            case "svg": 
            case "ttf": 
            case "xml": 
            case "html": 
            case "jpeg": 
            case "json": 
            case "woff": 
            case "woff2": {
                return ext;
            }
        }
        return null;
    }

    private static String extensionForMime(String mime) {
        if (mime == null || mime.isEmpty()) {
            return null;
        }
        String lower = mime.toLowerCase();
        if (lower.contains("text/css")) {
            return "css";
        }
        if (lower.contains("javascript")) {
            return "js";
        }
        if (lower.contains("json")) {
            return "json";
        }
        if (lower.contains("html")) {
            return "html";
        }
        if (lower.contains("xml")) {
            return "xml";
        }
        if (lower.contains("svg")) {
            return "svg";
        }
        if (lower.contains("woff2")) {
            return "woff2";
        }
        if (lower.contains("woff")) {
            return "woff";
        }
        if (lower.contains("ttf")) {
            return "ttf";
        }
        if (lower.contains("otf")) {
            return "otf";
        }
        if (lower.contains("png")) {
            return "png";
        }
        if (lower.contains("jpeg") || lower.contains("jpg")) {
            return "jpeg";
        }
        if (lower.contains("gif")) {
            return "gif";
        }
        if (lower.contains("ico")) {
            return "ico";
        }
        return null;
    }

    private static Map<String, Object> mapOf(Object k1, Object v1, Object k2, Object v2) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put(String.valueOf(k1), v1);
        m.put(String.valueOf(k2), v2);
        return m;
    }

    private static Map<String, Object> mapOf(Object k1, Object v1, Object k2, Object v2, Object k3, Object v3, Object k4, Object v4, Object k5, Object v5, Object k6, Object v6, Object k7, Object v7, Object k8, Object v8, Object k9, Object v9, Object k10, Object v10) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put(String.valueOf(k1), v1);
        m.put(String.valueOf(k2), v2);
        m.put(String.valueOf(k3), v3);
        m.put(String.valueOf(k4), v4);
        m.put(String.valueOf(k5), v5);
        m.put(String.valueOf(k6), v6);
        m.put(String.valueOf(k7), v7);
        m.put(String.valueOf(k8), v8);
        m.put(String.valueOf(k9), v9);
        m.put(String.valueOf(k10), v10);
        return m;
    }

    public static boolean attachIfNeeded(TraceSession session) {
        DevTools dt;
        block7: {
            WebDriver driver;
            block6: {
                block5: {
                    try {
                        State current = state;
                        if (current == null || !current.enabled) break block5;
                        current.session = session;
                        current.entries = new ConcurrentHashMap<String, EntryState>();
                        return true;
                    }
                    catch (Throwable t) {
                        TraceDebug.writeLine((String)("har: attach failed " + t.getMessage()));
                        return false;
                    }
                }
                driver = DriverFactory.getWebDriver();
                if (driver instanceof HasDevTools) break block6;
                TraceDebug.writeLine((String)"har: driver lacks DevTools");
                return false;
            }
            dt = ((HasDevTools)driver).getDevTools();
            if (dt != null) break block7;
            TraceDebug.writeLine((String)"har: getDevTools null");
            return false;
        }
        dt.createSession();
        dt.send(Network.enable(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(false)));
        dt.send(Network.setCacheDisabled((Boolean)true));
        State st = new State();
        st.devTools = dt;
        st.session = session;
        st.enabled = true;
        state = st;
        HarTracer.addListeners(st);
        TraceDebug.writeLine((String)"har: attached to DevTools Network domain");
        return true;
    }

    public static void ensureCacheDisabled() {
        try {
            State st = state;
            if (st != null && st.enabled) {
                st.devTools.send(Network.setCacheDisabled((Boolean)true));
            }
        }
        catch (Throwable t) {
            TraceDebug.writeLine((String)("har: ensureCacheDisabled error " + t.getMessage()));
        }
    }

    public static void awaitIdle(long timeoutMs) {
        State st = state;
        if (st == null) {
            return;
        }
        long deadline = System.currentTimeMillis() + timeoutMs;
        while (!st.entries.isEmpty() && System.currentTimeMillis() < deadline) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (!st.entries.isEmpty()) {
            TraceDebug.writeLine((String)("har: awaitIdle timed out with " + st.entries.size() + " inflight requests"));
        }
    }

    public static void stopAndFlush(long timeoutMs) {
        HarTracer.awaitIdle(timeoutMs);
        State st = state;
        if (st != null && st.enabled) {
            TraceDebug.writeLine((String)("har: stop (remaining=" + st.entries.size() + ")"));
        }
        state = null;
    }

    private static final class EntryState {
        Map<String, Object> request = HarTracer.emptyRequest();
        Map<String, Object> response = HarTracer.emptyResponse();
        long startMonotonic = TraceUtils.monotonicMs();
        double requestTimestampSeconds = -1.0;
        String startedDateIso = Instant.now().toString();
        String frameId;
        String pageRef;
        String loaderId;
        String resourceType;
        ResourceTiming resourceTiming;
        boolean servedFromCache;
        boolean fromDiskCache;
        boolean fromServiceWorker;
        boolean loadingFailed;
        String failureText;
        long encodedDataLength;

        private EntryState() {
        }
    }

    private static final class State {
        DevTools devTools;
        TraceSession session;
        Map<String, EntryState> entries = new ConcurrentHashMap<String, EntryState>();
        boolean enabled;

        private State() {
        }
    }
}

