/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.trace;

import com.kms.katalon.core.trace.TraceDebug;
import com.kms.katalon.core.webui.driver.DriverFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public final class SnapshotAgent {
    private SnapshotAgent() {
    }

    public static String installAndGetName() {
        WebDriver driver = DriverFactory.getWebDriver();
        if (!(driver instanceof JavascriptExecutor)) {
            return null;
        }
        String name = "__kte_snapshot_streamer_" + UUID.randomUUID().toString().replace("-", "");
        String jsFn = SnapshotAgent.loadPlaywrightSnapshotterFunction();
        try {
            TraceDebug.writeLine((String)("SnapshotAgent: injecting snapshotter name=" + name + " jsBytes=" + (jsFn != null ? jsFn.length() : -1)));
        }
        catch (Throwable throwable) {}
        ((JavascriptExecutor)driver).executeScript(jsFn, new Object[0]);
        Object result = ((JavascriptExecutor)driver).executeScript("return (window.__kte_initSnapshotter && window.__kte_initSnapshotter(arguments[0], true)) || 'ERR_NO_INIT'", new Object[]{name});
        try {
            TraceDebug.writeLine((String)("SnapshotAgent.install result=" + String.valueOf(result)));
        }
        catch (Throwable throwable) {}
        if ("ERR_NO_FN".equals(result)) {
            return null;
        }
        return result != null ? String.valueOf(result) : null;
    }

    public static Object captureSnapshot(String name) {
        WebDriver driver = DriverFactory.getWebDriver();
        if (!(driver instanceof JavascriptExecutor)) {
            return null;
        }
        String script = "var s=window['" + name + "']; if(!s||!s.captureSnapshot) return null; var r=s.captureSnapshot(); try{ return JSON.parse(JSON.stringify(r)); }catch(e){ return r; }";
        try {
            Object res = ((JavascriptExecutor)driver).executeScript(script, new Object[0]);
            try {
                TraceDebug.writeLine((String)("SnapshotAgent.capture: class=" + (res == null ? "null" : res.getClass().getName())));
            }
            catch (Throwable throwable) {}
            return res;
        }
        catch (Throwable t) {
            try {
                TraceDebug.writeLine((String)("SnapshotAgent.capture error: " + t.getMessage()));
            }
            catch (Throwable throwable) {}
            try {
                return ((JavascriptExecutor)driver).executeScript(script, new Object[0]);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadPlaywrightSnapshotterFunction() {
        String string;
        InputStream stream = null;
        try {
            stream = SnapshotAgent.class.getResourceAsStream("/com/kms/katalon/core/trace/resources/snapshotterBundle.js");
            if (stream == null) {
                throw new RuntimeException("snapshotterBundle.js missing from resources");
            }
            string = SnapshotAgent.readAll(stream);
            if (stream == null) return string;
        }
        catch (Throwable t) {
            try {
                try {
                    TraceDebug.writeLine((String)("SnapshotAgent: failed to load snapshotter bundle: " + t.getMessage()));
                    throw new RuntimeException("Unable to load snapshotter bundle.", t);
                }
                catch (Throwable throwable) {}
                throw new RuntimeException("Unable to load snapshotter bundle.", t);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    private static String readAll(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            int n;
            char[] buf = new char[4096];
            while ((n = reader.read(buf)) != -1) {
                sb.append(buf, 0, n);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sb.toString();
    }
}

