/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.trace;

import com.kms.katalon.core.trace.TraceDebug;
import com.kms.katalon.core.trace.TraceUtils;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.trace.HarTracer;
import com.kms.katalon.core.webui.trace.SnapshotAgent;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class TraceSession {
    public static final int VERSION = 8;
    private final File tracesDir;
    private final File resourcesDir;
    private final File traceFile;
    private final File networkFile;
    private final String contextId = UUID.randomUUID().toString();
    private final Set<String> resourceKeys = ConcurrentHashMap.newKeySet();
    private volatile boolean recording = false;
    private String snapshotStreamerName;

    public TraceSession(File tracesDir) {
        this.tracesDir = tracesDir;
        this.resourcesDir = new File(tracesDir, "resources");
        this.traceFile = new File(tracesDir, "trace.trace");
        this.networkFile = new File(tracesDir, "trace.network");
        TraceUtils.ensureDir((File)this.resourcesDir);
        this.traceFile.delete();
        this.networkFile.delete();
        File parent = this.networkFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            this.networkFile.createNewFile();
        }
        catch (Throwable throwable) {}
    }

    public void start(String title) {
        WebDriver driver = null;
        try {
            driver = DriverFactory.getWebDriver();
        }
        catch (Throwable throwable) {}
        String browserName = TraceSession.safeBrowserName(driver);
        LinkedHashMap<String, Serializable> options = new LinkedHashMap<String, Serializable>();
        LinkedHashMap<String, Integer> viewport = new LinkedHashMap<String, Integer>();
        viewport.put("width", 1280);
        viewport.put("height", 800);
        options.put("viewport", viewport);
        options.put("deviceScaleFactor", Integer.valueOf(1));
        options.put("isMobile", Boolean.valueOf(false));
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        ctx.put("version", 8);
        ctx.put("type", "context-options");
        ctx.put("origin", "testRunner");
        ctx.put("browserName", browserName);
        ctx.put("platform", System.getProperty("os.name"));
        ctx.put("wallTime", Instant.now().toEpochMilli());
        ctx.put("monotonicTime", TraceUtils.monotonicMs());
        ctx.put("sdkLanguage", "java");
        ctx.put("title", title);
        ctx.put("contextId", this.contextId);
        ctx.put("options", options);
        TraceUtils.appendJsonLine((File)this.traceFile, ctx);
        TraceDebug.writeLine((String)("TraceSession.start: context-options written, driverPresent=" + (driver != null)));
        try {
            if (driver != null) {
                this.snapshotStreamerName = SnapshotAgent.installAndGetName();
                TraceDebug.writeLine((String)("TraceSession.start: snapshot streamer= " + this.snapshotStreamerName));
            }
        }
        catch (Throwable t) {
            TraceDebug.writeLine((String)("TraceSession.start: snapshot inject error: " + t.getMessage()));
        }
        this.recording = true;
    }

    public String beginStep(String title, Map<String, Object> params) {
        return this.beginStep(title, params, new LinkedHashMap<String, Object>(), null);
    }

    public String beginStep(String title, Map<String, Object> params, Map<String, Object> meta, Map<String, Object> extras) {
        Map<String, Object> locBefore;
        String callId = UUID.randomUUID().toString();
        LinkedHashMap<String, Object> effectiveParams = params != null ? new LinkedHashMap<String, Object>(params) : new LinkedHashMap();
        LinkedHashMap<String, Object> ev = new LinkedHashMap<String, Object>();
        ev.put("type", "before");
        ev.put("callId", callId);
        ev.put("startTime", TraceUtils.monotonicMs());
        ev.put("wallTime", System.currentTimeMillis());
        ev.put("title", title);
        ev.put("class", "Test");
        ev.put("method", "step");
        ev.put("params", effectiveParams);
        ev.put("stepId", callId);
        ev.put("pageId", TraceSession.currentPageId());
        if (meta != null) {
            Object category;
            Object apiName = meta.get("apiName");
            if (apiName != null) {
                ev.put("apiName", apiName);
            }
            if ((category = meta.get("category")) != null) {
                ev.put("category", category);
            }
        }
        if ((locBefore = TraceSession.sanitizeLocation(meta != null ? meta.get("location") : null)) != null) {
            ev.put("location", locBefore);
        }
        ArrayList<Map> stackFrames = new ArrayList<Map>();
        String argsSourceText = extras != null ? (String)extras.get("argsSourceText") : null;
        Map<String, Object> argsSource = this.maybeCreateArgsSource(callId, title, argsSourceText);
        if (argsSource != null) {
            Object file = argsSource.get("file");
            Object sha = argsSource.get("sha");
            Object frame = argsSource.get("frame");
            if (file != null && !effectiveParams.containsKey("argsSourceFile")) {
                effectiveParams.put("argsSourceFile", file);
            }
            if (sha != null && !effectiveParams.containsKey("argsSourceSha")) {
                effectiveParams.put("argsSourceSha", sha);
            }
            if (frame instanceof Map) {
                stackFrames.add((Map)frame);
            }
        }
        if (!stackFrames.isEmpty()) {
            ev.put("stack", stackFrames);
        }
        String beforeSnapshot = "before@" + callId;
        ev.put("beforeSnapshot", beforeSnapshot);
        TraceUtils.appendJsonLine((File)this.traceFile, ev);
        try {
            this.captureFrameSnapshot(callId, beforeSnapshot);
            TraceDebug.writeLine((String)("beginStep: captured before snapshot for " + callId));
        }
        catch (Throwable t) {
            TraceDebug.writeLine((String)("beginStep snapshot err " + t.getMessage()));
        }
        return callId;
    }

    public void endStep(String callId, Object result, Map<String, Object> meta) {
        this.endStep(callId, result, null, meta);
    }

    public void endStep(String callId, Object result, Throwable err, Map<String, Object> meta) {
        Map<String, Object> locAfter;
        LinkedHashMap<String, Object> after = new LinkedHashMap<String, Object>();
        after.put("type", "after");
        after.put("callId", callId);
        after.put("endTime", TraceUtils.monotonicMs());
        after.put("wallTime", System.currentTimeMillis());
        after.put("result", result);
        if (meta != null) {
            Object category;
            Object apiName = meta.get("apiName");
            if (apiName != null) {
                after.put("apiName", apiName);
            }
            if ((category = meta.get("category")) != null) {
                after.put("category", category);
            }
        }
        if ((locAfter = TraceSession.sanitizeLocation(meta != null ? meta.get("location") : null)) != null) {
            after.put("location", locAfter);
        }
        if (err != null) {
            LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
            error.put("name", err.getClass().getSimpleName());
            error.put("message", err.getMessage());
            after.put("error", error);
        }
        String afterSnapshot = "after@" + callId;
        after.put("afterSnapshot", afterSnapshot);
        TraceUtils.appendJsonLine((File)this.traceFile, after);
        try {
            this.captureFrameSnapshot(callId, afterSnapshot);
        }
        catch (Throwable t) {
            TraceDebug.writeLine((String)("endStep snapshot err " + t.getMessage()));
        }
        try {
            this.captureScreencastFrame();
        }
        catch (Throwable throwable) {}
    }

    public void captureScreencastFrame() {
        byte[] jpeg;
        WebDriver driver;
        try {
            driver = DriverFactory.getWebDriver();
        }
        catch (Throwable throwable) {
            return;
        }
        if (!(driver instanceof TakesScreenshot)) {
            return;
        }
        byte[] png = (byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES);
        try {
            jpeg = TraceUtils.pngToJpeg((byte[])png);
        }
        catch (Throwable throwable) {
            jpeg = png;
        }
        long ts = TraceUtils.monotonicMs();
        String pageId = TraceSession.currentPageId();
        String key = pageId + "-" + ts + ".jpeg";
        if (!this.resourceKeys.add(key)) {
            return;
        }
        File out = new File(this.resourcesDir, key);
        TraceUtils.writeBytes((File)out, (byte[])jpeg);
        TraceDebug.writeLine((String)("screencast: wrote " + out.getName() + " size=" + jpeg.length));
        LinkedHashMap<String, Object> ev = new LinkedHashMap<String, Object>();
        ev.put("type", "screencast-frame");
        ev.put("pageId", pageId);
        ev.put("sha1", key);
        ev.put("width", 1280);
        ev.put("height", 800);
        ev.put("timestamp", ts);
        TraceUtils.appendJsonLine((File)this.traceFile, ev);
    }

    public void captureFrameSnapshot(String callId, String snapshotName) {
        Object data;
        if (this.snapshotStreamerName == null) {
            try {
                this.snapshotStreamerName = SnapshotAgent.installAndGetName();
                TraceDebug.writeLine((String)("captureFrameSnapshot: installed streamer=" + this.snapshotStreamerName));
            }
            catch (Throwable t) {
                TraceDebug.writeLine((String)("captureFrameSnapshot: install error " + t.getMessage()));
            }
            if (this.snapshotStreamerName == null) {
                return;
            }
        }
        if (!((data = SnapshotAgent.captureSnapshot(this.snapshotStreamerName)) instanceof Map)) {
            try {
                this.snapshotStreamerName = SnapshotAgent.installAndGetName();
            }
            catch (Throwable throwable) {}
            if (this.snapshotStreamerName == null) {
                return;
            }
            data = SnapshotAgent.captureSnapshot(this.snapshotStreamerName);
        }
        if (!(data instanceof Map)) {
            return;
        }
        Map snap = (Map)data;
        ArrayList overrides = new ArrayList();
        Object roObj = snap.get("resourceOverrides");
        List ro = roObj instanceof List ? (List)roObj : new ArrayList();
        for (Object item : ro) {
            if (!(item instanceof Map)) continue;
            Map m = (Map)item;
            String url = (String)m.get("url");
            Object content = m.get("content");
            String contentType = (String)m.get("contentType");
            if (content instanceof CharSequence) {
                byte[] bytes = content.toString().getBytes(StandardCharsets.UTF_8);
                String sha = TraceUtils.sha1Hex((byte[])bytes);
                String ext = TraceSession.extFromContentType(contentType);
                String name = sha + "." + ext;
                File out = new File(this.resourcesDir, name);
                if (this.resourceKeys.add(name) || !out.exists()) {
                    TraceUtils.writeBytes((File)out, (byte[])bytes);
                    TraceDebug.writeLine((String)("snapshot override: wrote " + name + " bytes=" + bytes.length));
                }
                LinkedHashMap<String, Object> override = new LinkedHashMap<String, Object>();
                override.put("url", url);
                override.put("sha1", name);
                if (contentType != null) {
                    override.put("contentType", contentType);
                }
                overrides.add(override);
                continue;
            }
            if (!(content instanceof Number)) continue;
            LinkedHashMap<String, Object> override = new LinkedHashMap<String, Object>();
            override.put("url", url);
            override.put("ref", ((Number)content).intValue());
            overrides.add(override);
        }
        LinkedHashMap<String, Object> snapshot = new LinkedHashMap<String, Object>();
        snapshot.put("snapshotName", snapshotName);
        snapshot.put("callId", callId);
        snapshot.put("pageId", TraceSession.currentPageId());
        snapshot.put("frameId", "main");
        Object url = snap.get("url");
        snapshot.put("frameUrl", url != null ? url : "");
        snapshot.put("timestamp", TraceUtils.monotonicMs());
        Object wallTime = snap.get("wallTime");
        snapshot.put("wallTime", wallTime != null ? wallTime : Long.valueOf(System.currentTimeMillis()));
        Object collectionTime = snap.get("collectionTime");
        snapshot.put("collectionTime", collectionTime != null ? collectionTime : Integer.valueOf(0));
        snapshot.put("doctype", snap.get("doctype"));
        snapshot.put("html", snap.get("html"));
        snapshot.put("resourceOverrides", overrides);
        Object viewport = snap.get("viewport");
        if (viewport == null) {
            LinkedHashMap<String, Integer> vp = new LinkedHashMap<String, Integer>();
            vp.put("width", 1280);
            vp.put("height", 800);
            viewport = vp;
        }
        snapshot.put("viewport", viewport);
        snapshot.put("isMainFrame", true);
        LinkedHashMap<String, Object> frameSnapshot = new LinkedHashMap<String, Object>();
        frameSnapshot.put("type", "frame-snapshot");
        frameSnapshot.put("snapshot", snapshot);
        TraceUtils.appendJsonLine((File)this.traceFile, frameSnapshot);
    }

    public void stopChunk(File zipFile) {
        try {
            HarTracer.awaitIdle(500L);
        }
        catch (Throwable throwable) {}
        ArrayList entries = new ArrayList();
        LinkedHashMap<String, Object> e1 = new LinkedHashMap<String, Object>();
        e1.put("name", "trace.trace");
        e1.put("file", this.traceFile);
        entries.add(e1);
        LinkedHashMap<String, Object> e2 = new LinkedHashMap<String, Object>();
        e2.put("name", "trace.network");
        e2.put("file", this.networkFile);
        entries.add(e2);
        File[] files = this.resourcesDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                LinkedHashMap<String, Object> ent = new LinkedHashMap<String, Object>();
                ent.put("name", "resources/" + f.getName());
                ent.put("file", f);
                entries.add(ent);
                ++n2;
            }
        }
        TraceDebug.writeLine((String)("stopChunk: entries=" + entries.stream().map(m -> String.valueOf(m.get("name"))).reduce((a, b) -> a + ", " + b).orElse("")));
        TraceUtils.zipEntries((File)zipFile, entries);
        this.recording = false;
    }

    private Map<String, Object> maybeCreateArgsSource(String callId, String title, String content) {
        if (content == null || content.trim().isEmpty()) {
            return null;
        }
        try {
            String safeSegment = TraceSession.sanitizeArgsSegment(title != null ? title : "keyword");
            String pseudoFile = "/trace-args/" + safeSegment + "/" + callId + ".txt";
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            String shaForPath = TraceUtils.sha1Hex((byte[])pseudoFile.getBytes(StandardCharsets.UTF_8));
            File out = new File(this.resourcesDir, "src@" + shaForPath + ".txt");
            if (!out.exists()) {
                TraceUtils.writeBytes((File)out, (byte[])bytes);
            }
            LinkedHashMap<String, Object> frame = new LinkedHashMap<String, Object>();
            frame.put("file", pseudoFile);
            frame.put("line", 1);
            frame.put("column", 1);
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("file", pseudoFile);
            result.put("frame", frame);
            result.put("sha", shaForPath);
            return result;
        }
        catch (Throwable t) {
            TraceDebug.writeLine((String)("args source error: " + t.getMessage()));
            return null;
        }
    }

    private static String sanitizeArgsSegment(String title) {
        String base = title != null ? title : "keyword";
        base = base.replaceAll("[^A-Za-z0-9._-]+", "_");
        base = base.replaceAll("_{2,}", "_");
        base = base.replaceAll("^_", "").replaceAll("_$", "");
        return base.isEmpty() ? "keyword" : base;
    }

    private static String extFromContentType(String ct) {
        if (ct == null) {
            return "dat";
        }
        String lower = ct.toLowerCase();
        if (lower.startsWith("text/css")) {
            return "css";
        }
        if (lower.startsWith("text/html")) {
            return "html";
        }
        if (lower.startsWith("application/json")) {
            return "json";
        }
        return "dat";
    }

    private static Map<String, Object> sanitizeLocation(Object raw) {
        if (!(raw instanceof Map)) {
            return null;
        }
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        Map src = (Map)raw;
        for (Map.Entry e : src.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k == null || v == null) continue;
            out.put(String.valueOf(k), v);
        }
        return out.isEmpty() ? null : out;
    }

    private static String currentPageId() {
        WebDriver driver;
        block3: {
            try {
                driver = DriverFactory.getWebDriver();
                if (driver != null) break block3;
                return "page-1";
            }
            catch (Throwable throwable) {
                return "page-1";
            }
        }
        String handle = driver.getWindowHandle();
        return handle != null ? handle : "page-1";
    }

    private static String safeBrowserName(WebDriver driver) {
        try {
            return driver != null && driver.getClass() != null && driver.getClass().getSimpleName() != null ? driver.getClass().getSimpleName() : "browser";
        }
        catch (Throwable throwable) {
            return "browser";
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public File getTracesDir() {
        return this.tracesDir;
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public File getTraceFile() {
        return this.traceFile;
    }

    public File getNetworkFile() {
        return this.networkFile;
    }

    public String getContextId() {
        return this.contextId;
    }

    public Set<String> getResourceKeys() {
        return this.resourceKeys;
    }
}

