/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.implementation.accesshelpers.ChatCompletionsOptionsAccessHelper;
import com.azure.ai.openai.implementation.models.FunctionCallPreset;
import com.azure.ai.openai.models.AzureChatEnhancementConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.ChatCompletionStreamOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsToolDefinition;
import com.azure.ai.openai.models.ChatCompletionsToolSelection;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.FunctionCallConfig;
import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.ai.openai.models.FunctionName;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ChatCompletionsOptions
implements JsonSerializable<ChatCompletionsOptions> {
    private List<ChatCompletionsToolDefinition> tools;
    private final List<ChatRequestMessage> messages;
    private Integer maxTokens;
    private Double temperature;
    private Double topP;
    private Map<String, Integer> logitBias;
    private String user;
    private Integer n;
    private List<String> stop;
    private Double presencePenalty;
    private Double frequencyPenalty;
    private Boolean stream;
    private String model;
    private List<FunctionDefinition> functions;
    private BinaryData functionCall;
    private FunctionCallConfig functionCallConfig;
    private List<AzureChatExtensionConfiguration> dataSources;
    private AzureChatEnhancementConfiguration enhancements;
    private Long seed;
    private ChatCompletionsResponseFormat responseFormat;
    private BinaryData toolChoice;
    private Boolean logprobs;
    private Integer topLogprobs;
    private Integer maxCompletionTokens;
    private ChatCompletionStreamOptions streamOptions;
    private Boolean parallelToolCalls;

    public ChatCompletionsOptions(List<ChatRequestMessage> messages) {
        this.messages = messages;
    }

    public List<ChatRequestMessage> getMessages() {
        return this.messages;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public ChatCompletionsOptions setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public ChatCompletionsOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public ChatCompletionsOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public ChatCompletionsOptions setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ChatCompletionsOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public Integer getN() {
        return this.n;
    }

    public ChatCompletionsOptions setN(Integer n) {
        this.n = n;
        return this;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public ChatCompletionsOptions setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public ChatCompletionsOptions setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public ChatCompletionsOptions setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    private ChatCompletionsOptions setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public ChatCompletionsOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public List<FunctionDefinition> getFunctions() {
        return this.functions;
    }

    public ChatCompletionsOptions setFunctions(List<FunctionDefinition> functions) {
        this.functions = functions;
        return this;
    }

    BinaryData getFunctionCallInternal() {
        return this.functionCall;
    }

    ChatCompletionsOptions setFunctionCallInternal(BinaryData functionCall) {
        this.functionCall = functionCall;
        return this;
    }

    public FunctionCallConfig getFunctionCall() {
        return this.functionCallConfig;
    }

    public ChatCompletionsOptions setFunctionCall(FunctionCallConfig functionCallConfig) {
        this.functionCallConfig = functionCallConfig;
        this.functionCall = FunctionCallPreset.values().stream().anyMatch(preset -> preset.toString().equals(functionCallConfig.getName())) ? BinaryData.fromObject((Object)((Object)FunctionCallPreset.fromString(this.functionCallConfig.getName()))) : BinaryData.fromObject((Object)new FunctionName(this.functionCallConfig.getName()));
        return this;
    }

    public List<AzureChatExtensionConfiguration> getDataSources() {
        return this.dataSources;
    }

    public ChatCompletionsOptions setDataSources(List<AzureChatExtensionConfiguration> dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public AzureChatEnhancementConfiguration getEnhancements() {
        return this.enhancements;
    }

    public ChatCompletionsOptions setEnhancements(AzureChatEnhancementConfiguration enhancements) {
        this.enhancements = enhancements;
        return this;
    }

    public Long getSeed() {
        return this.seed;
    }

    public ChatCompletionsOptions setSeed(Long seed) {
        this.seed = seed;
        return this;
    }

    public ChatCompletionsResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public ChatCompletionsOptions setResponseFormat(ChatCompletionsResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public List<ChatCompletionsToolDefinition> getTools() {
        return this.tools;
    }

    public ChatCompletionsOptions setTools(List<ChatCompletionsToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public ChatCompletionsToolSelection getToolChoice() {
        return ChatCompletionsToolSelection.fromBinaryData(this.toolChoice);
    }

    public ChatCompletionsOptions setToolChoice(ChatCompletionsToolSelection toolChoice) {
        this.toolChoice = toolChoice.getPreset() != null ? BinaryData.fromObject((Object)((Object)toolChoice.getPreset())) : (toolChoice.getNamedToolSelection() != null ? BinaryData.fromObject((Object)toolChoice.getNamedToolSelection()) : null);
        return this;
    }

    public Boolean isLogprobs() {
        return this.logprobs;
    }

    public ChatCompletionsOptions setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
        return this;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public ChatCompletionsOptions setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
        return this;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public ChatCompletionsOptions setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    public ChatCompletionStreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    private ChatCompletionsOptions setStreamOptions(ChatCompletionStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
        return this;
    }

    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public ChatCompletionsOptions setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.toolChoice != null) {
            jsonWriter.writeRawField("tool_choice", this.toolChoice.toString());
        }
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("functions", this.functions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.functionCall != null) {
            jsonWriter.writeFieldName("function_call");
            this.functionCall.writeTo(jsonWriter);
        }
        jsonWriter.writeNumberField("max_tokens", (Number)this.maxTokens);
        jsonWriter.writeNumberField("max_completion_tokens", (Number)this.maxCompletionTokens);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeMapField("logit_bias", this.logitBias, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeStringField("user", this.user);
        jsonWriter.writeNumberField("n", (Number)this.n);
        jsonWriter.writeArrayField("stop", this.stop, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("presence_penalty", (Number)this.presencePenalty);
        jsonWriter.writeNumberField("frequency_penalty", (Number)this.frequencyPenalty);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeJsonField("stream_options", (JsonSerializable)this.streamOptions);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeArrayField("data_sources", this.dataSources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("enhancements", (JsonSerializable)this.enhancements);
        jsonWriter.writeNumberField("seed", (Number)this.seed);
        jsonWriter.writeBooleanField("logprobs", this.logprobs);
        jsonWriter.writeNumberField("top_logprobs", (Number)this.topLogprobs);
        jsonWriter.writeJsonField("response_format", (JsonSerializable)this.responseFormat);
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletionsOptions fromJson(JsonReader jsonReader) throws IOException {
        return (ChatCompletionsOptions)jsonReader.readObject(reader -> {
            List messages = null;
            List functions = null;
            BinaryData functionCall = null;
            Integer maxTokens = null;
            Integer maxCompletionTokens = null;
            Double temperature = null;
            Double topP = null;
            Map logitBias = null;
            String user = null;
            Integer n = null;
            List stop = null;
            Double presencePenalty = null;
            Double frequencyPenalty = null;
            Boolean stream = null;
            ChatCompletionStreamOptions streamOptions = null;
            String model = null;
            List dataSources = null;
            AzureChatEnhancementConfiguration enhancements = null;
            Long seed = null;
            Boolean logprobs = null;
            Integer topLogprobs = null;
            ChatCompletionsResponseFormat responseFormat = null;
            List tools = null;
            BinaryData toolChoice = null;
            Boolean parallelToolCalls = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    messages = reader.readArray(reader1 -> ChatRequestMessage.fromJson(reader1));
                    continue;
                }
                if ("functions".equals(fieldName)) {
                    functions = reader.readArray(reader1 -> FunctionDefinition.fromJson(reader1));
                    continue;
                }
                if ("function_call".equals(fieldName)) {
                    functionCall = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("max_tokens".equals(fieldName)) {
                    maxTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("logit_bias".equals(fieldName)) {
                    logitBias = reader.readMap(reader1 -> reader1.getInt());
                    continue;
                }
                if ("user".equals(fieldName)) {
                    user = reader.getString();
                    continue;
                }
                if ("n".equals(fieldName)) {
                    n = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("stop".equals(fieldName)) {
                    stop = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("presence_penalty".equals(fieldName)) {
                    presencePenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("frequency_penalty".equals(fieldName)) {
                    frequencyPenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stream_options".equals(fieldName)) {
                    streamOptions = ChatCompletionStreamOptions.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("data_sources".equals(fieldName)) {
                    dataSources = reader.readArray(reader1 -> AzureChatExtensionConfiguration.fromJson(reader1));
                    continue;
                }
                if ("enhancements".equals(fieldName)) {
                    enhancements = AzureChatEnhancementConfiguration.fromJson(reader);
                    continue;
                }
                if ("seed".equals(fieldName)) {
                    seed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("logprobs".equals(fieldName)) {
                    logprobs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("top_logprobs".equals(fieldName)) {
                    topLogprobs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = ChatCompletionsResponseFormat.fromJson(reader);
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ChatCompletionsToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            ChatCompletionsOptions deserializedChatCompletionsOptions = new ChatCompletionsOptions(messages);
            deserializedChatCompletionsOptions.functions = functions;
            deserializedChatCompletionsOptions.functionCall = functionCall;
            deserializedChatCompletionsOptions.maxTokens = maxTokens;
            deserializedChatCompletionsOptions.maxCompletionTokens = maxCompletionTokens;
            deserializedChatCompletionsOptions.temperature = temperature;
            deserializedChatCompletionsOptions.topP = topP;
            deserializedChatCompletionsOptions.logitBias = logitBias;
            deserializedChatCompletionsOptions.user = user;
            deserializedChatCompletionsOptions.n = n;
            deserializedChatCompletionsOptions.stop = stop;
            deserializedChatCompletionsOptions.presencePenalty = presencePenalty;
            deserializedChatCompletionsOptions.frequencyPenalty = frequencyPenalty;
            deserializedChatCompletionsOptions.stream = stream;
            deserializedChatCompletionsOptions.streamOptions = streamOptions;
            deserializedChatCompletionsOptions.model = model;
            deserializedChatCompletionsOptions.dataSources = dataSources;
            deserializedChatCompletionsOptions.enhancements = enhancements;
            deserializedChatCompletionsOptions.seed = seed;
            deserializedChatCompletionsOptions.logprobs = logprobs;
            deserializedChatCompletionsOptions.topLogprobs = topLogprobs;
            deserializedChatCompletionsOptions.responseFormat = responseFormat;
            deserializedChatCompletionsOptions.tools = tools;
            deserializedChatCompletionsOptions.toolChoice = toolChoice;
            deserializedChatCompletionsOptions.parallelToolCalls = parallelToolCalls;
            return deserializedChatCompletionsOptions;
        });
    }

    static {
        ChatCompletionsOptionsAccessHelper.setAccessor(new ChatCompletionsOptionsAccessHelper.ChatCompletionsOptionsAccessor(){

            @Override
            public void setStream(ChatCompletionsOptions options, boolean stream) {
                options.setStream(stream);
            }

            @Override
            public void setStreamOptions(ChatCompletionsOptions options, ChatCompletionStreamOptions streamOptions) {
                options.setStreamOptions(streamOptions);
            }
        });
    }
}

