/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHeader;

abstract class HttpMessage<M extends HttpMessage<M>> {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Contents.Supplier content = Contents.empty();

    HttpMessage() {
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public M setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this.self();
    }

    public M removeAttribute(String key) {
        this.attributes.remove(key);
        return this.self();
    }

    public Iterable<String> getAttributeNames() {
        return Set.copyOf(this.attributes.keySet());
    }

    public void forEachHeader(BiConsumer<String, String> action) {
        this.headers.forEach((name, values) -> values.forEach(value -> action.accept((String)name, (String)value)));
    }

    public Iterable<String> getHeaderNames() {
        return Collections.unmodifiableCollection(this.headers.keySet());
    }

    public Iterable<String> getHeaders(String name) {
        return Collections.unmodifiableCollection(this.headers.getOrDefault(name.toLowerCase(Locale.ENGLISH), Collections.emptyList()));
    }

    public @Nullable String getHeader(HttpHeader name) {
        return this.getHeader(name.getName());
    }

    public @Nullable String getHeader(String name) {
        String lcName = name.toLowerCase(Locale.ENGLISH);
        List values = this.headers.getOrDefault(lcName, Collections.emptyList());
        return !values.isEmpty() ? (String)values.get(0) : null;
    }

    public M setHeader(String name, String value) {
        String lcName = name.toLowerCase(Locale.ENGLISH);
        return ((HttpMessage)this.removeHeader(lcName)).addHeader(lcName, value);
    }

    public M addHeader(HttpHeader name, String value) {
        return this.addHeader(name.getName(), value);
    }

    public M addHeader(String name, String value) {
        String lcName = name.toLowerCase(Locale.ENGLISH);
        List values = this.headers.computeIfAbsent(lcName, n -> new ArrayList());
        values.add(value);
        return this.self();
    }

    public M removeHeader(String name) {
        String lcName = name.toLowerCase(Locale.ENGLISH);
        this.headers.remove(lcName);
        return this.self();
    }

    public @Nullable Long getContentLength() {
        return Optional.ofNullable(this.getHeader(HttpHeader.ContentLength)).map(Long::parseLong).orElse(-1L);
    }

    public @Nullable String getContentType() {
        return this.getHeader(HttpHeader.ContentType);
    }

    public Charset getContentEncoding() {
        try {
            String contentType = this.getContentType();
            if (contentType != null) {
                return Arrays.stream(contentType.split(";")).map(e -> e.trim().toLowerCase(Locale.ENGLISH)).filter(e -> e.startsWith("charset=")).map(e -> e.substring(e.indexOf(61) + 1)).map(Charset::forName).findFirst().orElse(StandardCharsets.UTF_8);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return StandardCharsets.UTF_8;
    }

    @Deprecated
    public M setContent(Supplier<InputStream> supplier) {
        try {
            return this.setContent(Contents.bytes(supplier.get().readAllBytes()));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public M setContent(Contents.Supplier supplier) {
        this.content = (Contents.Supplier)Require.nonNull((String)"Supplier", (Object)supplier);
        return this.self();
    }

    public Contents.Supplier getContent() {
        return this.content;
    }

    public String toString() {
        return this.getContent().toString();
    }

    public String contentAsString() {
        return this.getContent().contentAsString(this.getContentEncoding());
    }

    private M self() {
        return (M)this;
    }
}

