/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.integration.IntegratedType;
import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestCycle;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestRelease;
import com.kms.katalon.integration.qtest.entity.QTestReleaseRoot;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestSuiteParent;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.helper.QTestAPIRequestHelper;
import com.kms.katalon.integration.qtest.helper.QTestHttpRequestHelper;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.qas.api.AuthClientException;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.qtest.api.auth.BasicQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.model.FieldValue;
import org.qas.qtest.api.internal.model.Link;
import org.qas.qtest.api.services.execution.TestExecutionServiceClient;
import org.qas.qtest.api.services.execution.model.CreateTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.ListTestRunRequest;
import org.qas.qtest.api.services.execution.model.ListTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.TestRun;
import org.qas.qtest.api.services.execution.model.TestSuite;

public class QTestIntegrationTestSuiteManager {
    private static final String PARENT_PROPERTY_PREFIX = "parent.";

    private QTestIntegrationTestSuiteManager() {
    }

    public static QTestSuite getQTestSuite(long id, List<QTestSuite> qTestSuites) {
        for (QTestSuite qTestSuite : qTestSuites) {
            if (qTestSuite.getId() != id) continue;
            return qTestSuite;
        }
        return null;
    }

    public static void setSelectedQTestSuite(QTestSuite selectedQTestSuite, List<QTestSuite> qTestSuites) {
        if (!qTestSuites.contains(selectedQTestSuite)) {
            qTestSuites.add(selectedQTestSuite);
        }
        for (QTestSuite siblingQTestSuite : qTestSuites) {
            siblingQTestSuite.setSelected(false);
        }
        selectedQTestSuite.setSelected(true);
    }

    public static QTestSuite getSelectedQTestSuiteByIntegratedEntity(List<QTestSuite> qTestSuites) {
        for (QTestSuite qTestSuite : qTestSuites) {
            if (!qTestSuite.isSelected()) continue;
            return qTestSuite;
        }
        return null;
    }

    public static QTestRun getTestRunByTestSuiteAndTestCaseId(QTestSuite qTestSuite, long testCaseId) {
        if (qTestSuite == null) {
            return null;
        }
        QTestRun testRun = null;
        for (QTestRun childTestRun : qTestSuite.getTestRuns()) {
            if (childTestRun.getQTestCaseId() != testCaseId) continue;
            testRun = childTestRun;
            break;
        }
        return testRun;
    }

    public static IntegratedEntity addQTestSuiteToIntegratedEntity(QTestSuite qTestSuite, IntegratedEntity testSuiteIntegratedEntity, int order) {
        testSuiteIntegratedEntity.getProperties().put(Integer.toString(order), QTestIntegrationTestSuiteManager.getQTestSuitePropertiesString(qTestSuite));
        return testSuiteIntegratedEntity;
    }

    public static String getQTestSuitePropertiesString(QTestSuite qTestSuite) {
        StringBuilder testRunMapStringBuilder = new StringBuilder(new JsonObject(qTestSuite.getProperties()).toString());
        return testRunMapStringBuilder.toString().replace("},", "},\n");
    }

    public static IntegratedEntity getIntegratedEntityByTestSuiteList(List<QTestSuite> qTestSuites) {
        IntegratedEntity testSuiteIntegratedEntity = new IntegratedEntity();
        testSuiteIntegratedEntity.setProductName("qTest");
        testSuiteIntegratedEntity.setType(IntegratedType.TESTSUITE);
        for (QTestSuite qTestSuite : qTestSuites) {
            QTestIntegrationTestSuiteManager.addQTestSuiteToIntegratedEntity(qTestSuite, testSuiteIntegratedEntity, qTestSuites.indexOf(qTestSuite));
        }
        return testSuiteIntegratedEntity;
    }

    public static List<QTestSuite> getQTestSuiteListByIntegratedEntity(IntegratedEntity integratedEntity) throws QTestInvalidFormatException {
        ArrayList<QTestSuite> qTestSuiteCollection = new ArrayList<QTestSuite>();
        if (integratedEntity == null || integratedEntity.getType() != IntegratedType.TESTSUITE) {
            return qTestSuiteCollection;
        }
        try {
            TreeMap properties = new TreeMap(integratedEntity.getProperties());
            for (Map.Entry entry : properties.entrySet()) {
                String value = (String)entry.getValue();
                JsonObject qTestSuiteJsonObject = new JsonObject(value.replace("},\n", "},"));
                QTestSuite qTestSuite = new QTestSuite();
                qTestSuite.setName(qTestSuiteJsonObject.getString("name"));
                qTestSuite.setId(qTestSuiteJsonObject.getLong("id"));
                qTestSuite.setPid(qTestSuiteJsonObject.getString("pid"));
                qTestSuite.setSelected(qTestSuiteJsonObject.getBoolean("default"));
                JsonObject parentJsonObject = qTestSuiteJsonObject.getJsonObject("parent");
                qTestSuite.setParent(QTestIntegrationTestSuiteManager.getTestSuiteParentByJsonObject(parentJsonObject));
                JsonArray testRunJsonArray = qTestSuiteJsonObject.getJsonArray("testRuns");
                qTestSuite.setTestRuns(QTestIntegrationTestSuiteManager.getQTestRunCollection(testRunJsonArray));
                qTestSuiteCollection.add(qTestSuite);
            }
        }
        catch (JsonException e) {
            throw new QTestInvalidFormatException(e.getMessage());
        }
        return qTestSuiteCollection;
    }

    private static QTestSuiteParent getTestSuiteParentByJsonObject(JsonObject parentJsonObject) throws JsonException {
        long id = parentJsonObject.getLong("id");
        String name = parentJsonObject.getString("name");
        int type = parentJsonObject.getInt("type");
        long parentId = parentJsonObject.getLong("parentId");
        QTestSuiteParent parent = null;
        if (parentId > 0L && type == 4) {
            QTestRelease release = new QTestRelease();
            release.setId(parentId);
            String parentName = parentJsonObject.optString("parentName", "");
            release.setName(parentName != null ? parentName : "");
            QTestCycle cycle = new QTestCycle(release);
            cycle.setId(id);
            cycle.setName(name);
            parent = cycle;
        } else {
            parent = QTestSuiteParent.getTestSuiteParent(id, type, name);
        }
        return parent;
    }

    public static List<QTestRun> getQTestRunCollection(JsonArray testRunJsonArray) throws JsonException {
        ArrayList<QTestRun> qTestRunCollection = new ArrayList<QTestRun>();
        int index = 0;
        while (index < testRunJsonArray.length()) {
            JsonObject qTestRunJsonObject = testRunJsonArray.getJsonObject(index);
            QTestRun qTestRun = new QTestRun();
            qTestRun.setId(qTestRunJsonObject.getLong("id"));
            qTestRun.setName(qTestRunJsonObject.getString("name"));
            qTestRun.setQTestCaseId(qTestRunJsonObject.getLong("qTestCaseId"));
            if (qTestRunJsonObject.has("pid")) {
                qTestRun.setPid(qTestRunJsonObject.getString("pid"));
            }
            qTestRunCollection.add(qTestRun);
            ++index;
        }
        return qTestRunCollection;
    }

    public static IntegratedEntity getIntegratedEntityByTestSuite(QTestSuite qTestTS) {
        IntegratedEntity testSuiteIntegratedEntity = new IntegratedEntity();
        testSuiteIntegratedEntity.setProductName("qTest");
        testSuiteIntegratedEntity.setType(IntegratedType.TESTSUITE);
        testSuiteIntegratedEntity.getProperties().put("id", Long.toString(qTestTS.getId()));
        testSuiteIntegratedEntity.getProperties().put("name", qTestTS.getName());
        testSuiteIntegratedEntity.getProperties().put("pid", qTestTS.getPid());
        QTestSuiteParent parent = qTestTS.getParent();
        testSuiteIntegratedEntity.getProperties().put("parent.id", Long.toString(parent.getId()));
        testSuiteIntegratedEntity.getProperties().put("parent.name", parent.getName());
        testSuiteIntegratedEntity.getProperties().put("parent.type", Integer.toString(parent.getType()));
        HashMap<Long, Map<String, Object>> testRunMap = new HashMap<Long, Map<String, Object>>();
        for (QTestRun testRun : qTestTS.getTestRuns()) {
            testRunMap.put(testRun.getQTestCaseId(), testRun.getMapProperties());
        }
        StringBuilder testRunMapStringBuilder = new StringBuilder(new JsonObject(testRunMap).toString().replace("},", "},\n"));
        testSuiteIntegratedEntity.getProperties().put("testRun", testRunMapStringBuilder.toString().replace("\"", ""));
        return testSuiteIntegratedEntity;
    }

    private static String getTestSuiteData(QTestSuite testSuite, QTestProject project, IQTestCredential credential) throws QTestException {
        String url = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, project) + "/test-suites/" + Long.toString(testSuite.getId());
        return QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
    }

    private static String getTestSuiteFields(QTestProject project, IQTestCredential credential) throws QTestException {
        String url = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, project) + "/settings/test-suites/fields";
        return QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
    }

    private static long getTestSuiteFieldId(String fieldName, JsonArray responseJsonArray) throws JsonException {
        int index = 0;
        while (index < responseJsonArray.length()) {
            JsonObject fieldJsonObject = responseJsonArray.getJsonObject(index);
            String responseFieldName = fieldJsonObject.getString("label");
            if (fieldName.equalsIgnoreCase(responseFieldName)) {
                return fieldJsonObject.getLong("id");
            }
            ++index;
        }
        return 0L;
    }

    private static String getTestSuiteProperty(long fieldId, JsonObject testSuiteJson) throws JsonException {
        JsonArray propertiesArray = testSuiteJson.getJsonArray("properties");
        int index = 0;
        while (index < propertiesArray.length()) {
            JsonObject propertyJsonObject = propertiesArray.getJsonObject(index);
            if (propertyJsonObject.getLong("field_id") == fieldId) {
                return propertyJsonObject.getString("field_value");
            }
            ++index;
        }
        return "";
    }

    public static QTestRun uploadTestCaseInTestSuite(QTestTestCase testCase, QTestSuite testSuite, QTestProject project, IQTestCredential credential) throws QTestException {
        String url = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, project) + "/test-runs?parentId=" + Long.toString(testSuite.getId()) + "&parentType=test-suite";
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        JsonObject testCaseInfoJsonArray = new JsonObject();
        try {
            testCaseInfoJsonArray.put("id", testCase.getId());
            if (!QTestSettingStore.isSubmitResultToLatestVersionActive(((QTestSettingCredential)credential).getProjectDir())) {
                testCaseInfoJsonArray.put("test_case_version_id", testCase.getVersionId());
            }
        }
        catch (JsonException e) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(e.getMessage());
        }
        bodyMap.put("name", testCase.getName());
        bodyMap.put("test_case", (String)testCaseInfoJsonArray);
        String result = QTestAPIRequestHelper.sendPostRequestViaAPI(url, credential.getToken(), new JsonObject(bodyMap).toString());
        try {
            if (result != null && !result.isEmpty()) {
                JsonObject resultObject = new JsonObject(result);
                QTestRun testRun = new QTestRun();
                testRun.setId(resultObject.getLong("id"));
                testRun.setName(testCase.getName());
                testRun.setQTestCaseId(testCase.getId());
                testRun.setPid(resultObject.getString("pid"));
                testRun.setTestCaseVersionId(testCase.getVersionId());
                return testRun;
            }
            return null;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
        }
    }

    public static QTestSuite uploadTestSuite(IQTestCredential credentials, String name, String description, QTestSuiteParent parent, QTestProject qTestProject) throws QTestException {
        String token = credentials.getToken().getAccessTokenHeader();
        String serverUrl = credentials.getServerUrl();
        if (!QTestIntegrationAuthenticationManager.validateToken(token)) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        TestExecutionServiceClient executionService = new TestExecutionServiceClient((QTestCredentials)new BasicQTestCredentials(token));
        executionService.setEndpoint(serverUrl);
        TestSuite testSuite = new TestSuite().withName(name);
        ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
        JsonArray reponseJsonArray = QTestIntegrationTestSuiteManager.getTestSuiteFieldJsonArray(qTestProject, credentials);
        int index = 0;
        while (index < reponseJsonArray.length()) {
            try {
                JsonObject fieldJsonObject = reponseJsonArray.getJsonObject(index);
                if (fieldJsonObject.has("label") && "Description".equals(fieldJsonObject.getString("label"))) {
                    fieldValues.add(new FieldValue(Long.valueOf(fieldJsonObject.getLong("id")), QTestIntegrationTestCaseManager.getUploadedDescription(description)));
                    break;
                }
            }
            catch (JsonException jsonException) {
                throw QTestInvalidFormatException.createInvalidJsonFormatException(reponseJsonArray.toString());
            }
            ++index;
        }
        testSuite.setFieldValues(fieldValues);
        CreateTestSuiteRequest request = new CreateTestSuiteRequest().withProjectId(Long.valueOf(qTestProject.getId())).withTestSuite(testSuite);
        if (parent.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.setArtifactId(Long.valueOf(parent.getId()));
            request.setArtifactLevel(parent.getArtifactLevel());
        }
        testSuite = executionService.createTestSuite(request);
        return new QTestSuite(testSuite.getId(), name, (String)testSuite.getProperty("pid"), parent);
    }

    public static QTestSuite getDuplicatedTestSuiteOnQTest(IQTestCredential credentials, String name, QTestSuiteParent parent, QTestProject qTestProject) throws QTestUnauthorizedException, QTestInvalidFormatException {
        String token = credentials.getToken().getAccessTokenHeader();
        String serverUrl = credentials.getServerUrl();
        if (!QTestIntegrationAuthenticationManager.validateToken(token)) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        TestExecutionServiceClient executionService = new TestExecutionServiceClient((QTestCredentials)new BasicQTestCredentials(token));
        executionService.setEndpoint(serverUrl);
        ListTestSuiteRequest request = new ListTestSuiteRequest().withProjectId(Long.valueOf(qTestProject.getId()));
        switch (parent.getType()) {
            case 8: {
                request.setArtifactId(Long.valueOf(parent.getId()));
                request.setArtifactLevel(ArtifactLevel.RELEASE);
                break;
            }
            case 4: {
                request.setArtifactId(Long.valueOf(parent.getId()));
                request.setArtifactLevel(ArtifactLevel.TEST_CYCLE);
                break;
            }
        }
        for (TestSuite testSuite : executionService.listTestSuite(request)) {
            if (!name.equals(testSuite.getName())) continue;
            QTestSuite qTestSuite = new QTestSuite();
            qTestSuite.setName(name);
            qTestSuite.setParent(parent);
            qTestSuite.setId(testSuite.getId());
            qTestSuite.setPid((String)testSuite.getProperty("pid"));
            return qTestSuite;
        }
        return null;
    }

    public static void deleteTestSuiteOnQTest(IQTestCredential credential, QTestSuite qTestTS, QTestProject qTestProject) throws QTestException {
        LinkedHashMap<String, Object> bodyProperties = new LinkedHashMap<String, Object>();
        int testCaseType = QTestSuite.getType();
        bodyProperties.put("id", Integer.toString(testCaseType) + "-" + qTestTS.getId());
        bodyProperties.put("objId", qTestTS.getId());
        bodyProperties.put("parentId", qTestTS.getParent().getId());
        bodyProperties.put("type", testCaseType);
        String url = "/p/" + Long.toString(qTestProject.getId()) + "/portal/tree/delete";
        QTestIntegrationAuthenticationManager.authenticate(credential.getUsername(), credential.getPassword());
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("data", QTestHttpRequestHelper.createDataBody(bodyProperties, true));
        QTestHttpRequestHelper.sendPostRequest(credential, url, body);
    }

    public static URL navigatedUrlForQTestSuite(String projectDir, QTestSuite testSuite, QTestProject qTestProject) throws MalformedURLException {
        String url = QTestSettingStore.getServerUrl(QTestSettingStore.isEncryptionEnabled(projectDir), projectDir);
        return new URL(url + "/p/" + Long.toString(qTestProject.getId()) + "/portal/project#tab=testexecution&object=" + QTestSuite.getType() + "&id=" + Long.toString(testSuite.getId()));
    }

    public static QTestReleaseRoot getTestSuiteIdRootOnQTest(IQTestCredential credential, QTestProject qTestProject) throws QTestException {
        QTestReleaseRoot testSuiteParentRoot = new QTestReleaseRoot();
        testSuiteParentRoot.setId(0L);
        testSuiteParentRoot.setName(qTestProject.getName());
        testSuiteParentRoot.setChildren(QTestIntegrationTestSuiteManager.getReleases(qTestProject, credential));
        return testSuiteParentRoot;
    }

    public static List<QTestSuiteParent> getReleases(QTestProject qTestProject, IQTestCredential credential) throws QTestException {
        ArrayList<QTestSuiteParent> qTestReleases = new ArrayList<QTestSuiteParent>();
        String url = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, qTestProject) + "/releases";
        String result = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonArray resultJsonArray = new JsonArray(result);
            int index = 0;
            while (index < resultJsonArray.length()) {
                JsonObject testReleaseJsonObject = resultJsonArray.getJsonObject(index);
                QTestRelease release = new QTestRelease();
                release.setId(testReleaseJsonObject.getLong("id"));
                release.setName(testReleaseJsonObject.getString("name"));
                release.setCycles(QTestIntegrationTestSuiteManager.getCycles(qTestProject, release, credential));
                qTestReleases.add(release);
                ++index;
            }
            return qTestReleases;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
        }
    }

    public static List<QTestSuiteParent> getCycles(QTestProject qTestProject, QTestRelease release, IQTestCredential credential) throws QTestException {
        ArrayList<QTestSuiteParent> qTestCycles = new ArrayList<QTestSuiteParent>();
        String url = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, qTestProject) + "/test-cycles?parentId=" + Long.toString(release.getId()) + "&parentType=release";
        String result = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonArray resultJsonArray = new JsonArray(result);
            int index = 0;
            while (index < resultJsonArray.length()) {
                JsonObject testCycleJsonObject = resultJsonArray.getJsonObject(index);
                QTestCycle cycle = new QTestCycle(release);
                cycle.setId(testCycleJsonObject.getLong("id"));
                cycle.setName(testCycleJsonObject.getString("name"));
                qTestCycles.add(cycle);
                ++index;
            }
            return qTestCycles;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
        }
    }

    public static List<QTestRun> getTestRuns(QTestSuite qTestSuite, QTestProject qTestProject, IQTestCredential credentials) throws QTestException {
        ArrayList<QTestRun> qTestRuns = new ArrayList<QTestRun>();
        BasicQTestCredentials qTestCredentials = new BasicQTestCredentials(credentials.getToken().getAccessTokenHeader());
        TestExecutionServiceClient service = new TestExecutionServiceClient((QTestCredentials)qTestCredentials);
        service.setEndpoint(credentials.getServerUrl());
        ListTestRunRequest request = new ListTestRunRequest().withProjectId(Long.valueOf(qTestProject.getId())).withArtifactId(Long.valueOf(qTestSuite.getId())).withArtifactLevel(ArtifactLevel.TEST_SUITE);
        List<Object> testRuns = new ArrayList();
        try {
            testRuns = service.listTestRun(request);
        }
        catch (AuthClientException e) {
            if (e.getMessage().contains("Cannot deserialize value of type `java.util.ArrayList")) {
                testRuns = QTestIntegrationTestSuiteManager.listTestRunsByApi(qTestSuite, qTestProject, credentials);
            }
            throw e;
        }
        for (TestRun testRun : testRuns) {
            QTestRun qTestRun = new QTestRun(testRun.getId(), testRun.getName());
            qTestRun.setPid(testRun.getPid());
            for (Link testRunLink : testRun.getLinks()) {
                if (!"test-case".equals(testRunLink.getRelation())) continue;
                String[] testCaseHrefCut = testRunLink.getHref().split("test-cases/")[1].split(Pattern.quote("?versionId="));
                qTestRun.setQTestCaseId(Long.parseLong(testCaseHrefCut[0]));
                qTestRun.setTestCaseVersionId(Long.parseLong(testCaseHrefCut[1].split("&")[0]));
                break;
            }
            qTestRuns.add(qTestRun);
        }
        return qTestRuns;
    }

    public static List<TestRun> listTestRunsByApi(QTestSuite qTestSuite, QTestProject qTestProject, IQTestCredential credentials) throws QTestException {
        String serverUrl = credentials.getServerUrl();
        String url = serverUrl + "/api/v3/projects/" + Long.toString(qTestProject.getId()) + "/test-runs?parentId=" + Long.toString(qTestSuite.getId()) + "&parentType=test-suite";
        String serverJsResult = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credentials.getToken());
        try {
            JsonObject jsResultObj = new JsonObject(serverJsResult);
            JsonArray itemsArray = jsResultObj.getJsonArray("items");
            ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
            int relIdx = 0;
            while (relIdx < itemsArray.length()) {
                JsonObject relJsObj = itemsArray.getJsonObject(relIdx);
                TestRun testRun = new TestRun();
                testRun.setId(Long.valueOf(relJsObj.getLong("id")));
                testRun.setName(relJsObj.getString("name"));
                testRun.setOrder(Integer.valueOf(relJsObj.getInt("order")));
                testRun.setPid(relJsObj.getString("pid"));
                JsonArray linksArray = relJsObj.getJsonArray("links");
                ArrayList<Link> linkLst = new ArrayList<Link>();
                int linkIdx = 0;
                while (linkIdx < linksArray.length()) {
                    JsonObject linkJsObj = linksArray.getJsonObject(linkIdx);
                    String rel = linkJsObj.getString("rel");
                    String href = linkJsObj.getString("href");
                    Link link = new Link();
                    link.setRelation(rel);
                    link.setHref(href);
                    linkLst.add(link);
                    ++linkIdx;
                }
                testRun.setLinks(linkLst);
                testRuns.add(testRun);
                ++relIdx;
            }
            return testRuns;
        }
        catch (JsonException ex) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(ex.getMessage());
        }
    }

    private static JsonArray getTestSuiteFieldJsonArray(QTestProject qTestProject, IQTestCredential credential) throws QTestException {
        String response;
        block3: {
            String url = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, qTestProject) + "/settings/test-suites/fields";
            response = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
            try {
                if (response != null && !response.isEmpty()) break block3;
                return null;
            }
            catch (JsonException jsonException) {
                throw QTestInvalidFormatException.createInvalidJsonFormatException(response);
            }
        }
        JsonArray responseJsonArray = new JsonArray(response);
        return responseJsonArray;
    }

    public static QTestSuite getQTestSuite(long id, QTestProject qTestProject, IQTestCredential credential) throws QTestException {
        String serverUrl = credential.getServerUrl();
        String url = serverUrl + "/api/v3/projects/" + Long.toString(qTestProject.getId()) + "/test-suites/" + Long.toString(id);
        String serverJsResult = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonObject jsResultObj = new JsonObject(serverJsResult);
            QTestSuite qTestSuite = new QTestSuite();
            qTestSuite.setId(jsResultObj.getLong("id"));
            qTestSuite.setName(jsResultObj.getString("name"));
            qTestSuite.setPid(jsResultObj.getString("pid"));
            JsonArray relLinkJsArrs = jsResultObj.getJsonArray("links");
            int relIdx = 0;
            while (relIdx < relLinkJsArrs.length()) {
                String parentRelPrefix;
                JsonObject relJsObj = relLinkJsArrs.getJsonObject(relIdx);
                String relName = relJsObj.getString("rel");
                if (relName.startsWith(parentRelPrefix = "parent-")) {
                    String parentTypeName = relName.substring(parentRelPrefix.length(), relName.length());
                    String hrefName = relJsObj.getString("href");
                    String hrefPrefix = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, qTestProject) + "/" + parentTypeName + "s/";
                    long parentId = Long.parseLong(hrefName.substring(hrefPrefix.length(), hrefName.length()));
                    int parentType = QTestIntegrationTestSuiteManager.getTestSuiteParentType(parentTypeName);
                    QTestSuiteParent tsParent = QTestIntegrationTestSuiteManager.getQTestSuiteParent(parentId, parentType, qTestProject, credential);
                    qTestSuite.setParent(tsParent);
                }
                ++relIdx;
            }
            if (qTestSuite.getParent() == null) {
                QTestReleaseRoot root = QTestIntegrationTestSuiteManager.getTestSuiteIdRootOnQTest(credential, qTestProject);
                qTestSuite.setParent(root);
            }
            return qTestSuite;
        }
        catch (JsonException ex) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(ex.getMessage());
        }
    }

    public static QTestSuiteParent getQTestSuiteParent(long id, int type, QTestProject qTestProject, IQTestCredential credential) throws QTestException {
        if (type == 6) {
            return QTestSuiteParent.getTestSuiteParent(id, type, qTestProject.getName());
        }
        String parentPrefixName = "";
        if (type == 4) {
            parentPrefixName = "test-cycles";
        } else if (type == 8) {
            parentPrefixName = "releases";
        } else {
            throw new IllegalArgumentException(Integer.toString(type) + " isn't a valid parent test suite's type");
        }
        String url = QTestIntegrationProjectManager.getProjectAPIPrefix(credential, qTestProject) + "/" + parentPrefixName + "/" + Long.toString(id);
        String serverResult = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonObject parentJsResult = new JsonObject(serverResult);
            return QTestSuiteParent.getTestSuiteParent(id, type, parentJsResult.getString("name"));
        }
        catch (JsonException e) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(e.getMessage());
        }
    }

    public static int getTestSuiteParentType(String name) {
        switch (name) {
            case "test-cycle": {
                return 4;
            }
            case "release": {
                return 8;
            }
            case "root": {
                return 6;
            }
        }
        throw new IllegalArgumentException(name + " is not a valid name.");
    }
}

