/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.model.SyncStatus;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.qas.api.internal.util.google.base.Preconditions;

public class QTestSyncStatusUtil {
    public static void recursivelyUnmarkAllStatuses(IntegratedFileEntity integratedFileEntity, ProjectEntity project) throws Exception {
        Preconditions.checkNotNull((Object)integratedFileEntity);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isUnderTestCaseRoot(integratedFileEntity));
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isIntegrated(integratedFileEntity, project));
        QTestSyncStatusUtil.recursivelyUnmarkObsolete(integratedFileEntity, project);
        QTestSyncStatusUtil.recursivelyUnmarkError(integratedFileEntity, project);
    }

    public static void recursivelyUnmarkAllStatusesIfNoChildWithSameStatus(FolderEntity folder, ProjectEntity project) throws Exception {
        Preconditions.checkNotNull((Object)folder);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isUnderTestCaseRoot((IntegratedFileEntity)folder));
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)folder, project));
        QTestSyncStatusUtil.recursivelyRemoveStatusIfNoChildWithSameStatus(folder, SyncStatus.OBSOLETE, project);
        QTestSyncStatusUtil.recursivelyRemoveStatusIfNoChildWithSameStatus(folder, SyncStatus.ERROR, project);
    }

    public static boolean isObsolete(IntegratedFileEntity integratedFileEntity, ProjectEntity project) throws Exception {
        Preconditions.checkNotNull((Object)integratedFileEntity);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isUnderTestCaseRoot(integratedFileEntity));
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isIntegrated(integratedFileEntity, project));
        return QTestSyncStatusUtil.hasStatus(integratedFileEntity, SyncStatus.OBSOLETE);
    }

    public static void recursivelyMarkObsolete(IntegratedFileEntity integratedFileEntity, ProjectEntity project) throws Exception {
        QTestSyncStatusUtil.recursivelyAddStatus(integratedFileEntity, SyncStatus.OBSOLETE, project);
    }

    public static void recursivelyUnmarkObsolete(IntegratedFileEntity integratedFileEntity, ProjectEntity project) throws Exception {
        QTestSyncStatusUtil.recursivelyRemoveStatus(integratedFileEntity, SyncStatus.OBSOLETE, project);
    }

    public static void recursivelyUnmarkObsoleteIfNoObsoleteChild(FolderEntity folderEntity, ProjectEntity project) throws Exception {
        QTestSyncStatusUtil.recursivelyRemoveStatusIfNoChildWithSameStatus(folderEntity, SyncStatus.OBSOLETE, project);
    }

    public static boolean hasErrorStatus(IntegratedFileEntity integratedFileEntity, ProjectEntity project) throws Exception {
        Preconditions.checkNotNull((Object)integratedFileEntity);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isUnderTestCaseRoot(integratedFileEntity));
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isIntegrated(integratedFileEntity, project));
        return QTestSyncStatusUtil.hasStatus(integratedFileEntity, SyncStatus.ERROR);
    }

    public static void recursivelyMarkError(IntegratedFileEntity integratedFileEntity, ProjectEntity project) throws Exception {
        QTestSyncStatusUtil.recursivelyAddStatus(integratedFileEntity, SyncStatus.ERROR, project);
    }

    public static void recursivelyUnmarkError(IntegratedFileEntity integratedFileEntity, ProjectEntity project) throws Exception {
        QTestSyncStatusUtil.recursivelyRemoveStatus(integratedFileEntity, SyncStatus.ERROR, project);
    }

    private static void recursivelyAddStatus(IntegratedFileEntity integratedFileEntity, SyncStatus status, ProjectEntity project) throws Exception {
        Preconditions.checkNotNull((Object)integratedFileEntity);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isUnderTestCaseRoot(integratedFileEntity));
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isIntegrated(integratedFileEntity, project));
        QTestSyncStatusUtil.addStatus(integratedFileEntity, status);
        if (integratedFileEntity instanceof TestCaseEntity) {
            TestCaseController.getInstance().updateTestCase((TestCaseEntity)integratedFileEntity);
        } else if (integratedFileEntity instanceof FolderEntity) {
            FolderController.getInstance().saveFolder((FolderEntity)integratedFileEntity);
        }
        FolderEntity parentFolder = integratedFileEntity.getParentFolder();
        while (parentFolder != null && QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)parentFolder, project)) {
            QTestSyncStatusUtil.recursivelyAddStatus((IntegratedFileEntity)parentFolder, status, project);
            parentFolder = parentFolder.getParentFolder();
        }
    }

    public static void recursivelyRemoveStatus(IntegratedFileEntity integratedFileEntity, SyncStatus status, ProjectEntity project) throws Exception {
        Preconditions.checkNotNull((Object)integratedFileEntity);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isUnderTestCaseRoot(integratedFileEntity));
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isIntegrated(integratedFileEntity, project));
        QTestSyncStatusUtil.removeStatus(integratedFileEntity, status);
        if (integratedFileEntity instanceof TestCaseEntity) {
            TestCaseController.getInstance().updateTestCase((TestCaseEntity)integratedFileEntity);
        } else if (integratedFileEntity instanceof FolderEntity) {
            FolderController.getInstance().saveFolder((FolderEntity)integratedFileEntity);
        }
        FolderEntity parentFolder = integratedFileEntity.getParentFolder();
        if (QTestSyncStatusUtil.hasStatus((IntegratedFileEntity)parentFolder, status)) {
            QTestSyncStatusUtil.recursivelyRemoveStatusIfNoChildWithSameStatus(parentFolder, status, project);
        }
    }

    public static void recursivelyRemoveStatusIfNoChildWithSameStatus(FolderEntity folderEntity, SyncStatus status, ProjectEntity project) throws Exception {
        Preconditions.checkNotNull((Object)folderEntity);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isUnderTestCaseRoot((IntegratedFileEntity)folderEntity));
        Preconditions.checkArgument((boolean)QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)folderEntity, project));
        FolderEntity currentFolder = folderEntity;
        while (currentFolder != null && QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)currentFolder, project) && QTestSyncStatusUtil.hasStatus((IntegratedFileEntity)currentFolder, status)) {
            boolean hasNoChildWithSameStatus = true;
            for (FileEntity childEntity : FolderController.getInstance().getChildren(currentFolder)) {
                IntegratedFileEntity integratedChildEntity;
                if (!(childEntity instanceof IntegratedFileEntity) || !QTestIntegrationUtil.isIntegrated(integratedChildEntity = (IntegratedFileEntity)childEntity, project) || !QTestSyncStatusUtil.hasStatus(integratedChildEntity, status)) continue;
                hasNoChildWithSameStatus = false;
                break;
            }
            if (hasNoChildWithSameStatus) {
                QTestSyncStatusUtil.removeStatus((IntegratedFileEntity)currentFolder, status);
                FolderController.getInstance().saveFolder(currentFolder);
            }
            currentFolder = currentFolder.getParentFolder();
        }
    }

    private static void addStatus(IntegratedFileEntity integratedFileEntity, SyncStatus status) {
        List<SyncStatus> statuses = QTestSyncStatusUtil.getStatuses(integratedFileEntity);
        if (!statuses.contains((Object)status)) {
            statuses.add(status);
            QTestSyncStatusUtil.setStatuses(integratedFileEntity, statuses);
        }
    }

    private static void removeStatus(IntegratedFileEntity integratedFileEntity, SyncStatus status) {
        List<SyncStatus> statuses = QTestSyncStatusUtil.getStatuses(integratedFileEntity);
        if (statuses.contains((Object)status)) {
            statuses.remove((Object)status);
            QTestSyncStatusUtil.setStatuses(integratedFileEntity, statuses);
        }
    }

    private static boolean hasStatus(IntegratedFileEntity integratedFileEntity, SyncStatus status) {
        List<SyncStatus> statuses = QTestSyncStatusUtil.getStatuses(integratedFileEntity);
        return statuses.contains((Object)status);
    }

    private static List<SyncStatus> getStatuses(IntegratedFileEntity integratedFileEntity) {
        IntegratedEntity integratedEntity = QTestIntegrationUtil.getIntegratedEntity(integratedFileEntity);
        String statusString = (String)integratedEntity.getProperties().get("integrationStatus");
        if (StringUtils.isNotBlank((String)statusString)) {
            return new ArrayList<SyncStatus>((Collection)JsonUtil.fromJson((String)statusString, (Type)new TypeToken<List<SyncStatus>>(){}.getType()));
        }
        return new ArrayList<SyncStatus>();
    }

    private static void setStatuses(IntegratedFileEntity integratedFileEntity, List<SyncStatus> statuses) {
        IntegratedEntity integratedEntity = QTestIntegrationUtil.getIntegratedEntity(integratedFileEntity);
        String statusJson = JsonUtil.toJson(statuses);
        integratedEntity.getProperties().put("integrationStatus", statusJson);
    }
}

