/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.helper;

import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.exception.QTestAPIConnectionException;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

public class QTestAPIRequestHelper {
    private static HttpOptions buildHttpOptions(IQTestToken token) throws QTestInvalidFormatException {
        INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
        ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.SYSTEM);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token.getAccessTokenHeader());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        return httpOptions;
    }

    public static String sendPostRequestViaAPI(String url, IQTestToken token, String body) throws QTestException {
        if (!QTestIntegrationAuthenticationManager.validateToken(token.getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(url);
            HttpResponse response = httpClient.jsonPost(uri, body, QTestAPIRequestHelper.buildHttpOptions(token));
            return response.getBody();
        }
        catch (HttpException | URISyntaxException ex) {
            throw new QTestAPIConnectionException(ex.getMessage());
        }
    }

    public static String sendPutRequestViaAPI(String url, IQTestToken token, String body) throws QTestException {
        if (!QTestIntegrationAuthenticationManager.validateToken(token.getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(url);
            HttpResponse response = httpClient.jsonPut(uri, body, QTestAPIRequestHelper.buildHttpOptions(token));
            return response.getBody();
        }
        catch (HttpException | URISyntaxException ex) {
            throw new QTestAPIConnectionException(ex.getMessage());
        }
    }

    public static String sendGetRequestViaAPI(String url, IQTestToken token) throws QTestException {
        if (!QTestIntegrationAuthenticationManager.validateToken(token.getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(url);
            HttpResponse response = httpClient.get(uri, QTestAPIRequestHelper.buildHttpOptions(token));
            return response.getBody();
        }
        catch (HttpException | URISyntaxException ex) {
            throw new QTestAPIConnectionException(ex.getMessage());
        }
    }
}

