/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.model;

import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ErrorCollector {
    protected Map<TestCaseEntity, Throwable> errorLookup = new HashMap<TestCaseEntity, Throwable>();

    public void addError(TestCaseEntity testCase, Throwable error) {
        this.errorLookup.put(testCase, error);
    }

    public void addErrors(ErrorCollector errorCollector) {
        this.errorLookup.putAll(errorCollector.errorLookup);
    }

    public boolean hasError(TestCaseEntity testCase) {
        return this.errorLookup.containsKey(testCase);
    }

    public Throwable getError(TestCaseEntity testCase) {
        return this.errorLookup.get(testCase);
    }

    public List<TestCaseEntity> getAllTestCasesWithErrors() {
        return Collections.unmodifiableList(new ArrayList<TestCaseEntity>(this.errorLookup.keySet()));
    }

    protected Map<TestCaseEntity, Throwable> getErrorLookup() {
        return Collections.unmodifiableMap(this.errorLookup);
    }
}

