/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.model;

import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.ErrorCollector;
import com.kms.katalon.integration.qtest.model.QTestTestCaseDiff;
import com.kms.katalon.integration.qtest.model.QTestTestCaseDiffType;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.qas.api.internal.util.google.base.Preconditions;

public class ParityReportSummary
extends ErrorCollector {
    private List<TestCaseEntity> testCases = new ArrayList<TestCaseEntity>();
    private List<TestCaseEntity> integratedTestCases = new ArrayList<TestCaseEntity>();
    private List<QTestTestCaseDiff> versionDiffs = new ArrayList<QTestTestCaseDiff>();
    private List<QTestTestCaseDiff> testStepDiffs = new ArrayList<QTestTestCaseDiff>();

    private ParityReportSummary() {
    }

    public List<TestCaseEntity> getTestCases() {
        return this.testCases;
    }

    public List<TestCaseEntity> getIntegratedTestCases() {
        return this.integratedTestCases;
    }

    public List<QTestTestCaseDiff> getVersionDiffs() {
        return this.versionDiffs;
    }

    public List<QTestTestCaseDiff> getTestStepDiffs() {
        return this.testStepDiffs;
    }

    public boolean hasTestCaseWithVersionChanged() {
        return this.versionDiffs.size() > 0;
    }

    public boolean hasTestCaseWithTestStepsChanged() {
        return this.testStepDiffs.size() > 0;
    }

    public static ParityReportSummary getSummaryForTestCases(List<TestCaseEntity> testCases) throws Exception {
        Preconditions.checkNotNull(testCases);
        ParityReportSummary summary = new ParityReportSummary();
        for (TestCaseEntity testCase : testCases) {
            summary.testCases.add(testCase);
            IntegratedEntity integratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCase);
            if (integratedEntity == null) continue;
            summary.integratedTestCases.add(testCase);
            QTestTestCase localQTestTestCase = QTestIntegrationTestCaseManager.getQTestTestCaseByIntegratedEntity(integratedEntity);
            QTestProject qTestProject = ParityReportSummary.getQTestProject(testCase);
            ProjectEntity projectEntity = testCase.getProject();
            QTestTestCase remoteQTestTestCase = null;
            try {
                remoteQTestTestCase = QTestIntegrationTestCaseManager.getTestCaseFromQTest(ParityReportSummary.getQTestCredential(projectEntity), qTestProject.getId(), localQTestTestCase.getId(), null, true);
            }
            catch (Exception e) {
                summary.addError(testCase, e);
                continue;
            }
            if (remoteQTestTestCase.getVersion().equals(localQTestTestCase.getVersion())) continue;
            QTestTestCaseDiff versionDiff = ParityReportSummary.generateDiff(QTestTestCaseDiffType.VERSION, testCase, localQTestTestCase, remoteQTestTestCase);
            summary.versionDiffs.add(versionDiff);
            String qTestStepDescription = QTestIntegrationUtil.getListTestStepDescription(remoteQTestTestCase);
            String testCaseComment = testCase.getComment().trim();
            if (StringUtils.equals((String)qTestStepDescription, (String)testCaseComment)) continue;
            QTestTestCaseDiff testStepDiff = ParityReportSummary.generateDiff(QTestTestCaseDiffType.TEST_STEPS, testCase, localQTestTestCase, remoteQTestTestCase);
            summary.testStepDiffs.add(testStepDiff);
        }
        return summary;
    }

    private static QTestProject getQTestProject(TestCaseEntity testCaseEntity) throws Exception {
        ProjectEntity projectEntity = testCaseEntity.getProject();
        FolderEntity folderEntity = testCaseEntity.getParentFolder();
        QTestProject qTestProject = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)folderEntity, projectEntity).getQTestProject();
        return qTestProject;
    }

    private static IQTestCredential getQTestCredential(ProjectEntity project) {
        String projectDir = project.getFolderLocation();
        return QTestSettingCredential.getCredential(projectDir);
    }

    private static QTestTestCaseDiff generateDiff(QTestTestCaseDiffType type, TestCaseEntity testCaseEntity, QTestTestCase oldTestCase, QTestTestCase newTestCase) {
        QTestTestCaseDiff diff = new QTestTestCaseDiff();
        diff.setDiffType(type);
        diff.setTestCaseEntity(testCaseEntity);
        diff.setOldQTestTestCase(oldTestCase);
        diff.setNewQTestTestCase(newTestCase);
        return diff;
    }
}

