/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java;

import io.cucumber.eclipse.editor.EnvelopeReader;
import io.cucumber.eclipse.editor.validation.DocumentValidator;
import io.cucumber.eclipse.java.validation.JavaGlueStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "io.cucumber.eclipse.java";
    private static Activator plugin;
    private ServiceTracker<EnvelopeReader, EnvelopeReader> envelopeReaderTracker;
    private IPropertyChangeListener propertyChangeListener;
    private ServiceTracker<JavaGlueStore, JavaGlueStore> glueStoreTracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.envelopeReaderTracker = new ServiceTracker(context, EnvelopeReader.class, null);
        this.envelopeReaderTracker.open();
        this.glueStoreTracker = new ServiceTracker(context, JavaGlueStore.class, null);
        this.glueStoreTracker.open();
        this.propertyChangeListener = event -> DocumentValidator.revalidateAllDocuments();
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.envelopeReaderTracker != null) {
            this.envelopeReaderTracker.close();
            this.envelopeReaderTracker = null;
        }
        if (this.glueStoreTracker != null) {
            this.glueStoreTracker.close();
            this.glueStoreTracker = null;
        }
        if (this.propertyChangeListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static EnvelopeReader getEnvelopeReader() {
        Activator activator = Activator.getDefault();
        if (activator == null || activator.envelopeReaderTracker == null) {
            return null;
        }
        return (EnvelopeReader)activator.envelopeReaderTracker.getService();
    }

    public static JavaGlueStore getJavaGlueStore() {
        Activator activator = Activator.getDefault();
        if (activator == null || activator.glueStoreTracker == null) {
            return null;
        }
        return (JavaGlueStore)activator.glueStoreTracker.getService();
    }
}

