/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.launching;

import io.cucumber.eclipse.editor.EditorLogging;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.ConsolePlugin;

public class CucumberFeatureLaunchUtils {
    private CucumberFeatureLaunchUtils() {
    }

    protected static IProject getProject() {
        IEditorPart part;
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null) {
            IFileEditorInput input = (IFileEditorInput)part.getEditorInput();
            IFile file = input.getFile();
            IProject activeProject = file.getProject();
            return activeProject;
        }
        return null;
    }

    public static boolean isAnsiConsoleEnabled() {
        ConsolePlugin.getDefault().getPreferenceStore().getBoolean("ANSI_support_enabled");
        return false;
    }

    protected static String getFeaturePath() {
        IEditorPart part;
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null) {
            IFileEditorInput input = (IFileEditorInput)part.getEditorInput();
            return input.getFile().getLocation().toString();
        }
        return null;
    }

    public static void updateFromConfig(ILaunchConfiguration config, String attrib, Text text) {
        String s = "";
        try {
            s = config.getAttribute(attrib, "");
        }
        catch (CoreException e) {
            EditorLogging.error((String)("Failed to read launch configuration attribute: " + attrib), (Throwable)e);
        }
        text.setText(s);
    }

    public static boolean updateFromConfig(ILaunchConfiguration config, String attrib) {
        return CucumberFeatureLaunchUtils.getAttribute(config, attrib, false);
    }

    public static boolean getAttribute(ILaunchConfiguration config, String attrib, boolean defaultValue) {
        try {
            return config.getAttribute(attrib, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }
}

