/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.launching;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.eclipse.editor.EditorLogging;
import io.cucumber.eclipse.editor.Tracing;
import io.cucumber.eclipse.editor.console.CucumberConsole;
import io.cucumber.eclipse.editor.console.CucumberConsoleFactory;
import io.cucumber.eclipse.editor.debug.GherkingBreakpoint;
import io.cucumber.eclipse.editor.debug.GherkingDebugTarget;
import io.cucumber.eclipse.editor.debug.GherkingStepStackFrame;
import io.cucumber.eclipse.editor.debug.GherkingThread;
import io.cucumber.eclipse.editor.document.GherkinMessageHandler;
import io.cucumber.eclipse.editor.document.TestStepEvent;
import io.cucumber.eclipse.editor.launching.EnvelopeListener;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.launching.CucumberFeatureLaunchConstants;
import io.cucumber.eclipse.java.launching.CucumberFeatureLaunchUtils;
import io.cucumber.eclipse.java.launching.CucumberRuntimeLauncher;
import io.cucumber.eclipse.java.launching.FileResource;
import io.cucumber.eclipse.java.launching.MessageEndpointProcess;
import io.cucumber.eclipse.java.plugins.CucumberEclipsePlugin;
import io.cucumber.eclipse.java.runtime.CucumberRuntime;
import io.cucumber.tagexpressions.Expression;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CucumberFeatureLocalApplicationLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        MessageEndpointProcess endpoint;
        Mode launchMode = Mode.parseString((String)mode);
        String withLine = config.getAttribute("cucumber feature_with_line", "");
        String tags = config.getAttribute("cucumber tags", "");
        IVMInstall vm = this.verifyVMInstall(config);
        IVMRunner runner = vm.getVMRunner(mode);
        String[][] classpathAndModules = this.getClasspathAndModulepath(config);
        VMRunnerConfiguration runConfig = this.createRunConfig(classpathAndModules);
        this.verifyWorkingDirectory(config);
        String[] bootpath = this.getBootpath(config);
        runConfig.setBootClassPath(bootpath);
        String[] modulepath = classpathAndModules[1];
        runConfig.setModulepath(modulepath);
        runConfig.setVMArguments(DebugPlugin.parseArguments((String)this.getVMArguments(config)));
        runConfig.setWorkingDirectory(this.getWorkingDirectory(config).getAbsolutePath());
        String featurePath = "";
        String gluePath = "";
        boolean isMonochrome = false;
        boolean isPretty = false;
        boolean isProgress = false;
        boolean isJunit = false;
        boolean isJson = false;
        boolean isHtml = false;
        boolean isRerun = false;
        boolean isUsage = false;
        featurePath = CucumberFeatureLocalApplicationLaunchConfigurationDelegate.substituteVar(config.getAttribute("cucumber feature", featurePath));
        gluePath = config.getAttribute("glue path", gluePath);
        isMonochrome = config.getAttribute("is monochrome?", isMonochrome);
        isPretty = config.getAttribute("is pretty formatter?", isPretty);
        isProgress = config.getAttribute("is progress formatter?", isProgress);
        isJunit = config.getAttribute("is junit formatter", isJunit);
        isJson = config.getAttribute("is json formatter?", isJson);
        isHtml = config.getAttribute("is html formatter?", isHtml);
        isRerun = config.getAttribute("is rerun formatter", isRerun);
        isUsage = config.getAttribute("is usage formatter", isUsage);
        if (Tracing.DEBUG_LAUNCHING_ENABLED) {
            Tracing.get().trace("/debug/launching", "Launching feature: " + featurePath);
            Tracing.get().trace("/debug/launching", "Glue path: " + gluePath);
            Tracing.get().trace("/debug/launching", "monochrome:" + isMonochrome + ", pretty:" + isPretty + ", progress:" + isProgress + ", html:" + isHtml + ", json:" + isJson + ", junit:" + isJunit + ", usage:" + isUsage + ", rerun:" + isRerun);
        }
        String glue = "--glue";
        String formatter = "--plugin";
        ArrayList<String> args = new ArrayList<String>();
        if (withLine.isBlank()) {
            args.add(featurePath);
        } else {
            args.add(withLine);
        }
        args.add(glue);
        args.add(gluePath);
        if (isPretty) {
            args.add(formatter);
            args.add("pretty");
        }
        if (isJson) {
            args.add(formatter);
            args.add("json");
        }
        if (isJunit) {
            args.add(formatter);
            args.add("junit:STDOUT");
        }
        if (isProgress) {
            args.add(formatter);
            args.add("progress");
        }
        if (isRerun) {
            args.add(formatter);
            args.add("rerun");
        }
        if (isHtml) {
            args.add(formatter);
            args.add("html:target");
        }
        if (isUsage) {
            args.add(formatter);
            args.add("usage");
        }
        if (!CucumberFeatureLaunchUtils.isAnsiConsoleEnabled()) {
            args.add("--monochrome");
        }
        if (!tags.isBlank()) {
            args.add("--tags");
            args.add(tags);
        }
        try {
            endpoint = new MessageEndpointProcess(launch);
            endpoint.addArguments(args);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Can't create remote process communication channel", (Throwable)e));
        }
        try {
            args.addAll(Arrays.asList(DebugPlugin.parseArguments((String)this.getProgramArguments(config))));
            String[] finalArgs = args.toArray(new String[0]);
            runConfig.setProgramArguments(finalArgs);
            endpoint.start();
            launch.addProcess((IProcess)endpoint);
            if (launchMode == Mode.DEBUG) {
                final GherkingDebugTarget debugTarget = new GherkingDebugTarget(launch, (IProcess)endpoint, "cucumber-jvm");
                final IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(GherkingBreakpoint.MODEL_ID);
                endpoint.addEnvelopeListener((EnvelopeListener)new GherkinMessageHandler(){
                    private volatile boolean suspendOnNextStep;

                    protected void handleTestStepStart(TestStepEvent event) {
                        try {
                            if (this.suspendOnNextStep) {
                                this.suspendOnNextStep = false;
                                GherkingThread thread = debugTarget.getThread();
                                thread.suspend(this.trace(event, thread), 2).await();
                                return;
                            }
                            IBreakpoint[] iBreakpointArray = breakpoints;
                            int n = breakpoints.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GherkingBreakpoint gbp;
                                IBreakpoint breakpoint = iBreakpointArray[n2];
                                if (breakpoint instanceof GherkingBreakpoint && (long)(gbp = (GherkingBreakpoint)breakpoint).getLineNumber() == event.getStep().getLocation().getLine()) {
                                    GherkingThread thread = debugTarget.getThread();
                                    thread.suspend((IBreakpoint)gbp, this.trace(event, thread)).await();
                                    return;
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException e) {
                            EditorLogging.error((String)"Debug event processing failed", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            EditorLogging.error((String)"Debug event processing interrupted", (Throwable)e);
                        }
                    }

                    private IStackFrame[] trace(TestStepEvent event, GherkingThread thread) {
                        IStackFrame[] stackFrames;
                        IStackFrame[] iStackFrameArray = stackFrames = event.getStackTrace((IThread)thread);
                        int n = stackFrames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStackFrame frame = iStackFrameArray[n2];
                            if (frame instanceof GherkingStepStackFrame) {
                                GherkingStepStackFrame stepStackFrame = (GherkingStepStackFrame)frame;
                                stepStackFrame.setStepOverHandler(() -> {
                                    this.suspendOnNextStep = true;
                                    thread.resume();
                                });
                            }
                            ++n2;
                        }
                        return stackFrames;
                    }
                });
                launch.addDebugTarget((IDebugTarget)debugTarget);
            }
            runner.run(runConfig, launch, monitor);
        }
        catch (CoreException core) {
            endpoint.terminate();
            throw core;
        }
        catch (RuntimeException runtime) {
            endpoint.terminate();
            throw runtime;
        }
    }

    private void runEmbedded(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block12: {
            String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            IJavaProject project = JDTUtil.getJavaProject(projectName);
            if (project == null) {
                throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Project with name '" + projectName + "' not found"));
            }
            String featurePath = config.getAttribute("cucumber feature", "");
            IResource resource = project.getProject().findMember(featurePath);
            if (resource instanceof IFile) {
                Optional<Feature> feature = CucumberRuntime.loadFeature(new FileResource((IFile)resource));
                if (feature.isPresent()) {
                    ArrayList<FeatureWithLines> featureFilter = new ArrayList<FeatureWithLines>();
                    ArrayList<Expression> tagFilters = new ArrayList<Expression>();
                    Throwable throwable = null;
                    Object var13_14 = null;
                    try (CucumberConsole console = CucumberConsoleFactory.getConsole((boolean)true);){
                        CucumberRuntimeLauncher.runFeaturesEmbedded(project, Collections.singletonList(feature.get()), featureFilter, Mode.parseString((String)mode), console, monitor, tagFilters);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "no feature present in '" + featurePath + "'."));
            }
            throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "feature '" + featurePath + "' not found"));
        }
    }

    private VMRunnerConfiguration createRunConfig(String[][] classpathAndModules) {
        ArrayList<String> classPath = new ArrayList<String>(Arrays.asList(classpathAndModules[0]));
        try {
            File file = FileLocator.getBundleFile((Bundle)FrameworkUtil.getBundle(CucumberEclipsePlugin.class));
            if (file != null) {
                if (file.isDirectory() && !new File(file, "io").exists()) {
                    File binDirectory = new File(file, "bin");
                    if (binDirectory.exists()) {
                        file = binDirectory;
                    } else {
                        File targetDirectory = new File(file, "target/classes");
                        if (targetDirectory.exists()) {
                            file = targetDirectory;
                        }
                    }
                }
                classPath.add(file.getAbsolutePath());
            }
        }
        catch (IOException file) {
            // empty catch block
        }
        String[] finalClassPath = (String[])classPath.toArray(String[]::new);
        if (Tracing.DEBUG_LAUNCHING_ENABLED) {
            String[] stringArray = finalClassPath;
            int n = finalClassPath.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                Tracing.get().trace("/debug/launching", "Classpath entry: " + string);
                ++n2;
            }
        }
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(CucumberFeatureLaunchConstants.CUCUMBER_API_CLI_MAIN, finalClassPath);
        return runConfig;
    }

    private static String substituteVar(String s) {
        if (s == null) {
            return s;
        }
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
        }
        catch (CoreException e) {
            EditorLogging.error((String)("Could not substitute variable: " + s), (Throwable)e);
            return null;
        }
    }
}

