/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.plugins;

import java.util.Arrays;
import java.util.Objects;

public final class CucumberCodeLocation {
    private final String type;
    private final String methodName;
    private final String[] parameter;
    private final String returnType;
    private String location;

    public CucumberCodeLocation(String location) {
        this.location = location;
        String typeInfo = CucumberCodeLocation.prefixOfChar(location, '(', true);
        this.returnType = CucumberCodeLocation.prefixOfChar(typeInfo, ' ', true);
        this.type = CucumberCodeLocation.prefixOfChar(typeInfo.substring(this.returnType.length()), '.', false).trim();
        this.methodName = CucumberCodeLocation.suffixOfChar(typeInfo, '.', false);
        String parameterInfo = CucumberCodeLocation.prefixOfChar(CucumberCodeLocation.suffixOfChar(location, '(', true), ')', true);
        if (parameterInfo.isBlank()) {
            this.parameter = new String[0];
        } else {
            this.parameter = parameterInfo.split(",");
            int i = 0;
            while (i < this.parameter.length) {
                this.parameter[i] = this.parameter[i].trim();
                ++i;
            }
        }
    }

    public String getTypeName() {
        return this.type;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CucumberCodeLocation other = (CucumberCodeLocation)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return this.location + " [type=" + this.type + ", methodName=" + this.methodName + ", parameter=" + Arrays.toString(this.parameter) + ", returnType=" + this.returnType + "]";
    }

    private static String prefixOfChar(String string, char c, boolean first) {
        int index = first ? string.indexOf(c) : string.lastIndexOf(c);
        return index > 0 ? string.substring(0, index) : "";
    }

    private static String suffixOfChar(String string, char c, boolean first) {
        int index = first ? string.indexOf(c) : string.lastIndexOf(c);
        return index > 0 ? string.substring(index + 1, string.length()) : "";
    }

    public static void main(String[] args) {
        System.out.println(new CucumberCodeLocation("io.cucumber.examples.java.RpnCalculatorSteps.the_result_is(double)"));
        System.out.println(new CucumberCodeLocation("io.cucumber.examples.java.RpnCalculatorSteps.thePreviousEntries(java.util.List<io.cucumber.examples.java.RpnCalculatorSteps$Entry>)"));
        System.out.println(new CucumberCodeLocation("io.cucumber.examples.java.RpnCalculatorSteps.a_calculator_I_just_turned_on()"));
        System.out.println(new CucumberCodeLocation("io.cucumber.examples.java.RpnCalculatorSteps.I_press(java.lang.String)"));
        System.out.println(new CucumberCodeLocation("io.cucumber.examples.java.RpnCalculatorSteps.adding(int,int)"));
        System.out.println(new CucumberCodeLocation("void io.cucumber.examples.java.RpnCalculatorSteps.givenClientIsAvailable()"));
    }
}

