/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.preferences;

import io.cucumber.eclipse.editor.EditorReconciler;
import io.cucumber.eclipse.java.CucumberJavaUIMessages;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferences;
import io.cucumber.eclipse.java.preferences.GlueCodePackageTable;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CucumberJavaPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "cucumber.eclipse.editor.steps.jdt.CucumberJavaPreferencesPage";
    private Button showHookAnnotations;
    private GlueCodePackageTable glueCodePackageTable;
    private CucumberJavaPreferences javaPreferences = CucumberJavaPreferences.of();

    public CucumberJavaPreferencesPage() {
        this.setPreferenceStore(this.javaPreferences.store());
        this.setTitle(CucumberJavaUIMessages.CucumberJavaPreferencesPage__title);
        this.setDescription(CucumberJavaUIMessages.CucumberJavaPreferencesPage__description);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void createStepFilterPreferences(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        this.glueCodePackageTable = new GlueCodePackageTable(container){

            @Override
            protected String getFilter(boolean active, boolean defaults) {
                IPreferenceStore store = CucumberJavaPreferencesPage.this.getPreferenceStore();
                if (active) {
                    if (defaults) {
                        return store.getDefaultString("io.cucumber.eclipse.java.active_filters");
                    }
                    return store.getString("io.cucumber.eclipse.java.active_filters");
                }
                if (defaults) {
                    return store.getDefaultString("io.cucumber.eclipse.java.inactive_filters");
                }
                return store.getString("io.cucumber.eclipse.java.inactive_filters");
            }
        };
        this.showHookAnnotations = CucumberJavaPreferencesPage.createHookButton(container, this.javaPreferences.showHooks());
    }

    public static Button createHookButton(Composite container, boolean initialValue) {
        Button btn = new Button(container, 32);
        btn.setText("Show Hook Annotations in Feature files");
        btn.setSelection(initialValue);
        return btn;
    }

    public boolean performOk() {
        GlueCodePackageTable.FilterStrings filterStrings = this.glueCodePackageTable.getFilters();
        this.getPreferenceStore().setValue("io.cucumber.eclipse.java.active_filters", filterStrings.active());
        this.getPreferenceStore().setValue("io.cucumber.eclipse.java.inactive_filters", filterStrings.inactive());
        CucumberJavaPreferences.setShowHooks(this.getPreferenceStore(), this.showHookAnnotations.getSelection());
        boolean result = super.performOk();
        if (result) {
            EditorReconciler.reconcileAllFeatureEditors();
        }
        return result;
    }

    protected void performDefaults() {
        this.glueCodePackageTable.performDefaults();
        this.showHookAnnotations.setSelection(this.getPreferenceStore().getDefaultBoolean("io.cucumber.eclipse.java.show_hooks"));
        super.performDefaults();
    }
}

