/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.preferences;

import io.cucumber.eclipse.java.CucumberJavaUIMessages;
import io.cucumber.eclipse.java.preferences.CreateStepDefinitionsFilterDialog;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferences;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.filtertable.Filter;
import org.eclipse.jdt.internal.ui.filtertable.FilterLabelProvider;
import org.eclipse.jdt.internal.ui.filtertable.FilterViewerComparator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class GlueCodePackageTable {
    private Button fAddPackageButton;
    private Button fRemoveFilterButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private CheckboxTableViewer fTableViewer;
    private Group group;

    public GlueCodePackageTable(Composite container) {
        this.group = new Group(container, 0);
        this.group.setText(" Cucumber Glue Packages ");
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)this.group, (int)68354);
        this.fTableViewer.getTable().setFont(container.getFont());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fTableViewer.setComparator((ViewerComparator)new FilterViewerComparator());
        this.fTableViewer.setContentProvider((IContentProvider)new StepDefinitionsFilterContentProvider());
        this.fTableViewer.setInput((Object)this.getAllStoredFilters(false));
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((Filter)event.getElement()).setChecked(event.getChecked());
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    GlueCodePackageTable.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    GlueCodePackageTable.this.fRemoveFilterButton.setEnabled(true);
                }
            }
        });
        this.fTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                GlueCodePackageTable.this.handleFilterViewerKeyPress(event);
            }
        });
        this.createStepFilterButtons((Composite)this.group);
    }

    private void handleFilterViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeFilters();
        }
    }

    private void initTableState(boolean defaults) {
        Filter[] filters = this.getAllStoredFilters(defaults);
        int i = 0;
        while (i < filters.length) {
            this.fTableViewer.add((Object)filters[i]);
            this.fTableViewer.setChecked((Object)filters[i], filters[i].isChecked());
            ++i;
        }
    }

    protected void addFilter(String filter, boolean checked) {
        if (filter != null) {
            Filter f = new Filter(filter, checked);
            this.fTableViewer.add((Object)f);
            this.fTableViewer.setChecked((Object)f, checked);
        }
    }

    protected Filter[] getAllFiltersFromTable() {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        Filter[] filters = new Filter[items.length];
        int i = 0;
        while (i < items.length) {
            filters[i] = (Filter)items[i].getData();
            filters[i].setChecked(items[i].getChecked());
            ++i;
        }
        return filters;
    }

    public FilterStrings getFilters() {
        ArrayList<String> active = new ArrayList<String>();
        ArrayList<String> inactive = new ArrayList<String>();
        String name = "";
        Filter[] filters = this.getAllFiltersFromTable();
        int i = 0;
        while (i < filters.length) {
            name = filters[i].getName();
            if (filters[i].isChecked()) {
                active.add(name);
            } else {
                inactive.add(name);
            }
            ++i;
        }
        return new FilterStrings(CucumberJavaPreferences.serializeList(active.toArray(new String[active.size()])), CucumberJavaPreferences.serializeList(inactive.toArray(new String[inactive.size()])));
    }

    public void performDefaults() {
        this.fTableViewer.getTable().removeAll();
        this.initTableState(true);
    }

    protected Filter[] getAllStoredFilters(boolean defaults) {
        List<String> activefilters = CucumberJavaPreferences.parseList(this.getFilter(true, defaults));
        List<String> inactivefilters = CucumberJavaPreferences.parseList(this.getFilter(false, defaults));
        Filter[] filters = new Filter[activefilters.size() + inactivefilters.size()];
        int i = 0;
        while (i < activefilters.size()) {
            filters[i] = new Filter(activefilters.get(i), true);
            ++i;
        }
        i = 0;
        while (i < inactivefilters.size()) {
            filters[i + activefilters.size()] = new Filter(inactivefilters.get(i), false);
            ++i;
        }
        return filters;
    }

    protected abstract String getFilter(boolean var1, boolean var2);

    private void addFilter() {
        Filter newfilter = CreateStepDefinitionsFilterDialog.showCreateStepFilterDialog(this.getShell(), this.getAllFiltersFromTable());
        if (newfilter != null) {
            this.fTableViewer.add((Object)newfilter);
            this.fTableViewer.setChecked((Object)newfilter, true);
            this.fTableViewer.refresh((Object)newfilter);
        }
    }

    private void createStepFilterButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddPackageButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add__Package, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Choose_a_package_and_add_it_to_step_definitions_filters, null);
        this.fAddPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GlueCodePackageTable.this.addPackage();
            }
        });
        this.fRemoveFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage___Remove, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Remove_all_selected_step_filters, null);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GlueCodePackageTable.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        Label separator = new Label(buttonContainer, 0);
        separator.setVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSelectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Select_All, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Selects_all_step_filters, null);
        this.fSelectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GlueCodePackageTable.this.fTableViewer.setAllChecked(true);
            }
        });
        this.fDeselectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Deselect_All, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Deselects_all_step_filters, null);
        this.fDeselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GlueCodePackageTable.this.fTableViewer.setAllChecked(false);
            }
        });
    }

    private void addType() {
        try {
            Object[] types;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
            dialog.setTitle(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_type_to_step_filters);
            dialog.setMessage(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Select_a_type_to_filter_when_stepping);
            if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                IType type = (IType)types[0];
                this.addFilter(type.getFullyQualifiedName(), true);
            }
        }
        catch (JavaModelException jme) {
            ExceptionHandler.handle((CoreException)jme, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_type_to_step_filters, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Could_not_open_type_selection_dialog_for_step_filters);
        }
    }

    private Shell getShell() {
        return this.fTableViewer.getControl().getShell();
    }

    private void addPackage() {
        try {
            Object[] packages;
            ElementListSelectionDialog dialog = JDIDebugUIPlugin.createAllPackagesDialog((Shell)this.getShell(), null, (boolean)false);
            dialog.setTitle(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_package_to_step_filters);
            dialog.setMessage(CucumberJavaUIMessages.CucumberJavaPreferencesPage__Select_a_package_to_filter_when_stepping);
            dialog.setMultipleSelection(true);
            if (dialog.open() == 0 && (packages = dialog.getResult()) != null) {
                IJavaElement pkg = null;
                int i = 0;
                while (i < packages.length) {
                    pkg = (IJavaElement)packages[i];
                    String filter = pkg.getElementName() + ".*";
                    this.addFilter(filter, true);
                    ++i;
                }
            }
        }
        catch (JavaModelException jme) {
            ExceptionHandler.handle((CoreException)jme, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Add_package_to_step_filters, (String)CucumberJavaUIMessages.CucumberJavaPreferencesPage__Could_not_open_package_selection_dialog_for_step_filters);
        }
    }

    protected void removeFilters() {
        this.fTableViewer.remove(((IStructuredSelection)this.fTableViewer.getSelection()).toArray());
    }

    public void setEnabled(boolean enable) {
        this.fTableViewer.getControl().setEnabled(enable);
        this.fAddPackageButton.setEnabled(enable);
        this.fDeselectAllButton.setEnabled(enable);
        this.fRemoveFilterButton.setEnabled(enable);
        this.fSelectAllButton.setEnabled(enable);
        this.group.setEnabled(enable);
    }

    public Group getControl() {
        return this.group;
    }

    public record FilterStrings(String active, String inactive) {
    }

    class StepDefinitionsFilterContentProvider
    implements IStructuredContentProvider {
        public StepDefinitionsFilterContentProvider() {
            GlueCodePackageTable.this.initTableState(false);
        }

        public Object[] getElements(Object inputElement) {
            return GlueCodePackageTable.this.getAllFiltersFromTable();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

