/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.properties;

import io.cucumber.eclipse.editor.EditorReconciler;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferencesPage;
import io.cucumber.eclipse.java.preferences.GlueCodePackageTable;
import io.cucumber.eclipse.java.properties.CucumberJavaBackendProperties;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.BorderData;
import org.eclipse.swt.layout.BorderLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;

public class JavaBackendPropertyPage
extends PropertyPage {
    private Text validationPlugins;
    private Button enableProjectSpecific;
    private GlueCodePackageTable glueCodePackageTable;
    private Button hookButton;

    public JavaBackendPropertyPage() {
        this.setTitle("Cucumber Java Options");
        this.setDescription("Here you can configure Java related Cucumber options");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addValidationOption(composite);
        return composite;
    }

    private void addValidationOption(final Composite parent) {
        IResource resource = this.getResource();
        final IEclipsePreferences node = CucumberJavaBackendProperties.getNode(resource);
        Label label = new Label(parent, 0);
        label.setText("Validation Plugins ");
        label.setToolTipText("A comma seperated list of plugins that should be used for validation regardless of feature settings");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new BorderLayout());
        this.validationPlugins = new Text(composite, 2048);
        this.validationPlugins.setLayoutData((Object)new BorderData(0x1000000));
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.validationPlugins.setText(node.get("validationPlugins", ""));
        Button button = new Button(composite, 8);
        button.setText("Add");
        button.setLayoutData((Object)new BorderData(131072));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(parent.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createWorkspaceScope(), 0);
                dialog.setTitle(ActionMessages.OpenTypeInHierarchyAction_dialogTitle);
                dialog.setMessage(ActionMessages.OpenTypeInHierarchyAction_dialogMessage);
                int result = dialog.open();
                if (result != 0) {
                    return;
                }
                Object[] types = dialog.getResult();
                if (types != null && types.length > 0) {
                    JavaBackendPropertyPage.this.validationPlugins.setText(Stream.concat(CucumberJavaBackendProperties.parseList(JavaBackendPropertyPage.this.validationPlugins.getText()), Stream.of(types).filter(IType.class::isInstance).map(IType.class::cast).map(IType::getFullyQualifiedName)).collect(JavaBackendPropertyPage.joinPlugins()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData labelData = new GridData(768);
        labelData.horizontalSpan = 2;
        this.enableProjectSpecific = new Button(parent, 32);
        this.enableProjectSpecific.setText("Enable project specific settings");
        this.enableProjectSpecific.setSelection(node.getBoolean("enableProjectSpecific", false));
        this.enableProjectSpecific.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaBackendPropertyPage.this.updateUI();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableProjectSpecific.setLayoutData((Object)labelData);
        new Label(parent, 2).setLayoutData((Object)labelData);
        this.glueCodePackageTable = new GlueCodePackageTable(parent){

            @Override
            protected String getFilter(boolean active, boolean defaults) {
                if (defaults) {
                    return "";
                }
                if (active) {
                    return node.get("activeFilters", "");
                }
                return node.get("inactiveFilters", "");
            }
        };
        this.hookButton = CucumberJavaPreferencesPage.createHookButton(parent, node.getBoolean("enableShowHook", false));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.hookButton.setLayoutData((Object)gd);
        ((GridData)this.glueCodePackageTable.getControl().getLayoutData()).horizontalSpan = 2;
        this.updateUI();
    }

    private void updateUI() {
        boolean enable = this.enableProjectSpecific.getSelection();
        this.glueCodePackageTable.setEnabled(enable);
        this.hookButton.setEnabled(enable);
    }

    private IResource getResource() {
        return (IResource)this.getElement().getAdapter(IResource.class);
    }

    private static Collector<CharSequence, ?, String> joinPlugins() {
        return Collectors.joining(", ");
    }

    protected void performDefaults() {
        super.performDefaults();
        this.validationPlugins.setText("");
        this.glueCodePackageTable.performDefaults();
        this.hookButton.setSelection(false);
    }

    public boolean performOk() {
        IEclipsePreferences node = CucumberJavaBackendProperties.getNode(this.getResource());
        node.put("validationPlugins", this.validationPlugins.getText());
        node.putBoolean("enableProjectSpecific", this.enableProjectSpecific.getSelection());
        GlueCodePackageTable.FilterStrings filters = this.glueCodePackageTable.getFilters();
        node.put("activeFilters", filters.active());
        node.put("inactiveFilters", filters.inactive());
        node.putBoolean("enableShowHook", this.hookButton.getSelection());
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        EditorReconciler.reconcileAllFeatureEditors();
        return true;
    }
}

